#!/usr/sbin/sh
export PATH='/sbin:/usr/sbin:/bin:/usr/bin'

`/usr/sbin/getipv6`

if [ "$REQUEST_METHOD" == "POST" ]; then
	
	read -t 1 POST_CONTENT
	
	IPV6_ENABLE=`printf "%s" "$POST_CONTENT" | sed 's/&/\n/g' | grep '^ipv6_enable=' | sed 's/^[^=]*=//'`
	IPV6_FORWARD=`printf "%s" "$POST_CONTENT" | sed 's/&/\n/g' | grep '^ipv6_forward=' | sed 's/^[^=]*=//'`
	RADVD_ENABLE=`printf "%s" "$POST_CONTENT" | sed 's/&/\n/g' | grep '^radvd_enable=' | sed 's/^[^=]*=//'`
	RADVD_PREFIX=`printf "%s" "$POST_CONTENT" | sed 's/&/\n/g' | grep '^radvd_prefix=' | sed 's/^[^=]*=//' | sed 's/%3A/:/g' | sed 's/[^0-9a-fA-F:]//g'`
	RADVD_MINRTRADV=`printf "%s" "$POST_CONTENT" | sed 's/&/\n/g' | grep '^radvd_minrtradv=' | sed 's/^[^=]*=//' | sed 's/[^0-9]//g'`
	RADVD_MAXRTRADV=`printf "%s" "$POST_CONTENT" | sed 's/&/\n/g' | grep '^radvd_maxrtradv=' | sed 's/^[^=]*=//' | sed 's/[^0-9]//g'`
	RADVD_ADVPREFLT=`printf "%s" "$POST_CONTENT" | sed 's/&/\n/g' | grep '^radvd_advpreflt=' | sed 's/^[^=]*=//' | sed 's/[^0-9]//g'`
	RADVD_ADVVALIDLT=`printf "%s" "$POST_CONTENT" | sed 's/&/\n/g' | grep '^radvd_advvalidlt=' | sed 's/^[^=]*=//' | sed 's/[^0-9]//g'`
	
	if [ "$RADVD_PREFIX" == "" ]; then
		if [ "$PREFIX" != "" ]; then
			RADVD_PREFIX=$PREFIX
		fi
	fi
	if [ "$RADVD_MINRTRADV" == "" ]; then
		RADVD_MINRTRADV=5
	fi
	if [ "$RADVD_MAXRTRADV" == "" ]; then
		RADVD_MAXRTRADV=15
	fi
	if [ "$RADVD_ADVPREFLT" == "" ]; then
		RADVD_ADVPREFLT=30
	fi
	if [ "$RADVD_ADVVALIDLT" == "" ]; then
		RADVD_ADVVALIDLT=50
	fi
	
	if [ "$IPV6_ENABLE" == "on" ]; then
		nvram set ipv6_enable=1
		echo 1 > /proc/sys/net/ipv6/conf/all/accept_ra
		echo 1 > /proc/sys/net/ipv6/conf/default/accept_ra
		echo 0 > /proc/sys/net/ipv6/conf/ath0/accept_ra
		echo 0 > /proc/sys/net/ipv6/conf/eth0/accept_ra
		echo 0 > /proc/sys/net/ipv6/conf/br0/accept_ra
		echo 0 > /proc/sys/net/ipv6/conf/wifi0/accept_ra
		if [ "$PREFIX" != "" ]; then
			route -A inet6 add $PREFIX/64 dev br0 >& /dev/null
		fi
	else
		nvram set ipv6_enable=0
		echo 0 > /proc/sys/net/ipv6/conf/all/accept_ra
		echo 0 > /proc/sys/net/ipv6/conf/default/accept_ra
	fi
	
	if [ "$IPV6_FORWARD" == "on" ]; then
		nvram set ipv6_forward=1
		echo 1 > /proc/sys/net/ipv6/conf/all/forwarding
		echo 0 > /proc/sys/net/ipv6/conf/default/forwarding
	else
		nvram set ipv6_forward=0
		echo 0 > /proc/sys/net/ipv6/conf/all/forwarding
		echo 0 > /proc/sys/net/ipv6/conf/default/forwarding
	fi
	
	if [ "$RADVD_ENABLE" == "on" ]; then
		nvram set radvd_enable=1
	else
		nvram set radvd_enable=0
	fi
	
	nvram set "radvd_prefix=$RADVD_PREFIX"
	nvram set "radvd_minrtradv=$RADVD_MINRTRADV"
	nvram set "radvd_maxrtradv=$RADVD_MAXRTRADV"
	nvram set "radvd_advpreflt=$RADVD_ADVPREFLT"
	nvram set "radvd_advvalidlt=$RADVD_ADVVALIDLT"
	
	/usr/sbin/radvd_restart >& /dev/null
	
	printf "302 Redirect\nLocation: ipv6.cgi\n\n"

	exit 0

fi

printf "200 OK\n\n"

IPV6_ENABLE=`nvram get ipv6_enable | sed 's/^[^=]*=//'`
IPV6_FORWARD=`nvram get ipv6_forward | sed 's/^[^=]*=//'`
RADVD_ENABLE=`nvram get radvd_enable | sed 's/^[^=]*=//'`
RADVD_PREFIX=`nvram get radvd_prefix | sed 's/^[^=]*=//'`
RADVD_MINRTRADV=`nvram get radvd_minrtradv | sed 's/^[^=]*=//'`
RADVD_MAXRTRADV=`nvram get radvd_maxrtradv | sed 's/^[^=]*=//'`
RADVD_ADVPREFLT=`nvram get radvd_advpreflt | sed 's/^[^=]*=//'`
RADVD_ADVVALIDLT=`nvram get radvd_advvalidlt | sed 's/^[^=]*=//'`

if [ "$RADVD_PREFIX" == "" ]; then
	if [ "$PREFIX" != "" ]; then
		RADVD_PREFIX=$PREFIX
	fi
fi

if [ "$RADVD_MINRTRADV" == "" ]; then
	RADVD_MINRTRADV=5
fi
if [ "$RADVD_MAXRTRADV" == "" ]; then
	RADVD_MAXRTRADV=15
fi
if [ "$RADVD_ADVPREFLT" == "" ]; then
	RADVD_ADVPREFLT=30
fi
if [ "$RADVD_ADVVALIDLT" == "" ]; then
	RADVD_ADVVALIDLT=50
fi


printf '<html><head><META http-equiv="Pragma" CONTENT="no-cache"><META HTTP-EQUIV="Cache-Control" CONTENT="no-cache"><meta HTTP-EQUIV="Expires" CONTENT="Mon, 06 Jan 1990 00:00:01 GMT"><meta name="description" content="DG834N 1057"><meta http-equiv="content-type" content="text/html;charset=ISO-8859-1"><link rel="stylesheet" href="form.css"></head><body>'

printf '<h1>IPv6</h1><form action="ipv6.cgi" method="post">'

printf '<input type="checkbox" name="ipv6_enable" '

if [ "$IPV6_ENABLE" == "1" ]; then
	printf 'checked="checked" '
fi

printf "><b>Enable IPv6 negociation for ppp connection</b> (restart connection to apply, PPPoE is needed)<br/><br/>"

printf '<input type="checkbox" name="ipv6_forward" '

if [ "$IPV6_FORWARD" == "1" ]; then
	printf 'checked="checked" '
fi

printf "><b>Enable IPv6 forwarding</b> (restart connection to apply)<br/><br/>"

if [ "$IPV6" != "" ]; then
	printf "<b>Actual IPv6:</b> $IPV6<br/><b>Prefix:</b> $PREFIX/64<br/><b>Default route:</b> $DEFROUTE<br/><br/>"
else
	printf "<b>Actual IPv6:</b> None<br/><b>Prefix:</b> None<br/><b>Default route:</b> None<br/><br/>"
fi

printf '<input type="checkbox" name="radvd_enable" '

if [ "$RADVD_ENABLE" == "1" ]; then
	printf 'checked="checked" '
fi

printf "><b>Enable router advertisement</b><br/><br/>"

printf 'Prefix: <input type="text" name="radvd_prefix" size="20" value="'
printf "$RADVD_PREFIX"
printf '">/64<br/>'

printf 'Minimum Router Advertisement Interval: <input type="text" name="radvd_minrtradv" size="6" value="'
printf "$RADVD_MINRTRADV"
printf '"> seconds<br/>'

printf 'Maximum Router Advertisement Interval: <input type="text" name="radvd_maxrtradv" size="6" value="'
printf "$RADVD_MAXRTRADV"
printf '"> seconds<br/>'

printf 'Advertisement Preferred Lifetime: <input type="text" name="radvd_advpreflt" size="6" value="'
printf "$RADVD_ADVPREFLT"
printf '"> seconds<br/>'

printf 'Advertisement Valid Lifetime <input type="text" name="radvd_advvalidlt" size="6" value="'
printf "$RADVD_ADVVALIDLT"
printf '"> seconds<br/><br/>'

printf '<input type="submit" value="Save"> or <input type="reset" value="Cancel">'

printf "</form>"

printf "</body></html>"
