#ifndef _NF_NAT_HELPER_H
#define _NF_NAT_HELPER_H
/* NAT protocol helper routines. */

#include <net/netfilter/nf_conntrack.h>

struct sk_buff;

#undef IFX_RTSP_NAT_ALG
#ifdef IFX_RTSP_NAT_ALG
/* Flags */
/* NAT helper must be called on every packet (for TCP) */
#define IP_NAT_HELPER_F_ALWAYS      0x01
/* Standalone NAT helper, without a conntrack part */
#define IP_NAT_HELPER_F_STANDALONE  0x02

struct nf_nat_helper
{
    struct list_head list;      /* Internal use */

    const char *name;       /* name of the module */
    unsigned char flags;        /* Flags (see above) */
    struct module *me;      /* pointer to self */

    /* Mask of things we will help: vs. tuple from server */
    struct nf_conntrack_tuple tuple;
    struct nf_conntrack_tuple mask;

    /* Helper function: returns verdict */
    unsigned int (*help)(struct ip_conntrack *ct,
                 struct ip_conntrack_expect *exp,
                 struct ip_nat_info *info,
                 enum ip_conntrack_info ctinfo,
                 unsigned int hooknum,
                 struct sk_buff **pskb);

    /* Returns verdict and sets up NAT for this connection */
    unsigned int (*expect)(struct sk_buff **pskb,
                   unsigned int hooknum,
                   struct ip_conntrack *ct,
                   struct ip_nat_info *info);
};

extern struct list_head helpers;

extern int nf_nat_helper_register(struct ip_nat_helper *me);
extern void nf_nat_helper_unregister(struct ip_nat_helper *me);

#endif


/* These return true or false. */
extern int nf_nat_mangle_tcp_packet(struct sk_buff **skb,
				    struct nf_conn *ct,
				    enum ip_conntrack_info ctinfo,
				    unsigned int match_offset,
				    unsigned int match_len,
				    const char *rep_buffer,
				    unsigned int rep_len);
extern int nf_nat_mangle_udp_packet(struct sk_buff **skb,
				    struct nf_conn *ct,
				    enum ip_conntrack_info ctinfo,
				    unsigned int match_offset,
				    unsigned int match_len,
				    const char *rep_buffer,
				    unsigned int rep_len);
extern int nf_nat_seq_adjust(struct sk_buff **pskb,
			     struct nf_conn *ct,
			     enum ip_conntrack_info ctinfo);

/* Setup NAT on this expected conntrack so it follows master, but goes
 * to port ct->master->saved_proto. */
extern void nf_nat_follow_master(struct nf_conn *ct,
				 struct nf_conntrack_expect *this);
#endif
