#ifndef __IFX_PPA_STACK_AL_H__20081103_1153__
#define __IFX_PPA_STACK_AL_H__20081103_1153__



/******************************************************************************
**
** FILE NAME    : ifx_ppa_stack_al.h
** PROJECT      : PPA
** MODULES      : PPA Protocol Stack Adaption Layer (Linux)
**
** DATE         : 3 NOV 2008
** AUTHOR       : Xu Liang
** DESCRIPTION  : PPA Protocol Stack Adaption Layer (Linux) Header File
** COPYRIGHT    :   Copyright (c) 2006
**          Infineon Technologies AG
**          Am Campeon 1-12, 85579 Neubiberg, Germany
**
**   Any use of this software is subject to the conclusion of a respective
**   License agreement. Without such a License agreement no rights to the
**   software are granted
**
** HISTORY
** $Date        $Author         $Comment
** 03 NOV 2008  Xu Liang        Initiate Version
*******************************************************************************/



#ifdef __KERNEL__
  #include <linux/if_pppox.h>
 #ifdef CONFIG_NF_CONNTRACK_SUPPORT
  #include <net/netfilter/nf_conntrack.h>    /* protocol independent conntrack */
 #else
  #include <linux/netfilter_ipv4/ip_conntrack.h>
 #endif
#endif

/*
 * ####################################
 *              Definition
 * ####################################
 */

#define PPA_ETH_ALEN                            ETH_ALEN
#define PPA_IF_NAME_SIZE                        IFNAMSIZ

#define PPA_ATOMIC_INIT(i)                      ATOMIC_INIT(i)

#define IFX_IPPROTO_TCP                         IPPROTO_TCP
#define IFX_IPPROTO_UDP                         IPPROTO_UDP

/*
 *  definition for application layer
 */
#ifndef __KERNEL__
  #define ETH_ALEN                              6
  #define IFNAMSIZ                              16
#endif



/*
 * ####################################
 *              Data Type
 * ####################################
 */

/*
 *  data type for application layer
 */
#ifndef __KERNEL__
  typedef unsigned long         uint32_t;
  typedef unsigned short        uint16_t;
  typedef unsigned char         uint8_t;
#endif

/*
 *  data type for API
 */

typedef char                    PPA_IFNAME;

typedef uint32_t                IPADDR;

#ifdef __KERNEL__
  typedef struct sk_buff        PPA_BUF;

 #ifdef CONFIG_NF_CONNTRACK_SUPPORT
  typedef struct nf_conn        PPA_SESSION;
 #else
  typedef struct ip_conntrack   PPA_SESSION;
 #endif

  typedef struct net_device     PPA_NETIF;

  typedef struct atm_vcc        PPA_VCC;

  typedef struct mutex          PPA_LOCK;

  typedef struct kmem_cache     PPA_MEM_CACHE;

  typedef struct timer_list     PPA_TIMER;

  typedef atomic_t              PPA_ATOMIC;
#endif



/*
 * ####################################
 *           Inline Functions
 * ####################################
 */



/*
 * ####################################
 *             Declaration
 * ####################################
 */

#ifdef __KERNEL__
  void ppa_get_stack_al_id(uint32_t *,
                           uint32_t *,
                           uint32_t *,
                           uint32_t *,
                           uint32_t *,
                           uint32_t *,
                           uint32_t *);

  PPA_SESSION *ppa_get_session(PPA_BUF *);

  uint8_t ppa_get_pkt_ip_proto(PPA_BUF *);
  uint8_t ppa_get_pkt_ip_tos(PPA_BUF *);
  uint32_t ppa_get_pkt_src_ip(PPA_BUF *);
  uint32_t ppa_get_pkt_dst_ip(PPA_BUF *);
  void *ppa_get_pkt_transport_hdr(PPA_BUF *);
  uint16_t ppa_get_pkt_src_port(PPA_BUF *);
  uint16_t ppa_get_pkt_dst_port(PPA_BUF *);
  void ppa_get_pkt_rx_src_mac_addr(PPA_BUF *, uint8_t[PPA_ETH_ALEN]);
  void ppa_get_pkt_rx_dst_mac_addr(PPA_BUF *, uint8_t[PPA_ETH_ALEN]);
  PPA_NETIF *ppa_get_pkt_src_if(PPA_BUF *);
  PPA_NETIF *ppa_get_pkt_dst_if(PPA_BUF *);

  int32_t ppa_pppoe_get_pppoe_addr(PPA_NETIF *, struct pppoe_addr *);
  __u16 ppa_pppoe_get_pppoe_session_id(PPA_NETIF *);
  __u16 ppa_get_pkt_pppoe_session_id(PPA_BUF *);
  int32_t ppa_pppoe_get_eth_netif(PPA_NETIF *, PPA_IFNAME[PPA_IF_NAME_SIZE]);

  int32_t ppa_pppoe_get_physical_if(PPA_NETIF *, PPA_IFNAME *, PPA_IFNAME[PPA_IF_NAME_SIZE]);
  uint32_t ppa_check_is_ppp_netif(PPA_NETIF *);
  uint32_t ppa_check_is_pppoe_netif(PPA_NETIF *);
  int32_t ppa_pppoe_get_dst_mac(PPA_NETIF * netif, uint8_t[PPA_ETH_ALEN]);
  int32_t ppa_get_dst_mac(PPA_BUF *, PPA_SESSION *, uint8_t[PPA_ETH_ALEN]);

  PPA_NETIF *ppa_get_netif(PPA_IFNAME *);
  void ppa_put_netif(PPA_NETIF *);
  int32_t ppa_get_netif_hwaddr(PPA_NETIF *, uint8_t[PPA_ETH_ALEN]);
  PPA_IFNAME *ppa_get_netif_name(PPA_NETIF *);
  uint32_t ppa_is_netif_equal(PPA_NETIF *, PPA_NETIF *);
  uint32_t ppa_is_netif_name(PPA_NETIF *, PPA_IFNAME *);
  uint32_t ppa_is_netif_name_prefix(PPA_NETIF *, PPA_IFNAME *, int);

  int32_t ppa_get_physical_if(PPA_NETIF *, PPA_IFNAME *, PPA_IFNAME[PPA_IF_NAME_SIZE]);

  int32_t ppa_get_underlying_vlan_if(PPA_NETIF *, PPA_IFNAME *, PPA_IFNAME[PPA_IF_NAME_SIZE]);

  int32_t ppa_if_is_vlan_if(PPA_NETIF *, PPA_IFNAME *);
  int32_t ppa_vlan_get_underlying_if(PPA_NETIF *, PPA_IFNAME *, PPA_IFNAME[PPA_IF_NAME_SIZE]);
  int32_t ppa_vlan_get_physical_if(PPA_NETIF *, PPA_IFNAME *, PPA_IFNAME[PPA_IF_NAME_SIZE]);
  uint32_t ppa_get_vlan_id(PPA_NETIF *);
  uint32_t ppa_get_vlan_tag(PPA_BUF *);

  int32_t ppa_is_netif_bridged(PPA_IFNAME *, PPA_NETIF *);
  int32_t ppa_get_bridge_member_ifs(PPA_IFNAME *, int *, PPA_IFNAME **);
  int32_t ppa_if_is_br_if(PPA_NETIF *, PPA_IFNAME *);
  int32_t ppa_get_br_dst_port(PPA_NETIF *, PPA_BUF *, PPA_NETIF **);
  int32_t ppa_get_br_dst_port_with_mac(PPA_NETIF *, uint8_t[PPA_ETH_ALEN], PPA_NETIF **);

  int32_t ppa_br2684_get_vcc(PPA_NETIF *, PPA_VCC **);
  int32_t ppa_if_is_br2684(PPA_NETIF *, PPA_IFNAME *);
  int32_t ppa_if_is_ipoa(PPA_NETIF *, PPA_IFNAME *);
  int32_t ppa_pppoa_get_vcc(PPA_NETIF *, PPA_VCC **);
  int32_t ppa_if_is_pppoa(PPA_NETIF *, PPA_IFNAME *);

  uint32_t ppa_is_session_equal(PPA_SESSION *, PPA_SESSION *);
  uint32_t ppa_get_session_helper(PPA_SESSION *);
  uint32_t ppa_check_is_special_session(PPA_BUF *, PPA_SESSION *);

  int32_t ppa_is_pkt_fragment(PPA_BUF *);
  int32_t ppa_is_pkt_host_output(PPA_BUF *);
  int32_t ppa_is_pkt_broadcast(PPA_BUF *);
  int32_t ppa_is_pkt_multicast(PPA_BUF *);
  int32_t ppa_is_pkt_loopback(PPA_BUF *);
  int32_t ppa_is_pkt_local(PPA_BUF *);
  int32_t ppa_is_pkt_routing(PPA_BUF *);
  int32_t ppa_is_pkt_mc_routing(PPA_BUF *);

  int32_t ppa_is_tcp_established(PPA_SESSION *);
  int32_t ppa_is_tcp_open(PPA_SESSION *);

  int32_t ppa_lock_init(PPA_LOCK *);
  void ppa_lock_get(PPA_LOCK *);
  void ppa_lock_release(PPA_LOCK *);
  void ppa_lock_destroy(PPA_LOCK *p_lock);

  uint32_t ppa_disable_int(void);
  void ppa_enable_int(uint32_t);

  void *ppa_malloc(uint32_t);
  int32_t ppa_free(void *);

  int32_t ppa_mem_cache_create(const char *, uint32_t, PPA_MEM_CACHE **);
  int32_t ppa_mem_cache_destroy(PPA_MEM_CACHE *);
  void *ppa_mem_cache_alloc(PPA_MEM_CACHE *);
  void ppa_mem_cache_free(void *, PPA_MEM_CACHE *);

  void ppa_memcpy(void *, const void *, uint32_t);
  void ppa_memset(void *, uint32_t, uint32_t);
  int ppa_memcmp(const void *, const void *, size_t);

  int32_t ppa_timer_init(PPA_TIMER *, void (*)(unsigned long));
  int32_t ppa_timer_add(PPA_TIMER *, uint32_t);
  void ppa_timer_del(PPA_TIMER *);
  uint32_t ppa_get_time_in_10msec(void);
  uint32_t ppa_get_time_in_sec(void);

  int32_t ppa_atomic_read(PPA_ATOMIC *v);
  void ppa_atomic_set(PPA_ATOMIC *v, int32_t i);
  int32_t ppa_atomic_inc(PPA_ATOMIC *v);
  int32_t ppa_atomic_dec(PPA_ATOMIC *v);

  PPA_BUF *ppa_buf_clone(PPA_BUF *buf, uint32_t flags);
  int32_t ppa_buf_cloned(PPA_BUF *buf);
  PPA_BUF *ppa_buf_get_prev(PPA_BUF *buf);
  PPA_BUF *ppa_buf_get_next(PPA_BUF *buf);
  void ppa_buf_free(PPA_BUF *buf);
#endif  //  __KERNEL__



#endif  //  __IFX_PPA_STACK_AL_H__20081103_1153__
