#ifndef __IFX_PPA_PPE_HAL_H__20081104_1318__
#define __IFX_PPA_PPE_HAL_H__20081104_1318__



/*******************************************************************************
**
** FILE NAME    : ifx_ppa_ppe_hal.h
** PROJECT      : PPA
** MODULES      : PPA API (Routing/Bridging Acceleration APIs)
**
** DATE         : 4 NOV 2008
** AUTHOR       : Xu Liang
** DESCRIPTION  : PPA PPE Firmware Hardware/Firmware Adaption Layer Header File
** COPYRIGHT    :   Copyright (c) 2006
**          Infineon Technologies AG
**          Am Campeon 1-12, 85579 Neubiberg, Germany
**
**   Any use of this software is subject to the conclusion of a respective
**   License agreement. Without such a License agreement no rights to the
**   software are granted
**
** HISTORY
** $Date        $Author         $Comment
** 04 NOV 2008  Xu Liang        Initiate Version
*******************************************************************************/



/*
 * ####################################
 *              Definition
 * ####################################
 */

#define IFX_PPA_IF_NOT_FOUND                            0
#define IFX_PPA_IF_TYPE_LAN                             1
#define IFX_PPA_IF_TYPE_WAN                             2
#define IFX_PPA_IF_TYPE_MIX                             3

#define IFX_PPA_ACC_MODE_NONE                           0
#define IFX_PPA_ACC_MODE_BRIDGING                       1
#define IFX_PPA_ACC_MODE_ROUTING                        2
#define IFX_PPA_ACC_MODE_HYBRID                         3

#define IFX_PPA_SET_ROUTE_CFG_ENTRY_NUM                 0x01
#define IFX_PPA_SET_ROUTE_CFG_MC_ENTRY_NUM              0x02
#define IFX_PPA_SET_ROUTE_CFG_IP_VERIFY                 0x04
#define IFX_PPA_SET_ROUTE_CFG_TCPUDP_VERIFY             0x08
#define IFX_PPA_SET_ROUTE_CFG_TCPUDP_ERR_DROP           0x10
#define IFX_PPA_SET_ROUTE_CFG_DROP_ON_NOT_HIT           0x20
#define IFX_PPA_SET_ROUTE_CFG_MC_DROP_ON_NOT_HIT        0x40

#define IFX_PPA_SET_BRIDGING_CFG_ENTRY_NUM              0x01
#define IFX_PPA_SET_BRIDGING_CFG_BR_TO_SRC_PORT_EN      0x02
#define IFX_PPA_SET_BRIDGING_CFG_DEST_VLAN_EN           0x04
#define IFX_PPA_SET_BRIDGING_CFG_SRC_VLAN_EN            0x08
#define IFX_PPA_SET_BRIDGING_CFG_MAC_CHANGE_DROP        0x10

#define IFX_PPA_ROUTE_TYPE_NULL                         0
#define IFX_PPA_ROUTE_TYPE_IPV4                         1
#define IFX_PPA_ROUTE_TYPE_NAT                          2
#define IFX_PPA_ROUTE_TYPE_NAPT                         3

//#define IFX_PPA_DEST_LIST_ETH0                          0x01
//#define IFX_PPA_DEST_LIST_ETH1                          0x02
//#define IFX_PPA_DEST_LIST_CPU0                          0x04
//#define IFX_PPA_DEST_LIST_EXT_INT1                      0x08
//#define IFX_PPA_DEST_LIST_EXT_INT2                      0x10
//#define IFX_PPA_DEST_LIST_EXT_INT3                      0x20
//#define IFX_PPA_DEST_LIST_EXT_INT4                      0x40
//#define IFX_PPA_DEST_LIST_EXT_INT5                      0x80
//#define IFX_PPA_DEST_LIST_ATM                           IFX_PPA_DEST_LIST_EXT_INT5  //  EoA

//#define IFX_PPA_DEST_LIST_ETH0                          0x0001
//#define IFX_PPA_DEST_LIST_ETH1                          0x0002
//#define IFX_PPA_DEST_LIST_CPU0                          0x0004
//#define IFX_PPA_DEST_LIST_EXT_INT1                      0x0008
//#define IFX_PPA_DEST_LIST_EXT_INT2                      0x0010
//#define IFX_PPA_DEST_LIST_EXT_INT3                      0x0020
//#define IFX_PPA_DEST_LIST_EXT_INT4                      0x0040
//#define IFX_PPA_DEST_LIST_EXT_INT5                      0x0080
//#define IFX_PPA_DEST_LIST_ATM                           0x0100
//#define IFX_PPA_DEST_LIST_NO_REMAP                      (1 << 31)

#define IFX_PPA_PHYS_PORT_FLAGS_VALID                   0x0001
#define IFX_PPA_PHYS_PORT_FLAGS_TYPE_CPU                0x0000
#define IFX_PPA_PHYS_PORT_FLAGS_TYPE_ATM                0x0010
#define IFX_PPA_PHYS_PORT_FLAGS_TYPE_ETH                0x0020
#define IFX_PPA_PHYS_PORT_FLAGS_TYPE_EXT                0x0030
#define IFX_PPA_PHYS_PORT_FLAGS_TYPE_MASK               0x0030
#define IFX_PPA_PHYS_PORT_FLAGS_MODE_LAN                0x0100
#define IFX_PPA_PHYS_PORT_FLAGS_MODE_WAN                0x0200
#define IFX_PPA_PHYS_PORT_FLAGS_MODE_MIX                (IFX_PPA_PHYS_PORT_FLAGS_MODE_LAN | IFX_PPA_PHYS_PORT_FLAGS_MODE_WAN)
#define IFX_PPA_PHYS_PORT_FLAGS_MODE_MASK               0x0300
#define IFX_PPA_PHYS_PORT_FLAGS_OUTER_VLAN              0x1000
#define IFX_PPA_PHYS_PORT_FLAGS_OUTER_VLAN              0x1000
#define IFX_PPA_PHYS_PORT_FLAGS_EXT_CPU0                0x4000
#define IFX_PPA_PHYS_PORT_FLAGS_EXT_CPU1                0x8000

#define IFX_PPA_PHYS_PORT_FLAGS_MODE_ETH_LAN_VALID      (IFX_PPA_PHYS_PORT_FLAGS_TYPE_ETH | IFX_PPA_PHYS_PORT_FLAGS_MODE_LAN | IFX_PPA_PHYS_PORT_FLAGS_VALID)
#define IFX_PPA_PHYS_PORT_FLAGS_MODE_ETH_WAN_VALID      (IFX_PPA_PHYS_PORT_FLAGS_TYPE_ETH | IFX_PPA_PHYS_PORT_FLAGS_MODE_WAN | IFX_PPA_PHYS_PORT_FLAGS_VALID)
#define IFX_PPA_PHYS_PORT_FLAGS_MODE_ETH_MIX_VALID      (IFX_PPA_PHYS_PORT_FLAGS_TYPE_ETH | IFX_PPA_PHYS_PORT_FLAGS_MODE_MIX | IFX_PPA_PHYS_PORT_FLAGS_VALID)
#define IFX_PPA_PHYS_PORT_FLAGS_MODE_CPU_VALID          (IFX_PPA_PHYS_PORT_FLAGS_TYPE_CPU | IFX_PPA_PHYS_PORT_FLAGS_VALID)
#define IFX_PPA_PHYS_PORT_FLAGS_MODE_ATM_WAN_VALID      (IFX_PPA_PHYS_PORT_FLAGS_TYPE_ATM | IFX_PPA_PHYS_PORT_FLAGS_MODE_WAN | IFX_PPA_PHYS_PORT_FLAGS_VALID)
#define IFX_PPA_PHYS_PORT_FLAGS_MODE_EXT_LAN_VALID      (IFX_PPA_PHYS_PORT_FLAGS_TYPE_EXT | IFX_PPA_PHYS_PORT_FLAGS_MODE_LAN | IFX_PPA_PHYS_PORT_FLAGS_VALID)

#define IFX_PPA_PPPOE_MODE_TRANSPARENT                  0
#define IFX_PPA_PPPOE_MODE_TERMINATION                  1

#define IFX_PPA_UPDATE_ROUTING_ENTRY_ROUTE_TYPE         0x0001
#define IFX_PPA_UPDATE_ROUTING_ENTRY_NEW_IP             0x0002
#define IFX_PPA_UPDATE_ROUTING_ENTRY_NEW_PORT           0x0004
#define IFX_PPA_UPDATE_ROUTING_ENTRY_NEW_MAC            0x0008
#define IFX_PPA_UPDATE_ROUTING_ENTRY_NEW_SRC_MAC_IX     0x0010
#define IFX_PPA_UPDATE_ROUTING_ENTRY_MTU_IX             0x0020
#define IFX_PPA_UPDATE_ROUTING_ENTRY_NEW_DSCP_EN        0x0040
#define IFX_PPA_UPDATE_ROUTING_ENTRY_NEW_DSCP           0x0080
#define IFX_PPA_UPDATE_ROUTING_ENTRY_VLAN_INS_EN        0x0100
#define IFX_PPA_UPDATE_ROUTING_ENTRY_NEW_VCI            0x0200
#define IFX_PPA_UPDATE_ROUTING_ENTRY_VLAN_RM_EN         0x0400
#define IFX_PPA_UPDATE_ROUTING_ENTRY_PPPOE_MODE         0x0800
#define IFX_PPA_UPDATE_ROUTING_ENTRY_PPPOE_IX           0x1000
#define IFX_PPA_UPDATE_ROUTING_ENTRY_OUT_VLAN_INS_EN    0x0100
#define IFX_PPA_UPDATE_ROUTING_ENTRY_OUT_VLAN_IX        0x0200
#define IFX_PPA_UPDATE_ROUTING_ENTRY_OUT_VLAN_RM_EN     0x0400
#define IFX_PPA_UPDATE_ROUTING_ENTRY_DEST_LIST          0x2000
#define IFX_PPA_UPDATE_ROUTING_ENTRY_DEST_QID           0x4000

#define IFX_PPA_UPDATE_WAN_MC_ENTRY_VLAN_INS_EN         0x0001
#define IFX_PPA_UPDATE_WAN_MC_ENTRY_NEW_VCI             0x0002
#define IFX_PPA_UPDATE_WAN_MC_ENTRY_VLAN_RM_EN          0x0004
#define IFX_PPA_UPDATE_WAN_MC_ENTRY_SRC_MAC_EN          0x0008
#define IFX_PPA_UPDATE_WAN_MC_ENTRY_SRC_MAC_IX          0x0010
#define IFX_PPA_UPDATE_WAN_MC_ENTRY_DEST_LIST           0x0020
#define IFX_PPA_UPDATE_WAN_MC_ENTRY_DEST_CHID           0x0040
#define IFX_PPA_UPDATE_WAN_MC_ENTRY_PPPOE_MODE          0x0080
#define IFX_PPA_UPDATE_WAN_MC_ENTRY_OUT_VLAN_INS_EN     0x0100
#define IFX_PPA_UPDATE_WAN_MC_ENTRY_OUT_VLAN_IX         0x0200
#define IFX_PPA_UPDATE_WAN_MC_ENTRY_OUT_VLAN_RM_EN      0x0400
#define IFX_PPA_UPDATE_WAN_MC_ENTRY_NEW_DSCP_EN         0x0800
#define IFX_PPA_UPDATE_WAN_MC_ENTRY_NEW_DSCP            0x1000
#define IFX_PPA_UPDATE_WAN_MC_ENTRY_DEST_QID            IFX_PPA_UPDATE_WAN_MC_ENTRY_DEST_CHID

#define IFX_PPA_ADD_MAC_ENTRY_PPPOE                     0x01
#define IFX_PPA_ADD_MAC_ENTRY_LAN                       0x02
#define IFX_PPA_ADD_MAC_ENTRY_WAN                       0x00

#define IFX_PPA_SET_FAST_MODE_CPU1                      0x01
#define IFX_PPA_SET_FAST_MODE_APP2                      IFX_PPA_SET_FAST_MODE_CPU1
#define IFX_PPA_SET_FAST_MODE_ETH1                      0x02
#define IFX_PPA_SET_FAST_MODE_ATM                       IFX_PPA_SET_FAST_MODE_ETH1

#define IFX_PPA_SET_FAST_MODE_CPU1_DIRECT               IFX_PPA_SET_FAST_MODE_CPU1
#define IFX_PPA_SET_FAST_MODE_CPU1_INDIRECT             0
#define IFX_PPA_SET_FAST_MODE_APP2_DIRECT               IFX_PPA_SET_FAST_MODE_CPU1_DIRECT
#define IFX_PPA_SET_FAST_MODE_APP2_INDIRECT             IFX_PPA_SET_FAST_MODE_CPU1_INDIRECT
#define IFX_PPA_SET_FAST_MODE_ETH1_DIRECT               IFX_PPA_SET_FAST_MODE_ETH1
#define IFX_PPA_SET_FAST_MODE_ETH1_INDIRECT             0
#define IFX_PPA_SET_FAST_MODE_ATM_DIRECT                IFX_PPA_SET_FAST_MODE_ETH1_DIRECT
#define IFX_PPA_SET_FAST_MODE_ATM_INDIRECT              IFX_PPA_SET_FAST_MODE_ETH1_INDIRECT

//#define IFX_PPA_PORT_ETH0                               0x00
//#define IFX_PPA_PORT_ETH1                               0x01
//#define IFX_PPA_PORT_CPU0                               0x02
//#define IFX_PPA_PORT_CPU1_EXT_IF0                       0x05
//#define IFX_PPA_PORT_ATM                                0x07
//#define IFX_PPA_PORT_ANY                                IFX_PPA_PORT_CPU0
//#define IFX_PPA_PORT_NUM                                0x08

//  Obsolete, for bridging only
//#define IFX_PPA_PORT_ETH0                               0x00
//#define IFX_PPA_PORT_ETH1                               0x01
//#define IFX_PPA_PORT_CPU0                               0x02
//#define IFX_PPA_PORT_CPU1_EXT_IF0                       0x05
//#define IFX_PPA_PORT_ATM                                0x08
//#define IFX_PPA_PORT_ANY                                IFX_PPA_PORT_CPU0
//#define IFX_PPA_PORT_NUM                                0x09

#define IFX_PPA_BRG_VLAN_IG_COND_TYPE_DEF               0
#define IFX_PPA_BRG_VLAN_IG_COND_TYPE_SRC_IP            1
#define IFX_PPA_BRG_VLAN_IG_COND_TYPE_ETH_TYPE          2
#define IFX_PPA_BRG_VLAN_IG_COND_TYPE_VLAN              3



/*
 * ####################################
 *              Data Type
 * ####################################
 */

struct ppe_itf_mib {
    u32             ig_fast_brg_pkts;           // 0 bridge ?
    u32             ig_fast_brg_bytes;          // 1 ?

    u32             ig_fast_rt_ipv4_udp_pkts;   // 2 IPV4 routing
    u32             ig_fast_rt_ipv4_tcp_pkts;   // 3
    u32             ig_fast_rt_ipv4_mc_pkts;    // 4
    u32             ig_fast_rt_ipv4_bytes;      // 5

    u32             ig_fast_rt_ipv6_udp_pkts;   // 6 IPV6 routing
    u32             ig_fast_rt_ipv6_tcp_pkts;   // 7
    u32             res0;                       // 8
    u32             ig_fast_rt_ipv6_bytes;      // 9

    u32             res1;                       // A
    u32             ig_cpu_pkts;
    u32             ig_cpu_bytes;

    u32             ig_drop_pkts;
    u32             ig_drop_bytes;

    u32             eg_fast_pkts;
};



/*
 * ####################################
 *             Declaration
 * ####################################
 */

#ifdef __KERNEL__
  void get_ppe_hal_id(uint32_t *p_family,
                      uint32_t *p_type,
                      uint32_t *p_if,
                      uint32_t *p_mode,
                      uint32_t *p_major,
                      uint32_t *p_mid,
                      uint32_t *p_minor);

  void get_firmware_id(uint32_t *p_family,
                       uint32_t *p_type,
                       uint32_t *p_if,
                       uint32_t *p_mode,
                       uint32_t *p_major,
                       uint32_t *p_minor);

  uint32_t get_number_of_phys_port(void);

  void get_phys_port_info(uint32_t port,
                          uint32_t *p_flags,
                          PPA_IFNAME ifname[PPA_IF_NAME_SIZE]);

  void get_max_route_entries(uint32_t *p_entry,
                             uint32_t *p_mc_entry);

  void get_max_bridging_entries(uint32_t *p_entry);

  void set_wan_vlan_id(uint32_t vlan_id);

  uint32_t get_wan_vlan_id(void);

  void set_if_type(uint32_t if_type,  //  1: LAN, 2: WAN, 3:MIX
                   uint32_t if_no);

  uint32_t get_if_type(uint32_t if_no);

  void set_route_cfg(uint32_t f_is_lan,
                     uint32_t entry_num,
                     uint32_t mc_entry_num,
                     uint32_t f_ip_verify,
                     uint32_t f_tcpudp_verify,
                     uint32_t f_tcpudp_err_drop,
                     uint32_t f_drop_on_no_hit,
                     uint32_t f_mc_drop_on_no_hit,
                     uint32_t flags); //  bit 0: entry_num is valid
                                      //  bit 1: mc_entry_num is valid
                                      //  bit 2: f_ip_verify is valid
                                      //  bit 3: f_tcpudp_verify is valid
                                      //  bit 4: f_tcpudp_err_drop is valid
                                      //  bit 5: f_drop_on_no_hit is valid
                                      //  bit 6: f_mc_drop_on_no_hit is valid

  void set_bridging_cfg(uint32_t entry_num,
                        uint32_t br_to_src_port_mask, uint32_t br_to_src_port_en,
                        uint32_t f_dest_vlan_en,
                        uint32_t f_src_vlan_en,
                        uint32_t f_mac_change_drop,
                        uint32_t flags);

  void set_fast_mode(uint32_t mode,
                     uint32_t flags);

  void set_if_wfq(uint32_t if_wfq,
                  uint32_t if_no);

  void set_dplus_wfq(uint32_t wfq);

  void set_fastpath_wfq(uint32_t wfq);

  void get_acc_mode(uint32_t f_is_lan,
                    uint32_t *p_acc_mode);

  void set_acc_mode(uint32_t f_is_lan,
                    uint32_t acc_mode);   //  0: none, 2: routing

  void set_default_dest_list(uint32_t uc_dest_list,
                           uint32_t mc_dest_list,
                           uint32_t if_no);

  void set_bridge_if_vlan_config(uint32_t if_no,
                                 uint32_t f_eg_vlan_insert,
                                 uint32_t f_eg_vlan_remove,
                                 uint32_t f_ig_vlan_aware,
                                 uint32_t f_ig_src_ip_based,
                                 uint32_t f_ig_eth_type_based,
                                 uint32_t f_ig_vlanid_based,
                                 uint32_t f_ig_port_based,
                                 uint32_t f_eg_out_vlan_insert,
                                 uint32_t f_eg_out_vlan_remove,
                                 uint32_t f_ig_out_vlan_aware);

  void get_bridge_if_vlan_config(uint32_t if_no,
                                 uint32_t *f_eg_vlan_insert,
                                 uint32_t *f_eg_vlan_remove,
                                 uint32_t *f_ig_vlan_aware,
                                 uint32_t *f_ig_src_ip_based,
                                 uint32_t *f_ig_eth_type_based,
                                 uint32_t *f_ig_vlanid_based,
                                 uint32_t *f_ig_port_based,
                                 uint32_t *f_eg_out_vlan_insert,
                                 uint32_t *f_eg_out_vlan_remove,
                                 uint32_t *f_ig_out_vlan_aware);

  int32_t add_vlan_map(uint32_t ig_criteria_type,
                       uint32_t ig_criteria,
                       uint32_t new_vci,
                       uint32_t vlan_port_map);

  void del_vlan_map(uint32_t ig_criteria_type,
                    uint32_t ig_criteria);

  int32_t get_vlan_map(uint32_t ig_criteria_type,
                       uint32_t entry,
                       uint32_t *ig_criteria,
                       uint32_t *new_vci,
                       uint32_t *vlan_port_map);

  void del_all_vlan_map(void);

  int32_t add_routing_entry(uint32_t f_is_lan,
                            uint32_t src_ip,
                            uint32_t src_port,
                            uint32_t dst_ip,
                            uint32_t dst_port,
                            uint32_t f_is_tcp,
                            uint32_t route_type,
                            uint32_t new_ip,
                            uint32_t new_port,
                            uint8_t  new_mac[PPA_ETH_ALEN],
                            uint32_t new_src_mac_ix,
                            uint32_t mtu_ix,
                            uint32_t f_new_dscp_enable,
                            uint32_t new_dscp,
                            uint32_t f_vlan_ins_enable,
                            uint32_t new_vci,
                            uint32_t f_vlan_rm_enable,
                            uint32_t pppoe_mode,
                            uint32_t pppoe_ix,
                            uint32_t f_out_vlan_ins_enable,
                            uint32_t out_vlan_ix,
                            uint32_t f_out_vlan_rm_enable,
                            uint32_t dslwan_qid,
                            uint32_t dest_list,
                            uint32_t *p_entry);

  void del_routing_entry(uint32_t entry);

  int32_t update_routing_entry(uint32_t entry,
                               uint32_t route_type,
                               uint32_t new_ip,
                               uint32_t new_port,
                               uint8_t  new_mac[PPA_ETH_ALEN],
                               uint32_t new_src_mac_ix,
                               uint32_t mtu_ix,
                               uint32_t f_new_dscp_enable,
                               uint32_t new_dscp,
                               uint32_t f_vlan_ins_enable,
                               uint32_t vlan_ix,
                               uint32_t f_vlan_rm_enable,
                               uint32_t pppoe_mode,
                               uint32_t pppoe_ix,
                               uint32_t f_out_vlan_ins_enable,
                               uint32_t out_vlan_ix,
                               uint32_t f_out_vlan_rm_enable,
                               uint32_t dslwan_qid,
                               uint32_t dest_list,
                               uint32_t flags);

  int32_t add_wan_mc_entry(uint32_t dest_ip_compare,
                           uint32_t f_vlan_ins_enable,
                           uint32_t new_vci,
                           uint32_t f_vlan_rm_enable,
                           uint32_t f_src_mac_enable,
                           uint32_t src_mac_ix,
                           uint32_t pppoe_mode,
                           uint32_t f_out_vlan_ins_enable,
                           uint32_t out_vlan_ix,
                           uint32_t f_out_vlan_rm_enable,
                           uint32_t f_new_dscp_en,
                           uint32_t new_dscp,
                           uint32_t dest_qid,
                           uint32_t dest_list,
                           uint32_t *p_entry);

  void del_wan_mc_entry(uint32_t entry);

  int32_t update_wan_mc_entry(uint32_t entry,
                              uint32_t f_vlan_ins_enable,
                              uint32_t vlan_ix,
                              uint32_t f_vlan_rm_enable,
                              uint32_t f_src_mac_enable,
                              uint32_t src_mac_ix,
                              uint32_t pppoe_mode,
                              uint32_t f_out_vlan_ins_enable,
                              uint32_t out_vlan_ix,
                              uint32_t f_out_vlan_rm_enable,
                              uint32_t f_new_dscp_en,
                              uint32_t new_dscp,
                              uint32_t dest_qid,
                              uint32_t dest_list,
                              uint32_t flags);

  int32_t get_dest_ip_from_wan_mc_entry(uint32_t entry,
                                        uint32_t *p_ip);

  int32_t add_bridging_entry(uint32_t port,
                             uint8_t  mac[PPA_ETH_ALEN],
                             uint32_t f_src_mac_drop,
                             uint32_t dslwan_qid,
                             uint32_t dest_list,
                             uint32_t *p_entry);

  void del_bridging_entry(uint32_t entry);

  int32_t add_pppoe_entry(uint32_t session_id,
                          uint32_t *p_entry);

  void del_pppoe_entry(uint32_t entry);

  int32_t get_pppoe_entry(uint32_t entry,
                          uint32_t *p_session_id);

  int32_t add_mtu_entry(uint32_t mtu_size,
                        uint32_t *p_entry);

  void del_mtu_entry(uint32_t entry);

  int32_t get_mtu_entry(uint32_t entry,
                        uint32_t *p_mtu_size);

  int32_t add_mac_entry(uint8_t mac[PPA_ETH_ALEN],
                        uint32_t *p_entry);

  void del_mac_entry(uint32_t entry);

  int32_t get_mac_entry(uint32_t entry,
                        uint8_t mac[PPA_ETH_ALEN]);

  int32_t add_outer_vlan_entry(uint32_t new_tag,
                               uint32_t *p_entry);

  void del_outer_vlan_entry(uint32_t entry);

  int32_t get_outer_vlan_entry(uint32_t entry,
                               uint32_t *p_outer_vlan_tag);

  void get_itf_mib(uint32_t itf,
                   struct ppe_itf_mib *p);

  uint32_t test_and_clear_hit_stat(uint32_t entry);

  uint32_t test_and_clear_hit_stat_batch(uint32_t entry);

  uint32_t test_and_clear_mc_hit_stat(uint32_t entry);

  uint32_t test_and_clear_mc_hit_stat_batch(uint32_t entry);

  uint32_t test_and_clear_bridging_hit_stat(uint32_t entry);

  uint32_t test_and_clear_bridging_hit_stat_batch(uint32_t entry);

  int ifx_ppa_ppe_hal_init(void);
  void ifx_ppa_ppe_hal_exit(void);

 #ifdef CONFIG_IFX_PPA_API_DIRECTPATH
  int ppe_directpath_send(uint32_t, struct sk_buff *, int32_t, uint32_t);
  int ppe_directpath_rx_stop(uint32_t, uint32_t);
  int ppe_directpath_rx_start(uint32_t, uint32_t);
 #endif

#endif  //  __KERNEL__



#endif  //  __IFX_PPA_PPE_HAL_H__20081104_1318__
