#ifndef __IFX_PPA_HOOK_H__20081103_1736__
#define __IFX_PPA_HOOK_H__20081103_1736__



/******************************************************************************
**
** FILE NAME    : ifx_ppa_hook.h
** PROJECT      : PPA
** MODULES      : PPA Protocol Stack Hooks
**
** DATE         : 3 NOV 2008
** AUTHOR       : Xu Liang
** DESCRIPTION  : PPA Protocol Stack Hook Pointers Header File
** COPYRIGHT    :   Copyright (c) 2006
**          Infineon Technologies AG
**          Am Campeon 1-12, 85579 Neubiberg, Germany
**
**   Any use of this software is subject to the conclusion of a respective
**   License agreement. Without such a License agreement no rights to the
**   software are granted
**
** HISTORY
** $Date        $Author         $Comment
** 03 NOV 2008  Xu Liang        Initiate Version
*******************************************************************************/



/*
 * ####################################
 *             Declaration
 * ####################################
 */

#ifdef __KERNEL__
  extern int32_t (*ppa_hook_init_fn)(PPA_INIT_INFO *, uint32_t);
  extern void (*ppa_hook_exit_fn)(void);

  extern int32_t (*ppa_hook_enable_fn)(uint32_t, uint32_t, uint32_t);
  extern int32_t (*ppa_hook_get_status_fn)(uint32_t *, uint32_t *, uint32_t);

  extern int32_t (*ppa_hook_session_add_fn)(PPA_BUF *, PPA_SESSION *, uint32_t);
  extern int32_t (*ppa_hook_session_del_fn)(PPA_SESSION *, uint32_t);
  extern int32_t (*ppa_hook_session_modify_fn)(PPA_SESSION *, PPA_SESSION_EXTRA *, uint32_t);
  extern int32_t (*ppa_hook_session_get_fn)(PPA_SESSION ***, PPA_SESSION_EXTRA **, int32_t *, uint32_t);

  extern int32_t (*ppa_hook_mc_group_update_fn)(PPA_MC_GROUP *, uint32_t);
  extern int32_t (*ppa_hook_mc_group_get_fn)(IPADDR, PPA_MC_GROUP *, uint32_t);
  extern int32_t (*ppa_hook_mc_entry_modify_fn)(IPADDR, PPA_MC_GROUP *, PPA_SESSION_EXTRA *, uint32_t);
  extern int32_t (*ppa_hook_mc_entry_get_fn)(IPADDR, PPA_SESSION_EXTRA *, uint32_t);

  extern int32_t (*ppa_hook_inactivity_status_fn)(PPA_U_SESSION *);
  extern int32_t (*ppa_hook_set_inactivity_fn)(PPA_U_SESSION*, int32_t);

  extern int32_t (*ppa_hook_bridge_entry_add_fn)(uint8_t *, PPA_NETIF *, uint32_t);
  extern int32_t (*ppa_hook_bridge_entry_delete_fn)(uint8_t *, uint32_t);
  extern int32_t (*ppa_hook_bridge_entry_hit_time_fn)(uint8_t *, uint32_t *);
  extern int32_t (*ppa_hook_bridge_entry_inactivity_status_fn)(uint8_t *);
  extern int32_t (*ppa_hook_set_bridge_entry_timeout_fn)(uint8_t *, uint32_t);

  extern int32_t (*ppa_hook_set_bridge_if_vlan_config_fn)(PPA_NETIF *, PPA_VLAN_TAG_CTRL *, PPA_VLAN_CFG *, uint32_t);
  extern int32_t (*ppa_hook_get_bridge_if_vlan_config_fn)(PPA_NETIF *, PPA_VLAN_TAG_CTRL *, PPA_VLAN_CFG *, uint32_t);
  extern int32_t (*ppa_hook_vlan_filter_add_fn)(PPA_VLAN_MATCH_FIELD *, PPA_VLAN_INFO *, uint32_t);
  extern int32_t (*ppa_hook_vlan_filter_del_fn)(PPA_VLAN_MATCH_FIELD *, PPA_VLAN_INFO *, uint32_t);
  extern int32_t (*ppa_hook_vlan_filter_get_all_fn)(int32_t *, PPA_VLAN_FILTER_CONFIG *, uint32_t);
  extern int32_t (*ppa_hook_vlan_filter_del_all_fn)(uint32_t);

  extern int32_t (*ppa_hook_get_if_stats_fn)(PPA_IFNAME *, PPA_IF_STATS *, uint32_t);
  extern int32_t (*ppa_hook_get_accel_stats_fn)(PPA_IFNAME *, PPA_ACCEL_STATS *, uint32_t);

  extern int32_t (*ppa_hook_set_if_mac_address_fn)(PPA_IFNAME *, uint8_t *, uint32_t);
  extern int32_t (*ppa_hook_get_if_mac_address_fn)(PPA_IFNAME *, uint8_t *, uint32_t);

  extern int32_t (*ppa_hook_add_if_fn)(PPA_IFINFO *, uint32_t);
  extern int32_t (*ppa_hook_del_if_fn)(PPA_IFINFO *, uint32_t);
  extern int32_t (*ppa_hook_get_if_fn)(int32_t *, PPA_IFINFO **, uint32_t);

  extern int32_t (*ppa_hook_directpath_register_dev_fn)(uint32_t *, PPA_NETIF *, PPA_DIRECTPATH_CB *, uint32_t);
  extern int32_t (*ppa_hook_directpath_send_fn)(uint32_t, PPA_BUF *, int32_t, uint32_t);
  extern int32_t (*ppa_hook_directpath_rx_stop_fn)(uint32_t, uint32_t);
  extern int32_t (*ppa_hook_directpath_rx_restart_fn)(uint32_t, uint32_t);
  extern PPA_NETIF *(*ppa_hook_get_netif_for_ppa_ifid_fn)(uint32_t);
  extern int32_t (*ppa_hook_get_ifid_for_netif_fn)(PPA_NETIF *);
#endif



#endif  //  __IFX_PPA_HOOK_H__20081103_1736__
