#ifndef __DANUBE_PPA_ETH_A4_H__2007_09_17__20_52__
#define __DANUBE_PPA_ETH_A4_H__2007_09_17__20_52__


/******************************************************************************
**
** FILE NAME    : danube_ppa_eth_a4.h
** PROJECT      : Danube
** MODULES      : ATM + MII0 Acceleration Package (PPA A4)
**
** DATE         : 17 SEP 2007
** AUTHOR       : Xu Liang
** DESCRIPTION  : ATM + MII0 Driver Header File
** COPYRIGHT    :   Copyright (c) 2006
**          Infineon Technologies AG
**          Am Campeon 1-12, 85579 Neubiberg, Germany
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 2 of the License, or
**    (at your option) any later version.
**
** HISTORY
** $Date        $Author         $Comment
** 17 SEP 2007  Xu Liang        Initiate Version
*******************************************************************************/



/*
 * ####################################
 *              Definition
 * ####################################
 */

/*
 *  ATM ioctl Command
 */
#define PPE_ATM_IOC_MAGIC           'o'
#define PPE_ATM_MIB_CELL            _IOW(PPE_ATM_IOC_MAGIC, 0, atm_cell_ifEntry_t)
#define PPE_ATM_MIB_AAL5            _IOW(PPE_ATM_IOC_MAGIC, 1, atm_aal5_ifEntry_t)
#define PPE_ATM_MIB_VCC             _IOWR(PPE_ATM_IOC_MAGIC, 2, atm_aal5_vcc_x_t)
#define PPE_ATM_MAP_PKT_PRIO_TO_Q   _IOR(PPE_ATM_IOC_MAGIC, 3, struct ppe_prio_q_map)
#define PPE_ATM_IOC_MAXNR           4

/*
 *  ethernet ioctl Command
 */
#define SET_VLAN_COS                    SIOCDEVPRIVATE + 0
#define SET_DSCP_COS                    SIOCDEVPRIVATE + 1
#define ENABLE_VLAN_CLASSIFICATION      SIOCDEVPRIVATE + 2
#define DISABLE_VLAN_CLASSIFICATION     SIOCDEVPRIVATE + 3
#define VLAN_CLASS_FIRST                SIOCDEVPRIVATE + 4
#define VLAN_CLASS_SECOND               SIOCDEVPRIVATE + 5
#define ENABLE_DSCP_CLASSIFICATION      SIOCDEVPRIVATE + 6
#define DISABLE_DSCP_CLASSIFICATION     SIOCDEVPRIVATE + 7
#define PASS_UNICAST_PACKETS            SIOCDEVPRIVATE + 8
#define FILTER_UNICAST_PACKETS          SIOCDEVPRIVATE + 9
#define KEEP_BROADCAST_PACKETS          SIOCDEVPRIVATE + 10
#define DROP_BROADCAST_PACKETS          SIOCDEVPRIVATE + 11
#define KEEP_MULTICAST_PACKETS          SIOCDEVPRIVATE + 12
#define DROP_MULTICAST_PACKETS          SIOCDEVPRIVATE + 13
#define ETH_MAP_PKT_PRIO_TO_Q           SIOCDEVPRIVATE + 14



/*
 * ####################################
 *              Data Type
 * ####################################
 */

/*
 *  Data Type Used to Call ATM ioctl
 */
typedef struct {
    int             vpi;
    int             vci;
    atm_aal5_vcc_t  mib_vcc;
} atm_aal5_vcc_x_t;

/*
 *  Data Type Used to Call ethernet ioctl
 */
struct vlan_cos_req {
    int     pri;
    int     cos_value;
};

struct dscp_cos_req {
    int     dscp;
    int     cos_value;
};

struct ppe_prio_q_map {
    int             pkt_prio;
    int             qid;
    int             vpi;    //  ignored in eth interface
    int             vci;    //  ignored in eth interface
};



/*
 * ####################################
 *             Declaration
 * ####################################
 */

#if defined(__KERNEL__)
  extern int IFX_ATM_LED_Callback_Register(void (*)(void));
  extern int IFX_ATM_LED_Callback_Unregister( void (*)(void));
#endif

extern u32 ephy_read_mdio_reg(int, int);
extern int ephy_write_mdio_reg (int, int, u32);
extern int ephy_auto_negotiate(int);



#endif  //  __DANUBE_PPA_ETH_A4_H__2007_09_17__20_52__
