#ifndef CONFIG_HMCP_SPINLOCK_H
#define CONFIG_HMCP_SPINLOCK_H

#define __LOCK(lock) \
	  do { preempt_disable(); __acquire(lock); (void)(lock); } while (0)

#define __LOCK_BH(lock) \
	  do { local_bh_disable(); __LOCK(lock); } while (0)

#define __LOCK_IRQ(lock) \
	  do { local_irq_disable(); __LOCK(lock); } while (0)

#define __LOCK_IRQSAVE(lock, flags) \
	  do { local_irq_save(flags); __LOCK(lock); } while (0)

#define __UNLOCK(lock) \
	  do { preempt_enable(); __release(lock); (void)(lock); } while (0)

#define __UNLOCK_BH(lock) \
	  do { preempt_enable_no_resched(); local_bh_enable(); __release(lock); (void)(lock); } while (0)

#define __UNLOCK_IRQ(lock) \
	  do { local_irq_enable(); __UNLOCK(lock); } while (0)

#define __UNLOCK_IRQRESTORE(lock, flags) \
	  do { local_irq_restore(flags); __UNLOCK(lock); } while (0)

#define hmcp_spin_lock(lock)                        __LOCK(lock)
#define hmcp_spin_lock_nested(lock, subclass)       __LOCK(lock)
#define hmcp_read_lock(lock)                        __LOCK(lock)
#define hmcp_write_lock(lock)                       __LOCK(lock)
#define hmcp_spin_lock_bh(lock)                     __LOCK_BH(lock)
#define hmcp_read_lock_bh(lock)                     __LOCK_BH(lock)
#define hmcp_write_lock_bh(lock)                    __LOCK_BH(lock)
#define hmcp_spin_lock_irq(lock)                    __LOCK_IRQ(lock)
#define hmcp_read_lock_irq(lock)                    __LOCK_IRQ(lock)
#define hmcp_write_lock_irq(lock)                   __LOCK_IRQ(lock)
#define hmcp_spin_lock_irqsave(lock, flags)         __LOCK_IRQSAVE(lock, flags)
#define hmcp_read_lock_irqsave(lock, flags)         __LOCK_IRQSAVE(lock, flags)
#define hmcp_write_lock_irqsave(lock, flags)        __LOCK_IRQSAVE(lock, flags)
#define hmcp_spin_trylock(lock)                     ({ __LOCK(lock); 1; })
#define hmcp_read_trylock(lock)                     ({ __LOCK(lock); 1; })
#define hmcp_write_trylock(lock)                    ({ __LOCK(lock); 1; })
#define hmcp_spin_trylock_bh(lock)                  ({ __LOCK_BH(lock); 1; })
#define hmcp_spin_unlock(lock)                      __UNLOCK(lock)
#define hmcp_read_unlock(lock)                      __UNLOCK(lock)
#define hmcp_write_unlock(lock)                     __UNLOCK(lock)
#define hmcp_spin_unlock_bh(lock)                   __UNLOCK_BH(lock)
#define hmcp_write_unlock_bh(lock)                  __UNLOCK_BH(lock)
#define hmcp_read_unlock_bh(lock)                   __UNLOCK_BH(lock)
#define hmcp_spin_unlock_irq(lock)                  __UNLOCK_IRQ(lock)
#define hmcp_read_unlock_irq(lock)                  __UNLOCK_IRQ(lock)
#define hmcp_write_unlock_irq(lock)                 __UNLOCK_IRQ(lock)
#define hmcp_spin_unlock_irqrestore(lock, flags)    __UNLOCK_IRQRESTORE(lock, flags)
#define hmcp_read_unlock_irqrestore(lock, flags)    __UNLOCK_IRQRESTORE(lock, flags)
#define hmcp_write_unlock_irqrestore(lock, flags)   __UNLOCK_IRQRESTORE(lock, flags)

#endif
