/******************************************************************************
**
** FILE NAME    : amazon_se_rcu.h
** PROJECT      : Amazon_se
** MODULES      : RCU
**
** DATE         : 09 Aug 2005
** AUTHOR       : Huang Xiaogang
** DESCRIPTION  : Amazon_se Reset Control Logic(RCU) driver head file
** COPYRIGHT    :       Copyright (c) 2006
**                      Infineon Technologies AG
**                      Am Campeon 1-12, 85579 Neubiberg, Germany
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 2 of the License, or
**    (at your option) any later version.
**
** HISTORY
** $Date        $Author         $Comment
** 01 Jan 2006  Huang Xiaogang  modification & verification on Amazon_se chip
*******************************************************************************/

#ifndef AMAZON_SE_RCU_H
#define AMAZON_SE_RCU_H


#undef RCU_DEBUG 

//#define RCU_DEBUG 1

#ifdef RCU_DEBUG

unsigned int rcu_global_register[16]={ 0x00000000,0x000000001, 0x00000002, 0x00000003, 0x00000004, 0x00000005, 0x00000006, 0x00000007, 0x00000008, 0x00000009, 0x0000000A , 0x0000000B, 0x0000000C, 0x0000000D, 0x0000000E, 0x0000000F}; 

#define AMAZON_SE_RCU_REG32(addr)                  rcu_global_register[(addr - AMAZON_SE_RCU_BASE_ADDR)/4]

#define AMAZON_SE_RCU_READ_REG(addr, reg)          reg = rcu_global_register[(addr -AMAZON_SE_RCU_BASE_ADDR)/4]

#define AMAZON_SE_RCU_WRITE_REG(addr, reg)         rcu_global_register[(addr - AMAZON_SE_RCU_BASE_ADDR)/4] = reg



#else

#define AMAZON_SE_RCU_REG32(addr)                  (*((volatile unsigned int*)(addr)))

#define AMAZON_SE_RCU_READ_REG(addr, reg)          reg = (*((volatile unsigned int *)(addr)))

#define AMAZON_SE_RCU_WRITE_REG(addr, reg)         *((volatile unsigned int*)(addr)) = reg 

#endif

#define AMAZON_SE_RCU_IOC_MAGIC              0xf0
#define AMAZON_SE_RCU_IOC_SET_RCU_RST_REQ    _IOW( AMAZON_SE_RCU_IOC_MAGIC, 0, amazon_se_rst_req_parm_t)
#define AMAZON_SE_RCU_IOC_GET_RCU_RST_REQ    _IOW( AMAZON_SE_RCU_IOC_MAGIC, 1, amazon_se_rst_req_parm_t)
#define AMAZON_SE_RCU_IOC_GET_STATUS         _IOR( AMAZON_SE_RCU_IOC_MAGIC, 2, amazon_se_rst_stat_parm_t)
#define AMAZON_SE_RCU_IOC_MAXNR              2

typedef union{
  struct{
    unsigned int srd0_hrst      : 1;
    unsigned int srd1_cpu0      : 1;
    unsigned int srd2_fpi       : 1;
    unsigned int srd3_cpu1      : 1;

    unsigned int srd4_usb       : 1;
    unsigned int res5           : 1;
    unsigned int srd6_ahb       : 1;
    unsigned int srd7_arc_dfe   : 1;

    unsigned int srd8_ppe       : 1;
    unsigned int srd9_dma       : 1;
    unsigned int srd10_sdio     : 1;
    unsigned int srd11_dsl_afe  : 1;

    unsigned int res1213        : 2;
    unsigned int srd14_mc       : 1;
    unsigned int test_md        : 1;

    unsigned int srdephy        : 1;
    unsigned int res17          : 1;
    unsigned int boot           : 3;
    unsigned int endian         : 1;
    unsigned int res2225        : 4;
    unsigned int ejrst          : 1;
    unsigned int pwor           : 1;

    unsigned int res28          : 1;
    unsigned int srst           : 1;
    unsigned int res30          : 1;
    unsigned int wdtrst0        : 1;
   }field;
  u32 amazon_se_rst_stat;
}amazon_se_rst_stat_parm_t;

typedef union{
  struct{
    unsigned int rd0_hrst      : 1;
    unsigned int rd1_cpu0      : 1;
    unsigned int rd2_fpi       : 1;
    unsigned int res3          : 1;

    unsigned int rd4_usb       : 1;
    unsigned int res5          : 1;
    unsigned int rd6_ahb       : 1;
    unsigned int rd7_arc_dfe   : 1;

    unsigned int rd8_ppe       : 1;
    unsigned int rd9_dma       : 1;
    unsigned int rd10_sdio     : 1;
    unsigned int rd11_dsl_afe  : 1;

    unsigned int res12         : 1;
    unsigned int res13         : 1;
    unsigned int rd14_mc       : 1;
    unsigned int jtag          : 1;

    unsigned int res1619       : 4;

    unsigned int ephy_rst      : 1;
    unsigned int res21         : 1;
    unsigned int mux_dfem      : 1;
    unsigned int mux_arc       : 1;

    unsigned int res24         : 1;
    unsigned int endinit       : 1;
    unsigned int reg18_pd      : 1;
    unsigned int res2728       : 2;
    unsigned int gio_en        : 1;		
    unsigned int srst          : 1;		
    unsigned int enmip         : 1;		
   }field;
  u32 amazon_se_rst_req;
}amazon_se_rst_req_parm_t;

#endif /* AMAZON_SE_RCU */



