/*
 * ########################################################################
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ########################################################################
 *
 * amazon_se_gpio.h
 *
 * Global Amazon_SE port driver header file
 *
 */

/* Modification history */
/* 21Jun2004	btxu	Generate from Inca_IP project */

/**
  \file amazon_se_gpio.h
  \brief header file for amazon_s gpio driver
*/

/*!
  \defgroup AMAZON_SE_BSP AMAZON_SE BSP
*/

/**
  \defgroup AMAZON_SE_GPIO
  \ingroup AMAZON_SE_BSP
  \brief amazon_s gpio driver module
*/

/*!
  \defgroup AMAZON_SE_GPIO_DEFINITIONS
  \ingroup AMAZON_SE_GPIO
  \brief definitions for amazon_s gpio driver
*/


#ifndef AMAZON_SE_GPIO_H
#define AMAZON_SE_GPIO_H

#ifndef __IFX_GPIO_IOCTL__
#define __IFX_GPIO_IOCTL__

#define PORT_MODULE_NAME_MAX    32
/* module id for all kinds of gpio users */
enum {
    PORT_AVAILABLE       = -1,
    PORT_MODULE_LEGACY   = 0,
    PORT_MODULE_MIN      = PORT_MODULE_LEGACY,
    PORT_MODULE_MEI_JTAG = 1,
    PORT_MODULE_SSC      = 2,
    PORT_MODULE_ASC      = 3,
    PORT_MODULE_SDIO     = 4,
    PORT_MODULE_LED      = 5,
    PORT_MODULE_USB      = 6,
    PORT_MODULE_SWITCH   = 7,        /*Reddy @10032008,  Add for Switch module */
    PORT_MODULE_PCI      = 8,
    PORT_MODULE_NAND     = 9,
    PORT_MODULE_PPA      = 10,
    PORT_MODULE_TAPI     = 11,
    PORT_MODULE_MAX      = PORT_MODULE_TAPI,
};

#define PORT_MODULE_ID	0xff

/* @{ */
/*!  \brief Parameter structure used to configure gpio port/pin value.
 */
struct amazon_se_port_ioctl_parm {
	int port;          /*!< GPIO port number 0 ~ 3 */
	int pin;           /*!< GPIO pin number 0 ~ 15 */
	int value;         /*!< value to be set */
	int module;        /*!< module id of this operation */
};

#define AMAZON_SE_PORT_IOC_MAGIC	0xbf
#define AMAZON_SE_PORT_IOCOD	     _IOW( AMAZON_SE_PORT_IOC_MAGIC,0,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCPUDSEL	 _IOW( AMAZON_SE_PORT_IOC_MAGIC,1,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCPUDEN	 _IOW( AMAZON_SE_PORT_IOC_MAGIC,2,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCSTOFF	 _IOW( AMAZON_SE_PORT_IOC_MAGIC,3,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCDIR	 _IOW( AMAZON_SE_PORT_IOC_MAGIC,4,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCOUTPUT	 _IOW( AMAZON_SE_PORT_IOC_MAGIC,5,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCINPUT	 _IOWR(AMAZON_SE_PORT_IOC_MAGIC,6,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCALTSEL0 _IOW( AMAZON_SE_PORT_IOC_MAGIC,7,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCALTSEL1 _IOW( AMAZON_SE_PORT_IOC_MAGIC,8,struct amazon_se_port_ioctl_parm)
/* @} */

#define bsp_port_ioctl_parm     amazon_se_port_ioctl_parm

#define BSP_PORT_IOC_MAGIC	    AMAZON_SE_PORT_IOC_MAGIC
#define BSP_PORT_IOCOD	        AMAZON_SE_PORT_IOCOD
#define BSP_PORT_IOCPUDSEL	    AMAZON_SE_PORT_IOCPUDSEL
#define BSP_PORT_IOCPUDEN	    AMAZON_SE_PORT_IOCPUDEN
#define BSP_PORT_IOCSTOFF	    AMAZON_SE_PORT_IOCSTOFF
#define BSP_PORT_IOCDIR         AMAZON_SE_PORT_IOCDIR
#define BSP_PORT_IOCOUTPUT	    AMAZON_SE_PORT_IOCOUTPUT
#define BSP_PORT_IOCINPUT	    AMAZON_SE_PORT_IOCINPUT
#define BSP_PORT_IOCALTSEL0     AMAZON_SE_PORT_IOCALTSEL0
#define BSP_PORT_IOCALTSEL1     AMAZON_SE_PORT_IOCALTSEL1

#endif  //  __IFX_GPIO_IOCTL__


int amazon_se_port_reserve_pin(int port, int pin, int module_id);
int amazon_se_port_free_pin(int port, int pin, int module_id);
int amazon_se_port_set_open_drain(int port, int pin, int module_id);
int amazon_se_port_clear_open_drain(int port, int pin, int module_id);
int amazon_se_port_set_pudsel(int port, int pin, int module_id);
int amazon_se_port_clear_pudsel(int port, int pin, int module_id);
int amazon_se_port_set_puden(int port, int pin, int module_id);
int amazon_se_port_clear_puden(int port, int pin, int module_id);
int amazon_se_port_set_stoff(int port, int pin, int module_id);
int amazon_se_port_clear_stoff(int port, int pin, int module_id);
int amazon_se_port_set_dir_out(int port, int pin, int module_id);
int amazon_se_port_set_dir_in(int port, int pin, int module_id);
int amazon_se_port_set_output(int port, int pin, int module_id);
int amazon_se_port_clear_output(int port, int pin, int module_id);
int amazon_se_port_get_input(int port, int pin, int module_id);

int amazon_se_port_set_altsel0(int port, int pin, int module_id);
int amazon_se_port_clear_altsel0(int port, int pin, int module_id);
int amazon_se_port_set_altsel1(int port, int pin, int module_id);
int amazon_se_port_clear_altsel1(int port, int pin, int module_id);

/* Simply the possible future changes */
#define bsp_port_reserve_pin      amazon_se_port_reserve_pin
#define bsp_port_free_pin         amazon_se_port_free_pin
#define bsp_port_set_open_drain   amazon_se_port_set_open_drain
#define bsp_port_clear_open_drain amazon_se_port_clear_open_drain
#define bsp_port_set_pudsel       amazon_se_port_set_pudsel
#define bsp_port_clear_pudsel     amazon_se_port_clear_pudsel
#define bsp_port_set_puden        amazon_se_port_set_puden
#define bsp_port_clear_puden      amazon_se_port_clear_puden
#define bsp_port_set_stoff        amazon_se_port_set_stoff
#define bsp_port_clear_stoff      amazon_se_port_clear_stoff
#define bsp_port_set_dir_out      amazon_se_port_set_dir_out
#define bsp_port_set_dir_in       amazon_se_port_set_dir_in
#define bsp_port_set_output       amazon_se_port_set_output
#define bsp_port_clear_output     amazon_se_port_clear_output
#define bsp_port_get_input        amazon_se_port_get_input
#define bsp_port_set_altsel0      amazon_se_port_set_altsel0
#define bsp_port_clear_altsel0    amazon_se_port_clear_altsel0
#define bsp_port_set_altsel1      amazon_se_port_set_altsel1
#define bsp_port_clear_altsel1    amazon_se_port_clear_altsel1

#endif /* AMAZON_SE_GPIO_H */


