#ifndef __AMAZON_SE_LED_DEV_H__2005_07_22__13_37__
#define __AMAZON_SE_LED_DEV_H__2005_07_22__13_37__


/******************************************************************************
**
** FILE NAME    : amazon_se_led.h
** PROJECT      : Amazon_se
** MODULES      : LED
**
** DATE         : 22 JUL 2005
** AUTHOR       : Xu Liang
** DESCRIPTION  : LED Controller Driver Header File
** COPYRIGHT    :       Copyright (c) 2006
**                      Infineon Technologies AG
**                      Am Campeon 1-12, 85579 Neubiberg, Germany
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 2 of the License, or
**    (at your option) any later version.
**
** HISTORY
** $Date        $Author         $Comment
** 22 JUL 2005  Xu Liang        Initiate Version
** 23 OCT 2006  Xu Liang        Add GPL header.
*******************************************************************************/


/*
 * ####################################
 *              Definition
 * ####################################
 */

/*
 *  ioctl Command
 */
#define LED_CONFIG                      0x01
#define DATA_LED_ON                      0x02
#define DATA_LED_OFF                     0x03

// led_control
#if (BOARD_TYPE == REFERENCE_BOARD)

#define LED_CONTROL                     0x0004 

#define LED_ON                          0x0001 
#define LED_OFF                         0x0002 
//#define LED_BLINK                       0x0003 

#define POWER_ON_LED                    0x0001
#define WARNING_LED                     0x0002
#define USB_LINK_LED                    0x0003
#define WAN_STATUS_LED                  0x0004
//#define EPHY_LINK_LED                   0x0005
//#define EPHY_SPEED_LED                  0x0006
//#define ADSL_DATA_LED                   0x0007
//#define ADSL_LINK_LED                   0x0008
#define ALL_LED                         0x000F

#endif
// end of led_control

/*
 *  Definition of Operation MASK
 */
#define CONFIG_OPERATION_UPDATE_SOURCE  0x0001
#define CONFIG_OPERATION_BLINK          0x0002
#define CONFIG_OPERATION_UPDATE_CLOCK   0x0004
#define CONFIG_OPERATION_STORE_MODE     0x0008
#define CONFIG_OPERATION_SHIFT_CLOCK    0x0010
#define CONFIG_OPERATION_DATA_OFFSET    0x0020
#define CONFIG_OPERATION_NUMBER_OF_LED  0x0040
#define CONFIG_OPERATION_DATA           0x0080
#define CONFIG_OPERATION_MIPS0_ACCESS   0x0100
#define CONFIG_DATA_CLOCK_EDGE          0x0200


/*
 *  Data Type Used to Call ioctl
 */
struct led_config_param {
    unsigned long   operation_mask;         //  Select operations to be performed
    unsigned long   led;                    //  LED to change update source (LED or ADSL)
    unsigned long   source;                 //  Corresponding update source (LED or ADSL)
    unsigned long   blink_mask;             //  LEDs to set blink mode
    unsigned long   blink;                  //  Set to blink mode or normal mode
    unsigned long   update_clock;           //  Select the source of update clock
    unsigned long   fpid;                   //  If FPI is the source of update clock, set the divider
                                            //  else if GPT is the source, set the frequency
    unsigned long   store_mode;             //  Set clock mode or single pulse mode for store signal
    unsigned long   fpis;                   //  FPI is the source of shift clock, set the divider
    unsigned long   data_offset;            //  Set cycles to be inserted before data is transmitted
    unsigned long   number_of_enabled_led;  //  Total number of LED to be enabled
    unsigned long   data_mask;              //  LEDs to set value
    unsigned long   data;                   //  Corresponding value
    unsigned long   mips0_access_mask;      //  LEDs to set access right
    unsigned long   mips0_access;           //  1: the corresponding data is output from MIPS0, 0: MIPS1
    unsigned long   f_data_clock_on_rising; //  1: data clock on rising edge, 0: data clock on falling edge


	// led_control
    unsigned long   led_id;               // power on, warning, usb link, wan status, ephy link, ephy speed, adsl data, adsl link 
    unsigned long   operation;              // on / off / blink
    unsigned long   duration;               // duration of blink, ms 
	// end of led_control
};


/*
 * ####################################
 *             Declaration
 * ####################################
 */

#if defined(__KERNEL__)
    extern int amazon_se_led_set_blink(unsigned int, unsigned int);
    extern int amazon_se_led_set_data(unsigned int, unsigned int);
    extern int amazon_se_led_config(struct led_config_param *);
#endif  //  defined(__KERNEL__)

#define PHY_LED_CTL_SPEED_MASK		0xF
#define PHY_LED_CTL_COLL_MASK		0xF0
#define PHY_LED_CTL_LINKACT_MASK	0xF00

#define PHY_LED_CTL_SPEED_SHIFT		0
#define PHY_LED_CTL_COLL_SHIFT		4
#define PHY_LED_CTL_LINKACT_SHIFT	8

#define PHY_LED_CTL_COLLISION		0
#define PHY_LED_CTL_ALL_ERRORS		1
#define PHY_LED_CTL_DUPLEX		2
#define PHY_LED_CTL_DUPLEX_COLL		3
#define PHY_LED_CTL_SPEED		4
#define PHY_LED_CTL_LINK		5
#define PHY_LED_CTL_TX_ACTIVITY		6
#define PHY_LED_CTL_RX_ACTIVITY		7
#define PHY_LED_CTL_TXRX_ACTIVITY	8
#define PHY_LED_CTL_LINK_RX_ACTIVITY	9
#define PHY_LED_CTL_LINK_TXRX_ACTIVITY	10
#define PHY_LED_CTL_100M_CERR		11
#define PHY_LED_CTL_100M_EOS		12
#define PHY_LED_CTL_100M_SERR		13
#define PHY_LED_CTL_DISTANCE		14
#define PHY_LED_CTL_CABLE_BROKEN_DIST	15
#endif  //  __AMAZON_SE_LED_DEV_H__2005_07_22__13_37__
