/******************************************************************************
**
** FILE NAME    : amazon_se_gpio_defs.h
** PROJECT      : Amazon-SE
** MODULES      : GPIO
**
** DATE         : 21 Jun 2004
** AUTHOR       : btxu
** DESCRIPTION  : Global AMAZON_SE_GPIO driver header file
** COPYRIGHT    :       CEopyright (c) 2006
**                      Infineon Technologies AG
**                      Am Campeon 1-12, 85579 Neubiberg, Germany
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 2 of the License, or
**    (at your option) any later version.
**
** HISTORY
** $Date        $Author         $Comment
** 21 Jun 2004   btxu            Generate from INCA-IP project
** 21 Jun 2005   Jin-Sze.Sow     Comments edited
** 01 Jan 2006   Huang Xiaogang  Modification & verification on Amazon_S chip
*******************************************************************************/

#ifndef AMAZON_SE_GPIO_DEFS_H
#define AMAZON_SE_GPIO_DEFS_H

#ifndef OK
#define OK	0
#endif 

enum {
    AMAZON_SE_PORT_OUT_REG = 0,
    AMAZON_SE_PORT_IN_REG,
    AMAZON_SE_PORT_DIR_REG,
    AMAZON_SE_PORT_ALTSEL0_REG,
    AMAZON_SE_PORT_ALTSEL1_REG,
    AMAZON_SE_PORT_OD_REG,
    AMAZON_SE_PORT_STOFF_REG,
    AMAZON_SE_PORT_PUDSEL_REG,
    AMAZON_SE_PORT_PUDEN_REG, 
    AMAZON_SE_PORT_REG_MAX_IDX,
};

//#define PORT_MODULE_ID	0xff

#define NOPS	asm("nop;nop;nop;nop;nop")

#define PORT_WRITE_REG(reg, value)   (*(reg) = (u32)(value))
#define PORT_READ_REG(reg, value)    ((value) = (u32)(*(reg)))

#define PORT_IOC_CALL(ret,port,pin,func,module) 	\
	ret=amazon_se_port_reserve_pin((port),(pin),(module)); \
	if (ret == 0) ret=func((port),(pin),(module)); \
	if (ret == 0) ret=amazon_se_port_free_pin((port),(pin),(module));

#endif /* AMAZON_SE_GPIO_DEFS_H */
