/*****************************************************************************
 **   FILE NAME       : dwc_otg_cil_ifx.h
 **   PROJECT         : USB Host and Device driver
 **   MODULES         : USB Host and Device driver
 **   SRC VERSION     : 2.0
 **   DATE            : 1/March/2008
 **   AUTHOR          : Chen, Howard based on Synopsys Original
 **   DESCRIPTION     : The Core Interface Layer provides basic services for accessing and
 **                     managing the DWC_otg hardware. These services are used by both the
 **                     Host Controller Driver and the Peripheral Controller Driver.
 **
 **                     The CIL manages the memory map for the core so that the HCD and PCD
 **                     don't have to do this separately. It also handles basic tasks like
 **                     reading/writing the registers and data FIFOs in the controller.
 **                     Some of the data access functions provide encapsulation of several
 **                     operations required to perform a task, such as writing multiple
 **                     registers to start a transfer. Finally, the CIL performs basic
 **                     services that are not specific to either the host or device modes
 **                     of operation. These services include management of the OTG Host
 **                     Negotiation Protocol (HNP) and Session Request Protocol (SRP). A
 **                     Diagnostic API is also provided to allow testing of the controller
 **                     hardware.
 **   FUNCTIONS       :
 **   COMPILER        : gcc
 **   REFERENCE       :
 **   COPYRIGHT       :
 **  Version Control Section  **
 **   $Author$
 **   $Date$
 **   $Revisions$
 **   $Log$       Revision history
*****************************************************************************/

/*! \file dwc_otg_cil_ifx.h
    \brief This file contains the interface to the Core Interface Layer.
*/
#if !defined(__DWC_OTG_CIL_IFX_H__)
#define __DWC_OTG_CIL_IFX_H__

/* ================ Default param value ================== */
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,0)

	#define dwc_param_opt_default 1
	#define dwc_param_dma_burst_size_default 4
	#define dwc_param_speed_default DWC_SPEED_PARAM_HIGH

	#if defined(CONFIG_AMAZON_SE)
		#define dwc_param_data_fifo_size_default 512
		#ifdef DWC_IS_DEVICE
			#ifdef USE_PERIODIC_EP
				#define dwc_param_dev_rx_fifo_size_default 252
				#define dwc_param_dev_nperio_tx_fifo_size_default 252
				#define dwc_param_dev_perio_tx_fifo_size_default 8
			#else
				#define dwc_param_dev_rx_fifo_size_default 256
				#define dwc_param_dev_nperio_tx_fifo_size_default 256
			#endif
			#define dwc_param_dev_endpoints_default 4
		#endif
		#ifdef DWC_IS_HOST
			#define dwc_param_host_rx_fifo_size_default 240
			#define dwc_param_host_nperio_tx_fifo_size_default 240
			#define dwc_param_host_perio_tx_fifo_size_default 32
			#define dwc_param_host_channels_default 16
		#endif
	#elif defined(CONFIG_TWINPASS) || defined(CONFIG_DANUBE)
		#define dwc_param_data_fifo_size_default 2048
		#ifdef DWC_IS_DEVICE
			#ifdef USE_PERIODIC_EP
				#define dwc_param_dev_rx_fifo_size_default 640
				#define dwc_param_dev_nperio_tx_fifo_size_default 640
				#define dwc_param_dev_perio_tx_fifo_size_default 768
			#else
				#define dwc_param_dev_rx_fifo_size_default 1024
				#define dwc_param_dev_nperio_tx_fifo_size_default 1024
			#endif
			#define dwc_param_dev_endpoints_default 4
		#endif
		#ifdef DWC_IS_HOST
			#define dwc_param_host_rx_fifo_size_default 640
			#define dwc_param_host_nperio_tx_fifo_size_default 640
			#define dwc_param_host_perio_tx_fifo_size_default 768
			#define dwc_param_host_channels_default 16
		#endif
	#elif defined(CONFIG_AMAZON_S)
		#define dwc_param_data_fifo_size_default 512
		#ifdef DWC_IS_DEVICE
			#ifdef USE_PERIODIC_EP
				#define dwc_param_dev_rx_fifo_size_default 252
				#define dwc_param_dev_nperio_tx_fifo_size_default 252
				#define dwc_param_dev_perio_tx_fifo_size_default 8
			#else
				#define dwc_param_dev_rx_fifo_size_default 256
				#define dwc_param_dev_nperio_tx_fifo_size_default 256
			#endif
			#define dwc_param_dev_endpoints_default 4
		#endif
		#ifdef DWC_IS_HOST
			#define dwc_param_host_rx_fifo_size_default 240
			#define dwc_param_host_nperio_tx_fifo_size_default 240
			#define dwc_param_host_perio_tx_fifo_size_default 32
			#define dwc_param_host_channels_default 16
		#endif
	#endif

	#define dwc_param_max_transfer_size_default 65535
	#define dwc_param_max_packet_count_default 511
	#define dwc_param_phy_utmi_width_default 16
	#define dwc_param_turn_around_time_hs_default 5
	//#define dwc_param_turn_around_time_fs_default 9
	#define dwc_param_turn_around_time_fs_default 5
	#define dwc_param_timeout_cal_hs_default 0
	#define dwc_param_timeout_cal_fs_default 0

#else // for linux-2.4
	/* Winder: default is for Infineon Danube/Twinpass system.
	 * If other platform need to use USB, please pass modules param.
	 */
	static unsigned long dwc_param_opt = 1;
	static unsigned long dwc_param_dma_burst_size = 4;
	static unsigned long dwc_param_speed = 0;


	#if defined(CONFIG_AMAZON_SE)
		static unsigned long dwc_param_data_fifo_size = 512;
		#ifdef DWC_IS_DEVICE
			#ifdef USE_PERIODIC_EP
				static unsigned long dwc_param_dev_rx_fifo_size = 252;
				static unsigned long dwc_param_dev_nperio_tx_fifo_size = 252;
				static unsigned long dwc_param_dev_perio_tx_fifo_size = 8;
			#else
				static unsigned long dwc_param_dev_rx_fifo_size = 256;
				static unsigned long dwc_param_dev_nperio_tx_fifo_size = 256;
			#endif
			static unsigned long dwc_param_dev_endpoints = 4;
		#endif
		#ifdef DWC_IS_HOST
			static unsigned long dwc_param_host_rx_fifo_size = 240;
			static unsigned long dwc_param_host_nperio_tx_fifo_size = 240;
			static unsigned long dwc_param_host_perio_tx_fifo_size = 32;
			static unsigned long dwc_param_host_channels = 16;
		#endif
	#elif defined(CONFIG_TWINPASS) || defined(CONFIG_DANUBE)
		static unsigned long dwc_param_data_fifo_size = 2048;
		#ifdef DWC_IS_DEVICE
			#ifdef USE_PERIODIC_EP
				static unsigned long dwc_param_dev_rx_fifo_size = 640;
				static unsigned long dwc_param_dev_nperio_tx_fifo_size = 640;
				static unsigned long dwc_param_dev_perio_tx_fifo_size = 768;
			#else
				static unsigned long dwc_param_dev_rx_fifo_size = 1024;
				static unsigned long dwc_param_dev_nperio_tx_fifo_size = 1024;
			#endif
			static unsigned long dwc_param_dev_endpoints = 4;
		#endif
		#ifdef DWC_IS_HOST
			static unsigned long dwc_param_host_rx_fifo_size = 640;
			static unsigned long dwc_param_host_nperio_tx_fifo_size = 640;
			static unsigned long dwc_param_host_perio_tx_fifo_size = 768;
			static unsigned long dwc_param_host_channels = 16;
		#endif
	#elif defined(CONFIG_AMAZON_S)
		static unsigned long dwc_param_data_fifo_size = 512;
		#ifdef DWC_IS_DEVICE
			#ifdef USE_PERIODIC_EP
				static unsigned long dwc_param_dev_rx_fifo_size = 252;
				static unsigned long dwc_param_dev_nperio_tx_fifo_size = 252;
				static unsigned long dwc_param_dev_perio_tx_fifo_size = 8;
			#else
				static unsigned long dwc_param_dev_rx_fifo_size = 256;
				static unsigned long dwc_param_dev_nperio_tx_fifo_size = 256;
			#endif
			static unsigned long dwc_param_dev_endpoints = 4;
		#endif
		#ifdef DWC_IS_HOST
			static unsigned long dwc_param_host_rx_fifo_size = 240;
			static unsigned long dwc_param_host_nperio_tx_fifo_size = 240;
			static unsigned long dwc_param_host_perio_tx_fifo_size = 32;
			static unsigned long dwc_param_host_channels = 16;
		#endif

	#endif

	static unsigned long dwc_param_max_transfer_size = 65535;
	static unsigned long dwc_param_max_packet_count = 511;
	static unsigned long dwc_param_phy_utmi_width = 16;
	static unsigned long dwc_param_turn_around_time_hs = 5;
	//static unsigned long dwc_param_turn_around_time_fs = 9;
	static unsigned long dwc_param_turn_around_time_fs = 5;
	static unsigned long dwc_param_timeout_cal_hs = 0;
	static unsigned long dwc_param_timeout_cal_fs = 0;

	#define dwc_param_opt_default dwc_param_opt
	#define dwc_param_dma_burst_size_default dwc_param_dma_burst_size
	#define dwc_param_speed_default dwc_param_speed
	#define dwc_param_data_fifo_size_default dwc_param_data_fifo_size
	#ifdef DWC_IS_DEVICE
		#define dwc_param_dev_rx_fifo_size_default dwc_param_dev_rx_fifo_size
		#define dwc_param_dev_nperio_tx_fifo_size_default dwc_param_dev_nperio_tx_fifo_size
		#ifdef USE_PERIODIC_EP
			#define dwc_param_dev_perio_tx_fifo_size_default dwc_param_dev_perio_tx_fifo_size
		#endif
		#define dwc_param_dev_endpoints_default dwc_param_dev_endpoints
	#endif
	#ifdef DWC_IS_HOST
		#define dwc_param_host_rx_fifo_size_default dwc_param_host_rx_fifo_size
		#define dwc_param_host_nperio_tx_fifo_size_default dwc_param_host_nperio_tx_fifo_size
		#define dwc_param_host_perio_tx_fifo_size_default dwc_param_host_perio_tx_fifo_size
		#define dwc_param_host_channels_default dwc_param_host_channels
	#endif
	#define dwc_param_max_transfer_size_default dwc_param_max_transfer_size
	#define dwc_param_max_packet_count_default dwc_param_max_packet_count
	#define dwc_param_phy_utmi_width_default dwc_param_phy_utmi_width

	#define dwc_param_turn_around_time_hs_default dwc_param_turn_around_time_hs
	#define dwc_param_turn_around_time_fs_default dwc_param_turn_around_time_fs
	#define dwc_param_timeout_cal_hs_default dwc_param_timeout_cal_hs
	#define dwc_param_timeout_cal_fs_default dwc_param_timeout_cal_fs

#endif
/* ======================================================= */

#endif // __DWC_OTG_CIL_IFX_H__

