
/******************************************************************************
**
** FILE NAME    : amazon_se_sflash.h
** PROJECT      : amazon_se bsp
** MODULES      : SPI Flash
**
** DATE         : 20 Nov 2007
** AUTHOR       : Lei Chuanhua
** DESCRIPTION  : SPI Flash MTD Driver
** COPYRIGHT    :       Copyright (c) 2007
**                      Infineon Technologies AG
**                      Am Campeon 1-12, 85579 Neubiberg, Germany
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 2 of the License, or
**    (at your option) any later version.
**
** HISTORY
** $Date        $Author         $Comment
**  20 Nov 2007  Lei Chuanhua    Initiate Version
*******************************************************************************/

#ifndef AMAZON_SE_SFLASH_H
#define AMAZON_SE_SFLASH_H

#define BIT(n)   (1 << (n))

/* Flash related definition */

/* zero is reserved */
#define FLASH_256KB   1
#define FLASH_512KB   2
#define FLASH_1MB     3
#define FLASH_2MB     4
#define FLASH_4MB     5
#define FLASH_8MB     6
#define MX_MAX_FLASH  7

/* Identifier */
#define MX_VENDOR_ID                0xC2
#define MX_MEM_TYPE                 0x20

#define MX_2MBIT_SIGNATURE         	0x12
#define MX_MX25P2005_BYTE_COUNT    	(256 * 1024)
#define MX_MX25P2005_SECTOR_COUNT  	64
#define MX_MX25P2005_SECTOR_SIZE   	0x1000

#define MX_4MBIT_SIGNATURE     		0x13
#define MX_MX25P4005_BYTE_COUNT   	(512 * 1024)
#define MX_MX25P4005_SECTOR_COUNT 	128
#define MX_MX25P4005_SECTOR_SIZE  	0x1000

#define MX_8MBIT_SIGNATURE     		0x14
#define MX_MX25P8005_BYTE_COUNT   	(1 * 1024 * 1024)
#define MX_MX25P8005_SECTOR_COUNT 	256
#define MX_MX25P8005_SECTOR_SIZE  	0x1000

#define MX_16MBIT_SIGNATURE    		0x15
#define MX_MX25P1605_BYTE_COUNT   	(2 * 1024 * 1024)
#define MX_MX25P1605_SECTOR_COUNT 	32
#define MX_MX25P1605_SECTOR_SIZE  	0x10000

#define MX_32MBIT_SIGNATURE   	 	0x16
#define MX_MX25P3205_BYTE_COUNT   	(4 * 1024 * 1024)
#define MX_MX25P3205_SECTOR_COUNT 	64
#define MX_MX25P3205_SECTOR_SIZE  	0x10000

#define MX_64MBIT_SIGNATURE    		0x17
#define MX_MX25P6405_BYTE_COUNT   	(8 * 1024 * 1024)
#define MX_MX25P6405_SECTOR_COUNT 	128
#define MX_MX25P6405_SECTOR_SIZE  	0x10000

#define MX_256KB_SIZE_COUNT         MX_MX25P2005_BYTE_COUNT
#define MX_256KB_SECTOR_COUNT       MX_MX25P2005_SECTOR_COUNT
#define MX_256KB_SECTOR_SIZE        MX_MX25P2005_SECTOR_SIZE

#define MX_512KB_SIZE_COUNT         MX_MX25P4005_BYTE_COUNT
#define MX_512KB_SECTOR_COUNT       MX_MX25P4005_SECTOR_COUNT
#define MX_512KB_SECTOR_SIZE        MX_MX25P4005_SECTOR_SIZE
       
#define MX_1MB_SIZE_COUNT           MX_MX25P8005_BYTE_COUNT
#define MX_1MB_SECTOR_COUNT         MX_MX25P8005_SECTOR_COUNT
#define MX_1MB_SECTOR_SIZE          MX_MX25P8005_SECTOR_SIZE

#define MX_2MB_SIZE_COUNT           MX_MX25P1605_BYTE_COUNT
#define MX_2MB_SECTOR_COUNT         MX_MX25P1605_SECTOR_COUNT
#define MX_2MB_SECTOR_SIZE          MX_MX25P1605_SECTOR_SIZE

#define MX_4MB_SIZE_COUNT           MX_MX25P3205_BYTE_COUNT
#define MX_4MB_SECTOR_COUNT         MX_MX25P3205_SECTOR_COUNT
#define MX_4MB_SECTOR_SIZE          MX_MX25P3205_SECTOR_SIZE

#define MX_8MB_SIZE_COUNT           MX_MX25P6405_BYTE_COUNT
#define MX_8MB_SECTOR_COUNT         MX_MX25P6405_SECTOR_COUNT
#define MX_8MB_SECTOR_SIZE          MX_MX25P6405_SECTOR_SIZE


/* STM identifier */
#define STM_VENDOR_ID               0x20
#define STM_MEM_TYPE                0x20

/* Add more .... */

/* SST, STM, MX spi flash page size (256) */
#define SPI_FALSH_PAGE_SIZE               256      

/* Command Code */
#define SFLASH_WRSR      0x01    /* Write Status Register */
#define SFLASH_PP        0x02    /* Page Program */
#define SFLASH_READ      0x03
#define SFLASH_WRDI      0x04    /* Write Disable */
#define SFLASH_RDSR      0x05    /* Read Status Register */
#define SFLASH_WREN      0x06    /* Write Enable */
#define SFLASH_FAST_READ 0x0B
#define SFLASH_RDID      0x9F    /* Read Identification */
#define SFLASH_DP        0xB9    /* Deep Power Down */
#define SFLASH_CE        0xC7    /* Chip Erase */
#define SFLASH_SE        0xD8    /* Sector Erase */

/* Status Register bits */
#define SFLASH_SR_WIP       BIT(0)
#define SFLASH_SR_WEL       BIT(1)
#define SFLASH_SR_BP0       BIT(2)
#define SFLASH_SR_BP1       BIT(3)
#define SFLASH_SR_BP2       BIT(4)
#define SFLASH_SR_SRWD      BIT(7)
#define SFLASH_SR_BP_MASK   (7 << 2)
#define SFLASH_SR_BP(value) ((7 & (value)) << 2)
#define SFLASH_SR_BP_MAX    7

#endif  /* AMAZON_SE_SFLASH_H */

