

#ifndef __DAVINCI_SDIO_H
#define __DAVINCI_SDIO_H

#define SDIO_PRIVATE_STORAGE_SIZE 		10 /* use for sync operation */
#define EXT_SDIO_PRIVATE_STORAGE_SIZE 	20 /* use for async operation (sync + DMA registers sets)*/

#if 0
#define MMC_RSP_NONE	(0 << 0)
#define MMC_RSP_SHORT	(1 << 0)
#define MMC_RSP_LONG	(2 << 0)
#define MMC_RSP_MASK	(3 << 0)
#define MMC_RSP_CRC	(1 << 3)		/* expect valid crc */
#define MMC_RSP_BUSY	(1 << 4)		/* card may send busy */

/*
 * These are the response types, and correspond to valid bit
 * patterns of the above flags.  One additional valid pattern
 * is all zeros, which means we don't expect a response.
 */
#define MMC_RSP_R1	(MMC_RSP_SHORT|MMC_RSP_CRC)
#define MMC_RSP_R1B	(MMC_RSP_SHORT|MMC_RSP_CRC|MMC_RSP_BUSY)
#define MMC_RSP_R2	(MMC_RSP_LONG|MMC_RSP_CRC)
#define MMC_RSP_R3	(MMC_RSP_SHORT)
#define MMC_RSP_R4	(MMC_RSP_SHORT)
#define MMC_RSP_R5	(MMC_RSP_SHORT)
#define MMC_RSP_R6	(MMC_RSP_SHORT)
#endif

#define FUNCTION_SELECT_0 	       0 /* Transaction of function 0 (CIA) */
#define FUNCTION_SELECT_1 	       1 /* Transaction of function 0 (CIA) */

#define MMCINT_INTERRUPT    	IRQ_MMCINT
#define SDIOINT_INTERRUPT		IRQ_SDIOINT
#define MMCSD_REGS_BASE_ADDR  	DAVINCI_MMC_SD_BASE
#define SDIO_DRIVER_NAME 			"ssd"

/* Pprotocol defined constants */
#define SD_IO_GO_IDLE_STATE		  		0  
#define SD_IO_SEND_RELATIVE_ADDR	  	3 
#define SDIO_CMD5			  			5
#define SD_IO_SELECT_CARD		  		7 
#define SDIO_CMD52		 	 			52		
#define SDIO_CMD53		 	 			53


#define SD_IO_SEND_OP_COND		SDIO_CMD5  /* Command (IO_SEND_OP_COND, CMD5) stands 
						to prevent operation of I/O Functions in 
						non-I/O aware hosts requirement. */

#define SD_IO_RW_DIRECT			SDIO_CMD52 /* The IO_RW_DIRECT is the simplest means 
 						to access a single register within the total 
						128K of register space in any I/O function, 
						including the common I/O area (CIA). 
						This command reads or writes 1 byte using only
 						1 command/response pair. A common use is to
		 				initialize registers or monitor status values 
						for I/O functions. This command is the fastest 
						means to read or write single I/O registers, 
						as it requires only a single command/response
 						pair. The SDIO card s response to CMD52 will 
						be in one of two formats. If the communication
 						between the card and host is in the 1-bit or 
						4-bit SD mode, the response will be in a 
						48-bit response (R5). If the communication is
	 					using the SPI mode, the response will be a 
						16-bit R5 response. */

#define SD_IO_RW_EXTENDED		SDIO_CMD53 /* 'In order to read and write multiple 
                                                I/O registers with a single command, 
						command IO_RW_EXTENDED is defined. 
						This command allows the reading or
 						writing of a large number of I/O
 						registers with a single command. 
						Since this is a data transfer command, 	
						it provides the highest possible 
						transfer rate. The response from the 
						SDIO card to CMD53 will be R5 (the same 	
						as CMD52). For CMD53, the 8-bit data 
						field will be stuff bits and shall be 
						read as 0x00. 
						When executing the IO_RW_EXTENDED 
						(CMD53), the multi-byte or multi-block
 						data transfer is similar to the data 
						transfer for memory. For the multi-byte 
						transfer modes (block mode=0) the 
						following applies: 
						- IO_RW_EXTENDED byte read is similar 
						  to CMD17 (READ_SINGLE_BLOCK); 
						- IO_RW_EXTENDED byte write is similar 
						  to CMD24 (WRITE_BLOCK). 
						Note that the byte count for this transfer is 
						set in the command, rather than the fixed 
						block size. Thus, the size of the data 
						payload will be in the range of 1-512 bytes. 
						The block mode is similar to the following 							memory commands: 
						- IO_RW_EXTENDED block read is similar 
						  to CMD18 (READ_MULTIPLE_BLOCK);
						- IO_RW_EXTENDED block write is similar 
						  to CMD25 (WRITE_MULTIPLE_BLOCK). */

#define SDIO_SHIFT(v,n)                     (v<<n)
#define SDIO_RWFLAG(v)                      (SDIO_SHIFT(v,31))
#define SDIO_FUNCN(v)                       (SDIO_SHIFT(v,28))
#define SDIO_RAWFLAG(v)                     (SDIO_SHIFT(v,27))
#define SDIO_BLKM(v)                        (SDIO_SHIFT(v,27))
#define SDIO_OPCODE(v)                      (SDIO_SHIFT(v,26))
#define SDIO_ADDRREG(v)                     (SDIO_SHIFT(v,9))

/* Macros to build commands 52 and 53 in format according to SDIO spec */
#define SDIO_CMD52_READ(v1,v2,v3,v4)        (SDIO_RWFLAG(v1)|SDIO_FUNCN(v2)|SDIO_RAWFLAG(v3)| SDIO_ADDRREG(v4))
#define SDIO_CMD52_WRITE(v1,v2,v3,v4,v5)    (SDIO_RWFLAG(v1)|SDIO_FUNCN(v2)|SDIO_RAWFLAG(v3)| SDIO_ADDRREG(v4)|(v5))

#define SDIO_CMD53_READ(v1,v2,v3,v4,v5,v6)  (SDIO_RWFLAG(v1)|SDIO_FUNCN(v2)|SDIO_BLKM(v3)| SDIO_OPCODE(v4)|SDIO_ADDRREG(v5)|(v6&0x1ff))
#define SDIO_CMD53_WRITE(v1,v2,v3,v4,v5,v6) (SDIO_RWFLAG(v1)|SDIO_FUNCN(v2)|SDIO_BLKM(v3)| SDIO_OPCODE(v4)|SDIO_ADDRREG(v5)|(v6&0x1ff))

/* Card Common Control Registers (CCCR) */
#define CCCR_SDIO_REVISION             0x00
#define CCCR_SD_SPECIFICATION_REVISION 0x01
#define CCCR_IO_ENABLE                 0x02
#define CCCR_IO_READY                  0x03
#define CCCR_INT_ENABLE                0x04
#define CCCR_INT_PENDING               0x05
#define CCCR_IO_ABORT                  0x06
#define CCCR_BUS_INTERFACE_CONTOROL    0x07
#define CCCR_CARD_CAPABILITY	       0x08
#define CCCR_COMMON_CIS_POINTER        0x09 /*0x09-0x0B*/
#define CCCR_BUS_SUSPEND	       0x0c
#define CCCR_FUNCTION_SELECT	       0x0d
#define CCCR_EXEC_FLAGS	               0x0e
#define CCCR_READY_FLAGS	       0x0f
#define CCCR_FNO_BLOCK_SIZE	       0x10 /*0x10-0x11*/

#define VDD_VOLTAGE_WINDOW 0xffffc0

/* convert from miliseconds to cycles based on the sdio achieved clock. */
extern unsigned long achieved_clock_rate;
/* #define MILLI2CLKS(MILLIS) ((MILLIS) * achieved_clock_rate / 1000) */
#define MILLI2CLKS(MILLIS) (0xFFFFFFFF)

typedef enum {
	SDIO_SUCCESS=0,
	SDIO_FAILURE,
	SDIO_BUSY,
	SDIO_BAD_ALIGNMENT,
	SDIO_TIMEOUT,
	SDIO_BAD_INPUT_PARAMS,
	SDIO_BAD_CRC_CHECK
} SDIO_Status;



typedef enum
{
  Xfer_dma_internal_conf,
  Xfer_dma_external_conf
}dma_mode;


struct sdio_init_params{
	int MaxClockRate;
	int BusWidth;
};

#define MAX_STREAM_SIZE_IN_BYTE_MODE 512

#define MMCIM		0
#define MMCTOR		1
#define MMCTOD		2
#define MMCBLEN		3
#define MMCNBLK		4
#define MMCCMD		5
#define MMCARG		6
#define MMCFIFOCTL	7
#define CONTEXT		8
#define CALLBACK   9

extern u32 sdio_sync_read_priv[SDIO_PRIVATE_STORAGE_SIZE];
extern u32 sdio_sync_write_priv[SDIO_PRIVATE_STORAGE_SIZE];
extern u32 sdio_async_read_priv[EXT_SDIO_PRIVATE_STORAGE_SIZE];
extern u32 sdio_async_write_priv[EXT_SDIO_PRIVATE_STORAGE_SIZE];

/********************************************************************/
/*	SDIO driver function prototypes                                 */
/********************************************************************/

/* function prototypes for the low level part*/
int sdiodrv_init(struct sdio_init_params* param);


void sdiodrv_shutdown(void);

int sdiodrv_execute_cmd(unsigned long opcode,
                             unsigned long CmdArg,
                             int ReplyType,
                             int BusWidth,
                             void *DataBufferPointer,
                             int DataLength,
                             int BlockSize,
													   unsigned int timeout_clks);

int sdiodrv_read_sync_prepare(void *sdio_priv,
							  unsigned long opcode,
                           int ReplyType,
                           int BusWidth,
                           int BlockSize,
													 unsigned int timeout_clks);

int sdiodrv_read_sync(void *sdio_priv, 
					  void *DataBufferPointer, 
					  int sdio_address, 
					  int datalen);
													 
int sdiodrv_write_sync_prepare(void *sdio_priv,
							  unsigned long opcode,
                            int ReplyType,
                            int BusWidth,
                            int BlockSize,
														unsigned int timeout_clks);

int sdiodrv_write_sync(void *sdio_priv, 
					  void *DataBufferPointer, 
					  int sdio_address, 
					  int datalen);

int sdiodrv_read_byte(unsigned char *data, int Address);


int sdiodrv_write_byte(unsigned char data, int Address);


int sdiodrv_read_async_prepare(void *sdio_priv,
							   unsigned long opcode, 
                            int ReplyType,
                            int BusWidth,
                            int BlockSize,
							   void(*BusTxnCB)(void* handle, int status), 
                            void* Handle,
                            int Endless,
                            int dma_mode,
                            void* dma_params,
														 unsigned int timeout_clks);

int sdiodrv_read_async(void *sdio_priv, 
					  void *DataBufferPointer, 
					  int sdio_address, 
					  int datalen);



int sdiodrv_write_async_prepare(void *sdio_priv,
							   unsigned long opcode, 
                             int ReplyType,
                             int BusWidth,
                             int BlockSize,
							   void(*BusTxnCB)(void* handle, int status), 
                             void* Handle,
                             int Endless,
                             int dma_mode,
                             void* dma_params,
														 unsigned int timeout_clks);

int sdiodrv_write_async(void *sdio_priv, 
					  void *DataBufferPointer, 
					  int sdio_address, 
					  int datalen);



#endif/* __DAVINCI_SDIO_H */

