#include <linux/kernel.h>
#include <linux/slab.h>
/* #include <asm/arch/io.h> */
#include <linux/types.h>
/* #include <linux/dma-mapping.h> */
/* #include <asm/arch/edma.h> */
/* #include <asm/arch/hardware.h> */
#include <linux/errno.h>
/* #include <asm/hardware/clock.h> */
//#include <linux/mmc/mmc.h>
#include "davinci_sdiodrv.h"
#include "sdiodrv.h"
//#include "sdio_protocol.h"
#include "ssd_debug.h"
#include "ssd.h"	

#include <asm/amazon_se/amazon_se_sdio_card.h>
#include <asm/amazon_se/amazon_se_sdio.h>

void *ifx_sdio_controller_register_callback(void (*fct)(unsigned long));



/*ABsync is defined in kernel MV baseline 1
ABSYNC defnition changed in kernel MV baseline 2*/

/* #if defined(TI_KERNEL_BASELINE2) */
/* #define ABsync ABSYNC */
/* #endif */


/********************************************************************/
/*	SDIO driver parameters and structures					       */
/********************************************************************/

/* static edmacc_paramentry_regs temp_tx1, temp_tx2; */
/* static edmacc_paramentry_regs temp_rx1, temp_rx2; */
/* static volatile edmacc_regs *ptr_edmacc_regs = ((edmacc_regs *) IO_ADDRESS(DAVINCI_DMA_3PCC_BASE)); */

/* /\*Yanir: just a thought: all these globals should be grouped together to a "controller" structure..*\/ */
/* struct mmc_davinci_host *host; */
struct IO_request g_request;
/* volatile mmcsd_regs *mmcsdregs; */
/* struct clk *mmcclkp = NULL; */
static unsigned char cardstate = 1;
/* static unsigned char iscardinitialized = 0; */
/* /\* stores the link channel (PaRAM entries that are linked to the TX/RX channels) *\/ */
/* int TX_link_channel; */
/* int RX_link_channel; */
/* unsigned long achieved_clock_rate; */
/* static unsigned long reg_mmctor_val; */
/* #ifdef SSD_DEBUG */
/* /\*for debugging purposes - some memory overrun in ssd_testdrv (not solved yet) *\/ */
/* extern void* debugcallback; */
/* /\* used by the debug code to disable UDP logging from interrupt context. *\/ */
/* int interrupt_context = 0; */
/* #endif */
/********************************************************************/
/*	SDIO driver interrupt handling                                  */
/********************************************************************/
#ifdef SSD_DEBUG

void debug_print_status_mask(u16 status)
{
	char str[200];
	sprintf(str,"debug_print_status_mask: HW status: ");
	if(status & MMCSD_EVENT_WRITE)
		strcat(str, "MMCSD_EVENT_WRITE ");
	if(status & MMCSD_EVENT_READ)
		strcat(str, "MMCSD_EVENT_READ ");
	if(status & MMCSD_EVENT_BLOCK_XFERRED)
		strcat(str, "MMCSD_EVENT_BLOCK_XFERRED ");
	if(status & MMCSD_EVENT_ERROR_DATATIMEOUT)
		strcat(str, "MMCSD_EVENT_ERROR_DATATIMEOUT ");
	if(status & MMCSD_EVENT_ERROR_DATACRC)
		strcat(str, "MMCSD_EVENT_ERROR_DATACRC ");
	if(status & MMCSD_EVENT_ERROR_CMDTIMEOUT)
		strcat(str, "MMCSD_EVENT_ERROR_CMDTIMEOUT ");
	if(status & MMCSD_EVENT_ERROR_CMDCRC)
		strcat(str, "MMCSD_EVENT_ERROR_CMDCRC ");
	if(status & MMCSD_EVENT_EOFCMD)
		strcat(str, "MMCSD_EVENT_EOFCMD ");
	if(!status)
		strcat(str,"0");
	strcat(str,"\n");
	PDEBUG(str);
}

static inline void debug_print_req(void)
{
	PDEBUG("request print:\n");
	PDEBUG("direction: %d\n",g_request.direction);
	PDEBUG("channel: %d\n",g_request.channel);
	PDEBUG("callback: 0x%p\n",g_request.callback);
	PDEBUG("context: 0x%p\n",g_request.context);
}

static inline void error_print_req(void)
{
}

#else
#define debug_print_status_mask(status)
#define debug_print_req()
#define error_print_req()
#endif

static u32 report_error( u16 status )
{
	u32 ret = 0;

	printk("%s(): error - 0x%8.8x\n",__FUNCTION__,status & MMCSD_EVENT_ERROR);
	error_print_req();
	if (status & MMCSD_EVENT_ERROR_DATATIMEOUT)
	{
		printk("data timeout\n");
		ret |= MMC_ERR_TIMEOUT;
		cardstate = 0;
	}
	if (status & MMCSD_EVENT_ERROR_DATACRC)
	{
		printk("data crc\n");
		ret |= MMC_ERR_BADCRC;
	}
	if (status & MMCSD_EVENT_ERROR_CMDTIMEOUT)
	{
		printk("cmd timeout\n");
		ret |= MMC_ERR_TIMEOUT;
	}
	if (status & MMCSD_EVENT_ERROR_CMDCRC)
	{
		printk("cmd crc\n");
		ret |= MMC_ERR_BADCRC;
	}
	return ret;
}

void davinci_sdio_irq(int irq, void *dev_id, struct pt_regs *regs)
{
/* 	u16 status; */
/* 	int end_transfer = SDIO_ERR_EOT; */
/* 	int error = 0; */

/* 	CL_TRACE_START_L2(); */
/* #ifdef SSD_DEBUG */
/* 	interrupt_context = 1; */
/* #endif */
/* 	PDEBUG("entering %s()\n" , __FUNCTION__ ); */
/* 	/\* Read the interrupt status register *\/ */
/* 	status = mmcsdregs->mmcst0; */
/* 	if (status == 0){ */
/* 		return IRQ_HANDLED; */
/* #ifdef SSD_DEBUG */
/* 		interrupt_context = 0; */
/* #endif */
/* 	} */
/* 	/\* Loop until all events are processed *\/ */
/* 	while (status != 0) */
/* 	{ */
/* 		PINFO("davinci_sdio_irq: status: 0x%8.8x\n",status); */
/* 		debug_print_status_mask(status); */

/* 		if (status & MMCSD_EVENT_BLOCK_XFERRED) /\* Block sent/received *\/ */
/* 			end_transfer = 0; */

/* 		if(status & MMCSD_EVENT_ERROR) */
/* 			error = -report_error ( status ); */

/* 		/\* this is where we read the new status. *\/ */
/* 		status = mmcsdregs->mmcst0; */
/* 	} */

/* 	if (g_request.direction == read) */
/* 	{ */
/* 		volatile int z = 10; */
/* 		/\* wait for the fifo to be empty *\/ */

/* 		while ((!(mmcsdregs->mmcst1 & 0x20) || (mmcsdregs->mmcst1 & 0x8)) && --z) */
/* 			; */

/* 		if (z==0) */
/* 			error = -report_error ( status ); */

/* 		consistent_sync(g_request.DataBufferPointer,g_request.l1_cache_aligned_datalen,DMA_FROM_DEVICE); */

/* 	} */


/* 	davinci_stop_dma(g_request.channel); // ziv: please recheck this remark */


	/* if a transfer is completed, call the transfer completion function */
#ifdef SSD_DEBUG
	if(g_request.callback &&(debugcallback != g_request.callback))
	{
		PERR("ERROR IN INTERRUPT HANDLER: callback corrupted %p,%p\n",g_request.callback,debugcallback);
/* 		interrupt_context = 0; */
/* 		return IRQ_HANDLED; */
                return;
	}
#endif
	if(g_request.callback)
		g_request.callback(g_request.context, 0 /* error | end_transfer */);

	PDEBUG("exiting %s\n",__FUNCTION__);
/* #ifdef SSD_DEBUG */
/* 	interrupt_context = 0; */
/* #endif */
/* 	CL_TRACE_END_L2("ssd.ko", "ISR", "SDIO_DRV_ASYNC", ""); */
/* 	return IRQ_HANDLED; */
}




void ifx_sdio_irq(unsigned long status)
{
    int error = 0;
//	printk("%s(): error - 0x%08x\n",__FUNCTION__,status);

        /* if a transfer is completed, call the transfer completion function */
#ifdef SSD_DEBUG
        if(g_request.callback &&(debugcallback != g_request.callback))
        {
                PERR("ERROR IN INTERRUPT HANDLER: callback corrupted %p,%p\n",g_request.callback,debugcallback);
/*              interrupt_context = 0; */
/*              return IRQ_HANDLED; */
                return;
        }
#endif
        if(g_request.callback)
                g_request.callback(g_request.context, error /* | end_transfer */);
        PDEBUG("exiting %s\n",__FUNCTION__);
}



/********************************************************************/
/*	SDIO driver internal functions                                  */
/********************************************************************/

int sdio_davinci_start_dma_transfer(void *DataBufferPointer, int datalen, IO_direction direction)
{
/* 	int remainder; */
/* 	char* ptr; */
/* 	unsigned int num_eight_words = (datalen) / RW_THRESHOLD; */

/* 	CL_TRACE_START_L5(); */
/* 	if(num_eight_words < 2){ */
/* 		PERR("error - dma cannot be used on such small buffers.exiting %s\n", __FUNCTION__); */
/* 		return -1; */
/* 	} */
/* 	if(!(datalen%RW_THRESHOLD)) */
/* 	{ */
/* 		num_eight_words--; */
/* 		remainder = RW_THRESHOLD; */
/* 	}else */
/* 	{ */
/* 		remainder = (datalen%RW_THRESHOLD); */
/* 	} */
/* 	ptr = DataBufferPointer + (RW_THRESHOLD*num_eight_words); */
	g_request.DataBufferPointer = DataBufferPointer;
	g_request.l1_cache_aligned_datalen = L1_CACHE_ALIGN(datalen);
/* 	if (direction == write) */
/* 	{ */
/* 		g_request.channel = DAVINCI_DMA_MMCTXEVT; */
/*         // due to edma bug in driver (replace davinci_stop_dma(g_request.channel)) */
/*         ptr_edmacc_regs->shadow[0].ecr |= (1 << DAVINCI_DMA_MMCTXEVT); */
/* 		consistent_sync(DataBufferPointer,g_request.l1_cache_aligned_datalen,DMA_TO_DEVICE); */
/* 		temp_tx1.src = (unsigned int)virt_to_phys(DataBufferPointer); */
/* 		temp_tx1.ccnt = num_eight_words; */
/* 		davinci_set_dma_params(DAVINCI_DMA_MMCTXEVT, &temp_tx1); */

/* 		temp_tx2.src = (unsigned int)virt_to_phys(ptr); */
/* 		temp_tx2.src_dst_cidx &= 0xffff0000; */
/* 		temp_tx2.src_dst_cidx |= remainder; */
/* 		temp_tx2.a_b_cnt = (remainder << 16) | 1; */
/* 		davinci_set_dma_params(TX_link_channel, &temp_tx2); */

/* 		davinci_start_dma(DAVINCI_DMA_MMCTXEVT);  */
/* 	} */
/* 	else /\* read *\/ */
/* 	{ */
/* 		g_request.channel = DAVINCI_DMA_MMCRXEVT; */
/*         // due to edma bug in driver (replace davinci_stop_dma(g_request.channel)) */
/*         ptr_edmacc_regs->shadow[0].ecr |= (1 << DAVINCI_DMA_MMCRXEVT); */
/* 		consistent_sync(DataBufferPointer,g_request.l1_cache_aligned_datalen,DMA_FROM_DEVICE); */
/* 		temp_rx1.dst = (unsigned int)virt_to_phys(DataBufferPointer); */
/* 		temp_rx1.ccnt = num_eight_words; */
/* 		davinci_set_dma_params(DAVINCI_DMA_MMCRXEVT, &temp_rx1); */

/* 		temp_rx2.dst = (unsigned int)virt_to_phys(ptr); */
/* 		temp_rx2.src_dst_cidx &= 0x0000ffff; */
/* 		temp_rx2.src_dst_cidx |= ((unsigned long)remainder << 16); */
/* 		temp_rx2.a_b_cnt = (remainder << 16) | 1; */
/* 		davinci_set_dma_params(RX_link_channel, &temp_rx2); */

/* 		davinci_start_dma(DAVINCI_DMA_MMCRXEVT); */
/* 	} */
/* 	PDEBUG("exiting %s\n",__FUNCTION__); */
/* 	CL_TRACE_END_L5("ssd.ko", "INHERIT", "SDIO_DRV_ASYNC", ""); */
	return SDIO_SUCCESS;
}

int sdio_davinci_init_dma( void )
{
/* 	unsigned int result; */
/* 	int edmach = 0; */
/* 	int tcc = 0; */
/* 	PDEBUG("entering %s()\n" , __FUNCTION__ ); */

/* 	/\* Alocate a DMA channel for transmit *\/ */
/* 	result = davinci_request_dma(DAVINCI_DMA_MMCTXEVT, "SDIO_WRITE", NULL, host, &edmach, &tcc, EVENTQ_0); */
/* 	if (result != 0) { */
/* 		PERR ("SDIO: %s() failed with %d. exiting\n",__FUNCTION__, result); */
/* 		return result; */
/* 	} */

/* /\* allocate a dma channel that is linked to the TX default channel *\/ */
/* 	result = davinci_request_dma(DAVINCI_EDMA_PARAM_ANY, "SDIO_WRITE", NULL, host, &TX_link_channel, &tcc, EVENTQ_0); */
/* 	if (result != 0) 	{ */
/* 		PERR ("SDIO: %s() failed with %d\n",__FUNCTION__, result); */
/* 		return result; */
/* 	} */
/* /\* link the channels *\/ */
/* 	davinci_dma_link_lch(DAVINCI_DMA_MMCTXEVT, TX_link_channel); */

/* 	/\* Alocate a DMA channel for receive *\/ */
/* 	result = davinci_request_dma(DAVINCI_DMA_MMCRXEVT, "SDIO_READ", NULL, host, &edmach, &tcc, EVENTQ_0); */
/* 	if (result != 0) 	{ */
/* 		PERR ("SDIO: %s() failed with %d\n",__FUNCTION__, result); */
/* 		return result; */
/* 	} */
/* /\* allocate a dma channel that is linked to the RX default channel *\/ */
/* 	result = davinci_request_dma(DAVINCI_EDMA_PARAM_ANY, "SDIO_READ",  NULL, host, &RX_link_channel, &tcc, EVENTQ_0); */
/* 	if (result != 0) 	{ */
/* 		PERR ("SDIO: %s() failed with %d\n",__FUNCTION__, result); */
/* 		return result; */
/* 	} */
/* /\* link the channels *\/ */
/* 	davinci_dma_link_lch(DAVINCI_DMA_MMCRXEVT, RX_link_channel); */
/* 	PDEBUG("exiting %s\n",__FUNCTION__); */
	return SDIO_SUCCESS;
}


static unsigned int calculate_freq_for_card(unsigned int mmc_input_clk, unsigned int mmc_req_freq)
{
	unsigned int mmcfreq = 0, mmc_clock_divider = 0;
/* 	PDEBUG("entering %s()\n" , __FUNCTION__ ); */

/* 	PDEBUG("MMc input clock is %d(Hz)\n",mmc_input_clk); */
/* 	PDEBUG("Required SDIO clock is %d\n",mmc_req_freq); */

/* 	if (mmc_input_clk > (2 * mmc_req_freq)) { */
/* 		mmc_clock_divider = ((unsigned int)mmc_input_clk / (2 * mmc_req_freq)) - 1; */
/* 	} else { */
/* 		mmc_clock_divider = 0; */
/* 	} */

/* 	mmcfreq = (unsigned int)mmc_input_clk / (2 * (mmc_clock_divider + 1)); */

/* 	if (mmcfreq > mmc_req_freq) { */
/* 		mmc_clock_divider = mmc_clock_divider + 1; */
/* 	} */
/* 	achieved_clock_rate = (unsigned int)mmc_input_clk / (2 * (mmc_clock_divider + 1)); */
/* 	PDEBUG("Calculated clock divider is %d(Hz)\n",mmc_clock_divider); */
/* 	PDEBUG("The achived SDIO clock is %d(Hz)\n",(unsigned int)mmc_input_clk / (2 * (mmc_clock_divider + 1))); */
/* 	PDEBUG("exiting %s\n",__FUNCTION__); */
	return mmc_clock_divider;
}


/********************************************************************/
/*	SDIO driver interface functions                                 */
/********************************************************************/

int sdiodrv_init(struct sdio_init_params* param)
{
/* 	int ret = 0; */
/* 	struct clk *clkp = NULL; */
/* 	unsigned int mmc_clock_divider; */
/* 	unsigned int mmc_input_clk; */

/* 	reg_mmctor_val = MILLI2CLKS(ssd_cmd_response_timeout); */
/* 	PDEBUG("entering %s()\n" , __FUNCTION__ ); */
/* 	clkp = clk_get (NULL, "MMCSDCLK"); */
/* 	if (clkp == NULL) */
/* 		return(-ENODEV); */

/* 	mmcclkp = clkp; */
/*    	clk_use (mmcclkp); */
/*     clk_enable (mmcclkp); */
/* 	mmc_input_clk = clk_get_rate (mmcclkp); */

/* 	host = kmalloc(sizeof(struct mmc_davinci_host), GFP_KERNEL); */
/* 	if (!host) */
/* 		return -ENOMEM; */
/* 	memset(host, 0, sizeof(struct mmc_davinci_host)); */

	//g_request = kmalloc(sizeof(struct IO_request), GFP_KERNEL);
	//if (!g_request)
	//	return -ENOMEM;
	memset(&g_request, 0, sizeof(struct IO_request));

/* 	host->bus_mode = MMC_BUSMODE_PUSHPULL; */

/* 	mmcsdregs = (mmcsd_regs *) IO_ADDRESS(MMCSD_REGS_BASE_ADDR); */

/* 	mmcsdregs->mmcctl = mmcsdregs->mmcctl | 0x1;	/\*CMD line portion is diabled and in reset state *\/ */
/* 	mmcsdregs->mmcctl = mmcsdregs->mmcctl | (1 << 1);	/\*DAT line portion is diabled and in reset state *\/ */

/* 	/\* Select 4 bits data bus *\/ */
/* 	if(param->BusWidth == 4){ */
/* 		PDEBUG("bus width = 4\n"); */
/* 		mmcsdregs->mmcctl = mmcsdregs->mmcctl | 0x4; */
/* 	} */
/* 	mmcsdregs->mmcctl = mmcsdregs->mmcctl & ~(0x1); */
/* 	mmcsdregs->mmcctl = mmcsdregs->mmcctl & ~(1 << 1); */

/* 	/\* Clear the clock configuration register *\/ */
/* 	mmcsdregs->mmcclk = 0x0; */

/* 	/\* Configure the SDIO clock *\/ */
/* 	mmc_clock_divider = calculate_freq_for_card(mmc_input_clk, 1000000*(param->MaxClockRate)); */
/* 	mmcsdregs->mmcclk = (mmcsdregs->mmcclk & ~(0xFF)) | mmc_clock_divider; */

/* 	/\* Enable the SDIO clock *\/ */
/* 	mmcsdregs->mmcclk = mmcsdregs->mmcclk | (1 << 8); */

/* 	/\* Initialize time out resgiter to their maximum count *\/ */
/* 	mmcsdregs->mmctod = 0xFFFF; */

/* 	/\* Clear response register *\/ */
/* 	mmcsdregs->mmcrsp01 = 0; */
/* 	mmcsdregs->mmcrsp23 = 0; */
/* 	mmcsdregs->mmcrsp45 = 0; */
/* 	mmcsdregs->mmcrsp67 = 0; */

/* 	host->irq = MMCINT_INTERRUPT; */

/* 	ret == request_irq(MMCINT_INTERRUPT, davinci_sdio_irq, 0, SDIO_DRIVER_NAME, host); */

/* #ifdef SDIO_IN_BAND_INTERRUPT */
/* 	/\* Enable the in-band SDIO interrupt *\/ */
/* 	mmcsdregs->sdioien = 0x1; */
/* #endif */

/* 	/\* Allocate DMA channels for SDIO tansmit and receive *\/ */
/* 	PDEBUG("initializing DMA...\n"); */
/* 	if ( sdio_davinci_init_dma() ){ */
/* 		PERR("Failed to allocate DMA channels. exiting %s\n",__FUNCTION__); */
/* 		return -ENODEV; */
/* 	} */
            /* register sdio completion callback handler */
        ifx_sdio_controller_register_callback(ifx_sdio_irq);

	PDEBUG("exiting %s\n",__FUNCTION__);
	return 0;
}


void sdiodrv_shutdown(void)
{
	PDEBUG("entering %s()\n" , __FUNCTION__ );
	PDEBUG("disable the SDIO clock\n");
/*     clk_disable (mmcclkp); */
/*     clk_unuse (mmcclkp); */

/* 	if (host) */
/* 	{ */
/* 		PDEBUG("Free the MMCSD interrupt\n"); */
/* 		free_irq(MMCINT_INTERRUPT, host); */
/* 		kfree(host); */
/* 	} */
/* 	//if(g_request) */
/* 	//	kfree(g_request); */

/* 	PDEBUG("Free RX and TX DMA channels\n"); */
/* 	/\* unlink and free the linked channels *\/ */
/* 	davinci_free_dma(TX_link_channel); */
/* 	davinci_free_dma(RX_link_channel); */
/* 	davinci_free_dma(DAVINCI_DMA_MMCRXEVT); */
/* 	davinci_free_dma(DAVINCI_DMA_MMCTXEVT); */
	PDEBUG("exiting %s\n",__FUNCTION__);
	return;
}

int sdiodrv_execute_cmd(unsigned long opcode, unsigned long CmdArg, int ReplyType, int BusWidth, void *DataBufferPointer, int datalen, int BlockSize, unsigned int timeout_clks)
{
    x_IFX_sdio_cmd_t sdCmd;
    int ret;

    printk("opcode=%d, CmdArg=%d, ReplyType=%d, BusWidth=%d, DataBufferPointer=%p, datalen=%d, BlockSize=%d, timeout_clks=%d\n",
           opcode, CmdArg, ReplyType, BusWidth, DataBufferPointer, datalen, BlockSize, timeout_clks); 
    
    memset(&sdCmd, 0, sizeof(sdCmd));

    sdCmd.op_code = opcode;
    sdCmd.args = CmdArg;
    sdCmd.response_type = ReplyType;
    
    ret = ifx_sdio_send_cmd(&sdCmd);
/*     ret = 0; */

    if(datalen)
    {
        memcpy(DataBufferPointer,(char*)(&sdCmd.response[0]),datalen<4?datalen:4);
    }

/* 	u16 status; */
/* 	int end_command = 0; */
/* 	u32 ret = 0; */

/* 	/\* build the request *\/ */
/* 	PDEBUG("entering %s()\n" , __FUNCTION__ ); */
/* 	if(opcode == SD_IO_GO_IDLE_STATE)/\* command 0 implementation on this chip. *\/ */
/* 		opcode = opcode | (1 << 14); */

/* 	/\* clear status register *\/ */
/* 	status = mmcsdregs->mmcst0; */

/* 	/\* Set the transfer size in bytes and the number of blocks. right now we only use one block *\/ */
/* 	mmcsdregs->mmcnblk = 0;          /\* eq->blocks; *\/ */
/* 	mmcsdregs->mmcblen = 0; */

/* 	/\*set Command timeout *\/ */
/* 	mmcsdregs->mmctor = reg_mmctor_val; */

/* 	mmcsdregs->mmcim = 0; */

/* 	/\* write the command and arguments to the hardware. This will start the request *\/ */
/* 	PWARNING("mmccmd = 0x%lx, mmcarghl = 0x%lx\n", (opcode|(ReplyType << 9)), CmdArg); */

/* 	mmcsdregs->mmcarghl = CmdArg; */

/* 	/\* Set command index *\/ */
/* 	mmcsdregs->mmccmd =  ( opcode | */
/* 						   (ReplyType << 9) ); /\* Response type is R5 *\/ */


/* 	/\* Wait for end of write transfer *\/ */
/* 	while(!end_command) */
/* 	{ */
/* 		status = mmcsdregs->mmcst0; */
/* 		if (status & MMCSD_EVENT_EOFCMD) */
/* 		{ */
/* 			PDEBUG("changing end_command to 1\n"); */
/* 			end_command = TRUE; */
/* 		} */
/* 		if(status & MMCSD_EVENT_ERROR) */
/* 		{ */
/* 			ret = report_error(status); */
/* 			end_command = TRUE; */
/* 		} */
/* 	} */

/* 	if(opcode == SD_IO_RW_DIRECT && !(ret)) */
/* 	{ */
/* 		iscardinitialized = 1; */
/* 		cardstate = 1; */
/* 	} */

/* 	if(datalen) */
/* 	{ */
/* 		memcpy(DataBufferPointer,(char*)(&(mmcsdregs->mmcrsp67)),datalen<4?datalen:4); */
/* 	} */
/* 	PDEBUG("exiting %s\n",__FUNCTION__); */
	return ret;
}



int sdiodrv_read_sync_prepare(void *sdio_priv, unsigned long opcode, int ReplyType, int BusWidth, int BlockSize, unsigned int timeout_clks)
{

	*(((u32 *)sdio_priv)+MMCCMD) = ( opcode |
						   (1 << 13) |			/* There is data transfer */
						   (1 << 7 ) |			/* Push pull mode enable */
						   (MMC_RSP_R3 << 9) ); /* Response type is R5 */

	*(((u32 *)sdio_priv)+MMCTOD) = timeout_clks;

	return 0;
}
#if 0
 ret = sdiodrv_execute_cmd(SD_IO_SELECT_CARD,longval,MMC_RSP_R6,0, &reply,1,0,PCLI->timeout_clks);
        if(ret)return ret;
        PDEBUG("initialize CCCR\n");
        reply = 2;
        ret = sdiodrv_execute_cmd(SD_IO_RW_DIRECT, SDIO_CMD52_WRITE(1,FUNCTION_SELECT_0,0,CCCR_IO_ENABLE, reply)
                                                                        ,MMC_RSP_R3,0, &reply,1,0,PCLI->timeout_clks);

#endif
#define PCLI (opened_drivers[client_id])


int sdiodrv_read_sync(void *sdio_priv, void *DataBufferPointer, int sdio_address, int datalen)
{
    int ret;
	unsigned char reply;
    unsigned long status; 

    x_IFX_sdio_cmd_t cmd, sdCmd;

    PDEBUG("entering %s()\n" , __FUNCTION__ );

    memset(&cmd, 0, sizeof(cmd));
    
    cmd.args = SDIO_CMD53_READ(0, FUNCTION_SELECT_1, 0, 1, sdio_address, datalen);
    cmd.response[0] = 0;
    cmd.response_type = MMC_RSP_R3;
    cmd.op_code = SD_IO_RW_EXTENDED;

    ret = ifx_sdio_read_stream_data_fifo_mode(&cmd, DataBufferPointer, datalen, &status, 0);


/* 	u16 status; */
/* 	u32 i; */
/* 	int byteCnt; */
/* 	int end_transfer = 0; */
/* 	u32 ret = 0; */
/* 	int len =	(datalen==MAX_STREAM_SIZE_IN_BYTE_MODE ? 0 : datalen); */

/* 	/\* build the request *\/ */
/* 	CL_TRACE_START_L3(); */
/* 	PDEBUG("entering %s()\n" , __FUNCTION__ ); */

/* 	/\* clear status register *\/ */
/* 	status = mmcsdregs->mmcst0; */

/* 	/\* Write the timeout value to the MMC Data Read Time-Out Register (MMCTOD) *\/ */
/* 	mmcsdregs->mmctod = *(((u32 *)sdio_priv)+MMCTOD); */

/* 	/\* Set the transfer size in bytes and the number of blocks. right now we only use one block *\/ */
/* 	mmcsdregs->mmcnblk = 1;          /\* eq->blocks; *\/ */
/* 	mmcsdregs->mmcblen = datalen; */

/* 	/\* Configure the FIFO for read *\/ */
/* 	mmcsdregs->mmcfifoctl = mmcsdregs->mmcfifoctl | 0x1; */
/* 	mmcsdregs->mmcfifoctl = 0x0; */

/* 	if (RW_THRESHOLD == 32) */
/* 		mmcsdregs->mmcfifoctl = (1 << 2); */


/* 	mmcsdregs->mmcim = 0; */

/* 	/\*set Command timeout *\/ */
/* 	mmcsdregs->mmctor = reg_mmctor_val; */

/* 	/\* write the command and arguments to the hardware. This will start the request *\/ */
/* 	PWARNING("mmccmd = 0x%x, mmcarghl = 0x%x\n",(u32)(*(((u32 *)sdio_priv)+MMCCMD)), SDIO_CMD53_READ(0,FUNCTION_SELECT_1,0,1,(sdio_address),len)); */

/* 	mmcsdregs->mmcarghl = SDIO_CMD53_READ(0,FUNCTION_SELECT_1,0,1,(sdio_address),len); */

/* 	/\* Set command index *\/ */
/* 	mmcsdregs->mmccmd =  (u32)(*(((u32 *)sdio_priv)+MMCCMD)); */
/* 	CL_TRACE_END_L3("ssd.ko", "INHERIT", "SDIO_DRV_SYNC", ""); */

/* 	/\* Wait for end of read transfer *\/ */
/* 	while(!end_transfer) */
/* 	{ */
/* 		status = mmcsdregs->mmcst0; */
/* 		if (status & MMCSD_EVENT_READ) */
/* 		{ */
/* 			if (datalen > 0) */
/* 			{ */
/* 				if (datalen > RW_THRESHOLD) */
/* 					byteCnt = RW_THRESHOLD; */
/* 				else */
/* 					byteCnt = datalen; */
/* 				datalen -= byteCnt; */
/* 				for (i = 0; i < (byteCnt / 4); i++) */
/* 				{ */
/* 					*((unsigned long*)(DataBufferPointer)) = mmcsdregs->mmcdrr; */
/* 					DataBufferPointer+=4; */
/* 				} */
/* 			} */
/* 		} */
/* 		if (status & MMCSD_EVENT_BLOCK_XFERRED) */
/* 		{/\* Block sent/received *\/ */
/* 			while (datalen > 0) */
/* 			{ */
/* 						*((unsigned long*)(DataBufferPointer)) = mmcsdregs->mmcdrr; */
/* 						DataBufferPointer+=4; */
/* 						datalen-=4; */
/* 			} */
/* 			PDEBUG("changing end_transfer to 1\n"); */
/* 			end_transfer = TRUE; */
/* 		} */
/* 		if(status & MMCSD_EVENT_ERROR) */
/* 		{ */
/* 			ret = report_error(status); */
/* 			break; */
/* 		} */
/* 	} */


	PDEBUG("exiting %s\n",__FUNCTION__);
	return ret;
}

int sdiodrv_read_byte(unsigned char *data, int Address)
{
	int arg;
	int ret;
	x_IFX_sdio_cmd_t cmd = { 0 };

	PDEBUG("entering %s()" , __FUNCTION__ );

        arg = SDIO_CMD52_READ(0,FUNCTION_SELECT_1,0,Address);
	cmd.args = arg;
	cmd.response[0] = 0;
	cmd.response_type = MMC_RSP_R3;
	cmd.op_code = SD_IO_RW_DIRECT /* SD_CMD_IO_RW_REDIRECT */;
        ret = ifx_sdio_send_cmd(&cmd);
	*data = (cmd.response[0]) & 0xff;

/* 	u16 status; */
/* 	int end_command = 0; */
/* 	u32 ret = 0; */

/* 	/\* build the request *\/ */
/* 	PDEBUG("entering %s()" , __FUNCTION__ ); */

/* 	/\* clear status register *\/ */
/* 	status = mmcsdregs->mmcst0; */

/* 	/\* Set the transfer size in bytes and the number of blocks. right now we only use one block *\/ */
/* 	mmcsdregs->mmcnblk = 0;          /\* eq->blocks; *\/ */
/* 	mmcsdregs->mmcblen = 0; */

/* 	mmcsdregs->mmcim = 0; */

/* 	/\*set Command timeout *\/ */
/* 	mmcsdregs->mmctor = reg_mmctor_val; */

/* 	/\* write the command and arguments to the hardware. This will start the request *\/ */
/* 	mmcsdregs->mmcarghl = SDIO_CMD52_READ(0,FUNCTION_SELECT_1,0,(Address)); */

/* 	/\* Set command index *\/ */
/* 	mmcsdregs->mmccmd =  ( SD_IO_RW_DIRECT | */
/* 						   (1 << 7 ) |			/\* Push pull mode enable *\/ */
/* 						   (MMC_RSP_R3 << 9) ); /\* Response type is R5 *\/ */



/* 	/\* Wait for end of read transfer *\/ */
/* 	while(!end_command) */
/* 	{ */
/* 		status = mmcsdregs->mmcst0; */
/* 		if (status & MMCSD_EVENT_EOFCMD) */
/* 		{ */
/* 			PDEBUG("changing end_command to 1\n"); */
/* 			end_command = TRUE; */
/* 		} */
/* 		if(status & MMCSD_EVENT_ERROR) */
/* 		{ */
/* 			ret = report_error(status); */
/* 			break; */
/* 		} */
/* 	} */

/* 	/\* Read the data byte from the response registers *\/ */
/* 	*data = (unsigned char)(mmcsdregs->mmcrsp67); */

	PDEBUG("exiting %s\n",__FUNCTION__);
	return ret;
}

int sdiodrv_write_sync_prepare(void *sdio_priv, unsigned long opcode, int ReplyType, int BusWidth, int BlockSize, unsigned int timeout_clks)
{

	*(((u32 *)sdio_priv)+MMCCMD) = ( opcode |
							(1 << 13) |			/* There is data transfer */
							(1 << 11) |			/* Direction is write */
						    (1 << 7 ) |			/* Push pull mode enable */
						   (MMC_RSP_R3 << 9) ); /* Response type is R5 */

	*(((u32 *)sdio_priv)+MMCTOD) = timeout_clks;

	return 0;
}

int sdiodrv_write_sync(void *sdio_priv, void *DataBufferPointer, int sdio_address, int datalen)
{
    int ret;
    unsigned long status; 
    x_IFX_sdio_cmd_t cmd, sdCmd;

    PDEBUG("entering %s()\n" , __FUNCTION__ );


    memset(&cmd, 0, sizeof(cmd));
    
    cmd.args = SDIO_CMD53_WRITE(1, FUNCTION_SELECT_1, 0, 1, sdio_address, datalen);
    cmd.response[0] = 0;
    cmd.response_type = MMC_RSP_R3;
    cmd.op_code = SD_IO_RW_EXTENDED;
    
    ret = ifx_sdio_write_stream_data_fifo_mode(&cmd, DataBufferPointer, datalen, &status, 0);


/* 	u16 status; */
/* 	u32 i; */
/* 	int byteCnt; */
/* 	int end_transfer = 0; */
/* 	u32 ret = 0; */
/* 	int len =	(datalen==MAX_STREAM_SIZE_IN_BYTE_MODE ? 0 : datalen); */

/* 	/\* build the request *\/ */
/* 	CL_TRACE_START_L3(); */
/* 	PDEBUG("entering %s()\n" , __FUNCTION__ ); */

/* 	/\* clear status register *\/ */
/* 	status = mmcsdregs->mmcst0; */

/* 	/\* Write the timeout value to the MMC Data Read Time-Out Register (MMCTOD) *\/ */
/* 	mmcsdregs->mmctod = *(((u32 *)sdio_priv)+MMCTOD); */

/* 	/\* Set the transfer size in bytes and the number of blocks. right now we only use one block *\/ */
/* 	mmcsdregs->mmcnblk = 1;          /\* eq->blocks; *\/ */
/* 	mmcsdregs->mmcblen = datalen; */

/* 	/\*set Command timeout *\/ */
/* 	mmcsdregs->mmctor = reg_mmctor_val; */

/* 	/\* Configure the FIFO for write *\/ */
/* 	mmcsdregs->mmcfifoctl = mmcsdregs->mmcfifoctl | 0x1; */
/* 	mmcsdregs->mmcfifoctl = 0x0; */
/* 	mmcsdregs->mmcfifoctl = (1 << 1); */

/* 	if (RW_THRESHOLD == 32) */
/* 		mmcsdregs->mmcfifoctl |= (1 << 2); */


/* 	if (datalen < RW_THRESHOLD) */
/* 		byteCnt = datalen; */
/* 	else */
/* 		byteCnt = RW_THRESHOLD; */

/* 	/\* write the first bytes to transfer to the FIFO as we are not using the DMA*\/ */
/* 	for (i = 0; i < (byteCnt / 4); i++) */
/* 	{ */
/* 		mmcsdregs->mmcdxr = *((unsigned long*)(DataBufferPointer)); */
/* 		DataBufferPointer+=4; */
/* 	} */
/* 	datalen -= byteCnt; */

/* 	mmcsdregs->mmcim = 0; */

/* 	/\* write the command and arguments to the hardware. This will start the request *\/ */
/* 	PWARNING("mmccmd = 0x%x, mmcarghl = 0x%x\n", (u32)(*(((u32 *)sdio_priv)+MMCCMD)), SDIO_CMD53_WRITE(1,FUNCTION_SELECT_1,0,1,(sdio_address),len)); */

/* 	mmcsdregs->mmcarghl = SDIO_CMD53_WRITE(1,FUNCTION_SELECT_1,0,1,(sdio_address),len); */

/* 	/\* Set command index *\/ */
/* 	mmcsdregs->mmccmd =  (u32)(*(((u32 *)sdio_priv)+MMCCMD)); */
/* 	CL_TRACE_END_L3("ssd.ko", "INHERIT", "SDIO_DRV_SYNC", ".kick"); */


/* 	/\* Wait for end of write transfer *\/ */
/* 	while(!end_transfer) */
/* 	{ */
/* 		status = mmcsdregs->mmcst0; */
/* 		if (status & MMCSD_EVENT_WRITE){ */
/* 			if (datalen > 0)	{ */
/* 				if (datalen > RW_THRESHOLD) */
/* 					byteCnt = RW_THRESHOLD; */
/* 				else */
/* 					byteCnt = datalen; */
/* 				datalen -= byteCnt; */
/* 				for (i = 0; i < (byteCnt / 4); i++) { */
/* 					while(mmcsdregs->mmcst1 & 0x40); */
/* 					mmcsdregs->mmcdxr =	*((unsigned long*)(DataBufferPointer)); */
/* 					DataBufferPointer+=4; */
/* 				} */
/* 			} */
/* 		} */
/* 		if (status & MMCSD_EVENT_BLOCK_XFERRED) */
/* 		{/\* Block sent/received *\/ */
/* 			end_transfer = TRUE; */
/* 		} */
/* 		if(status & MMCSD_EVENT_ERROR) */
/* 		{ */
/* 			ret = report_error(status); */
/* 			break; */
/* 		} */
/* 	} */

	PDEBUG("exiting %s\n",__FUNCTION__);
	return ret;
}

int sdiodrv_write_byte(unsigned char data, int Address)
{
	int arg;
	int ret;
	x_IFX_sdio_cmd_t cmd = { 0 };

	PDEBUG("entering %s()\n" , __FUNCTION__ );

	arg = SDIO_CMD52_WRITE(1,FUNCTION_SELECT_1,0,Address,data);
	cmd.args = arg;
	cmd.response[0] = 0;
	cmd.response_type = MMC_RSP_R3;
	cmd.op_code = SD_IO_RW_DIRECT /* SD_CMD_IO_RW_REDIRECT */;
        ret = ifx_sdio_send_cmd(&cmd);

/* 	u16 status; */
/* 	int end_command = 0; */
/* 	u32 ret = 0; */

/* 	/\* build the request *\/ */
/* 	CL_TRACE_START_L3(); */
/* 	PDEBUG("entering %s()\n" , __FUNCTION__ ); */

/* 	/\* clear status register *\/ */
/* 	status = mmcsdregs->mmcst0; */

/* 	/\* Set the transfer size in bytes and the number of blocks. right now we only use one block *\/ */
/* 	mmcsdregs->mmcnblk = 0;          /\* eq->blocks; *\/ */
/* 	mmcsdregs->mmcblen = 0; */

/* 	/\*set Command timeout *\/ */
/* 	mmcsdregs->mmctor = reg_mmctor_val; */

/* 	mmcsdregs->mmcim = 0; */

        
/* 	/\* write the command and arguments to the hardware. This will start the request *\/ */
/* 	mmcsdregs->mmcarghl = SDIO_CMD52_WRITE(1,FUNCTION_SELECT_1,0,(Address),data); */

/* 	/\* Set command index *\/ */
/* 	mmcsdregs->mmccmd =  ( SD_IO_RW_DIRECT | */
/* 						   (1 << 7 ) |			/\* Push pull mode enable *\/ */
/* 						   (1 << 11) |			/\* Direction is write *\/ */
/* 						   (MMC_RSP_R3 << 9) ); /\* Response type is R5 *\/ */

/* 	CL_TRACE_END_L3("ssd.ko", "INHERIT", "SDIO_DRV_SYNC", ".kick"); */
/* 	/\* Wait for end of write transfer *\/ */
/* 	while(!end_command) */
/* 	{ */
/* 		status = mmcsdregs->mmcst0; */
/* 		if (status & MMCSD_EVENT_EOFCMD) */
/* 		{ */
/* 			PDEBUG("changing end_command to 1\n"); */
/* 			end_command = TRUE; */
/* 		} */
/* 		if(status & MMCSD_EVENT_ERROR) */
/* 		{ */
/* 			ret = report_error(status); */
/* 			break; */
/* 		} */
/* 	} */

	PDEBUG("exiting %s\n",__FUNCTION__);
	return ret;
}

int sdiodrv_read_async_prepare(void *sdio_priv,unsigned long opcode, int ReplyType,int BusWidth, int BlockSize, void(*BusTxnCB)(void* handle, int status), void* Handle, int Endless, int dma_mode, void* dma_params, unsigned int timeout_clks)
{

/* 	*(((u32 *)sdio_priv)+MMCCMD) = ( opcode | */
/* 							(1 << 13) |			/\* There is data transfer *\/ */
/* 							(1 << 16 )|			/\* generating DMA Xfer event *\/ */
/* 						    (1 << 7 ) |			/\* Push pull mode enable *\/ */
/* 						   (MMC_RSP_R3 << 9) ); /\* Response type is R5 *\/ */

/* 	*(((u32 *)sdio_priv)+MMCTOD) = timeout_clks; */
	*(((u32 *)sdio_priv)+CONTEXT) = (u32)(Handle);
	*(((u32 *)sdio_priv)+CALLBACK) = (u32)(BusTxnCB);

/* 	davinci_set_dma_src_params(DAVINCI_DMA_MMCRXEVT, SDIO_DATA_RECEIVE_REG, INCR, W8BIT); */
/* 	davinci_set_dma_dest_params(DAVINCI_DMA_MMCRXEVT, 0, INCR, W8BIT); */
/* 	davinci_set_dma_src_index(DAVINCI_DMA_MMCRXEVT, 0, 0); */
/* 	davinci_set_dma_dest_index(DAVINCI_DMA_MMCRXEVT, 4, RW_THRESHOLD); */
/* 	davinci_set_dma_transfer_params(DAVINCI_DMA_MMCRXEVT, 4, RW_THRESHOLD/4, 0, 0, ABsync); */
/* 	davinci_set_dma_src_params(RX_link_channel, SDIO_DATA_RECEIVE_REG, INCR, W8BIT); */
/* 	davinci_set_dma_dest_params(RX_link_channel, 0, INCR, W8BIT); */
/* 	davinci_set_dma_src_index(RX_link_channel, 0, 0); */
/* 	davinci_set_dma_dest_index(RX_link_channel, 1, 0); */
/* 	davinci_set_dma_transfer_params(RX_link_channel, 1, 0, 1, 1, ABsync); */
/* 	davinci_dma_link_lch(DAVINCI_DMA_MMCRXEVT, RX_link_channel); */

/* 	davinci_get_dma_params(DAVINCI_DMA_MMCRXEVT, &temp_rx1); */
/* 	davinci_get_dma_params(RX_link_channel, &temp_rx2); */

	return 0;
}

int sdiodrv_read_async(void *sdio_priv,void *DataBufferPointer, int sdio_address, int datalen)
{

#if 1
	x_IFX_sdio_cmd_t cmd, sdCmd;
	int ret, tmplen=datalen, offlen=0;
	unsigned char reply;
/*
	if(datalen %16 != 0)
	{
		tmplen = ((datalen/16)*16)+16;
        	offlen= 16-(datalen%16);
	}
*/

    PDEBUG("entering %s()\n" , __FUNCTION__ );

    g_request.direction = read;
    g_request.callback = (void *)*(((u32 *)sdio_priv)+CALLBACK);
    g_request.context = (void *)*(((u32 *)sdio_priv)+CONTEXT);


    memset(&cmd, 0, sizeof(cmd));
//    printk("%s():, tmplen:%d, offlen:%d\n" , __FUNCTION__ ,tmplen,offlen);
    
//    cmd.args = SDIO_CMD53_READ(0, FUNCTION_SELECT_1, 0, 1, sdio_address, datalen);
    cmd.args = SDIO_CMD53_READ(0, FUNCTION_SELECT_1, 0, 1, sdio_address, tmplen);
    cmd.response[0] = 0;
    cmd.response_type = MMC_RSP_R3;
    cmd.op_code = SD_IO_RW_EXTENDED;

    ret = ifx_sdio_read_stream_data_dma_mode (&cmd,  DataBufferPointer,datalen);

#endif

/* 	u16 status; */
/* 	/\* build the request *\/ */
/* 	u16 status; */
/* 	int len =	(datalen==MAX_STREAM_SIZE_IN_BYTE_MODE ? 0 : datalen); */

/* 	CL_TRACE_START_L4(); */
/* 	PDEBUG("entering %s()\n" , __FUNCTION__ ); */
/* 	//memset(g_request,0,sizeof(struct IO_request)); */
/* 	g_request.direction = read; */
/* 	g_request.callback = (void *)*(((u32 *)sdio_priv)+CALLBACK); */
/* 	g_request.context = (void *)*(((u32 *)sdio_priv)+CONTEXT); */

/* 	/\* clear status register *\/ */
/* 	status = mmcsdregs->mmcst0; */

/* 	/\* If dma is used, try to activate a DMA transfer *\/ */
/* 	sdio_davinci_start_dma_transfer(DataBufferPointer,datalen, read); */  

/* 	/\* Write the timeout value to the MMC Data Read Time-Out Register (MMCTOD) *\/ */
/* 	mmcsdregs->mmctod = *(((u32 *)sdio_priv)+MMCTOD); */

/* 	/\* Set the transfer size in bytes and the number of blocks. right now we only use one block *\/ */
/* 	mmcsdregs->mmcnblk = 1;          /\* eq->blocks; *\/ */
/* 	mmcsdregs->mmcblen = datalen; */

/* 	/\* Configure the FIFO for read *\/ */
/* 	mmcsdregs->mmcfifoctl = mmcsdregs->mmcfifoctl | 0x1; */
/* 	mmcsdregs->mmcfifoctl = 0x0; */

/* 	if (RW_THRESHOLD == 32) */
/* 		mmcsdregs->mmcfifoctl = (1 << 2); */

/* 	/\*set Command timeout *\/ */
/* 	mmcsdregs->mmctor = reg_mmctor_val; */

/* 	mmcsdregs->mmcim =  //(MMCSD_EVENT_EOFCMD | */
/* 						( MMCSD_EVENT_ERROR_CMDCRC | */
/* 						MMCSD_EVENT_ERROR_DATACRC | */
/* 						MMCSD_EVENT_ERROR_CMDTIMEOUT | */
/* 						MMCSD_EVENT_ERROR_DATATIMEOUT | */
/* 						MMCSD_EVENT_BLOCK_XFERRED); */

/* 	/\* write the command and arguments to the hardware. This will start the request *\/ */
/* 	PWARNING("mmccmd = 0x%8.8x, mmcarghl = 0x%x\n",*(((u32 *)sdio_priv)+MMCCMD), SDIO_CMD53_READ(0,FUNCTION_SELECT_1,0,1,(sdio_address),len)); */

/* 	mmcsdregs->mmcarghl = SDIO_CMD53_READ(0,FUNCTION_SELECT_1,0,1,(sdio_address),len); */

/* 	/\* Set command index *\/ */
/* 	mmcsdregs->mmccmd =  *(((u32 *)sdio_priv)+MMCCMD); */

/* 	PDEBUG("exiting %s\n",__FUNCTION__); */
/* 	CL_TRACE_END_L4("ssd.ko", "INHERIT", "SDIO_DRV_ASYNC", ""); */
	return 0;
}


int sdiodrv_write_async_prepare(void *sdio_priv,unsigned long opcode, int ReplyType,int BusWidth, int BlockSize, void(*BusTxnCB)(void* handle, int status), void* Handle, int Endless, int dma_mode, void* dma_params, unsigned int timeout_clks)
{

/* 	*(((u32 *)sdio_priv)+MMCCMD) = ( opcode | */
/* 							(1 << 13) |			/\* There is data transfer *\/ */
/* 							(1 << 16 )|			/\* generating DMA Xfer event *\/ */
/* 							(1 << 11) |			/\* Direction is write *\/ */
/* 						    (1 << 7 ) |			/\* Push pull mode enable *\/ */
/* 						   (MMC_RSP_R3 << 9) ); /\* Response type is R5 *\/ */

/* 	*(((u32 *)sdio_priv)+MMCTOD) = timeout_clks; */
	*(((u32 *)sdio_priv)+CONTEXT) = (u32)(Handle);
	*(((u32 *)sdio_priv)+CALLBACK) = (u32)(BusTxnCB);

/* 	davinci_set_dma_src_params(DAVINCI_DMA_MMCTXEVT, 0, INCR, W8BIT); */
/* 	davinci_set_dma_dest_params(DAVINCI_DMA_MMCTXEVT, SDIO_DATA_TRANSMIT_REG, INCR, W8BIT); */
/* 	davinci_set_dma_src_index(DAVINCI_DMA_MMCTXEVT, 4,RW_THRESHOLD); */
/* 	davinci_set_dma_dest_index(DAVINCI_DMA_MMCTXEVT, 0, 0); */
/* 	davinci_set_dma_transfer_params(DAVINCI_DMA_MMCTXEVT, 4, RW_THRESHOLD/4, 0, 4, ABsync); */
/* 	davinci_set_dma_src_params(TX_link_channel, 0, INCR, W8BIT); */
/* 	davinci_set_dma_dest_params(TX_link_channel, SDIO_DATA_TRANSMIT_REG, INCR, W8BIT); */
/* 	davinci_set_dma_src_index(TX_link_channel, 1, 0); */
/* 	davinci_set_dma_dest_index(TX_link_channel, 0, 0); */
/* 	davinci_set_dma_transfer_params(TX_link_channel, 1, 0, 1, 1, ABsync); */
/* 	davinci_dma_link_lch(DAVINCI_DMA_MMCTXEVT, TX_link_channel); */

/* 	davinci_get_dma_params(DAVINCI_DMA_MMCTXEVT, &temp_tx1); */
/* 	davinci_get_dma_params(TX_link_channel, &temp_tx2); */

	return 0;
}

int sdiodrv_write_async(void *sdio_priv,void *DataBufferPointer, int sdio_address, int datalen)
{

#if 1
    int ret;
    x_IFX_sdio_cmd_t cmd, sdCmd;

    PDEBUG("entering %s()\n" , __FUNCTION__ );

    g_request.direction = write;
    g_request.callback = (void *)*(((u32 *)sdio_priv)+CALLBACK);
    g_request.context = (void *)*(((u32 *)sdio_priv)+CONTEXT);

    memset(&cmd, 0, sizeof(cmd));
    
    cmd.args = SDIO_CMD53_WRITE(1, FUNCTION_SELECT_1, 0, 1, sdio_address, datalen);
    cmd.response[0] = 0;
    cmd.response_type = MMC_RSP_R3;
    cmd.op_code = SD_IO_RW_EXTENDED;
    
    ret = ifx_sdio_write_stream_data_dma_mode (&cmd,  DataBufferPointer,datalen);


#endif

/* 	int len =	(datalen==MAX_STREAM_SIZE_IN_BYTE_MODE ? 0 : datalen); */
/* 	u16 status; */

/* 	CL_TRACE_START_L4(); */

/* 	PDEBUG("entering %s()\n" , __FUNCTION__ ); */
/* 	//memset(g_request,0,sizeof(struct IO_request)); */
/* 	g_request.direction = write; */
/* 	g_request.callback = (void *)*(((u32 *)sdio_priv)+CALLBACK); */
/* 	g_request.context = (void *)*(((u32 *)sdio_priv)+CONTEXT); */


/* 	/\* clear status register *\/ */
/* 	status = mmcsdregs->mmcst0; */

/* 	/\* Write the timeout value to the MMC Data Read Time-Out Register (MMCTOD) *\/ */
/* 	mmcsdregs->mmctod = *(((u32 *)sdio_priv)+MMCTOD); */

/* 	/\* Set the transfer size in bytes and the number of blocks. right now we only use one block *\/ */
/* 	mmcsdregs->mmcnblk = 1;          /\* eq->blocks; *\/ */
/* 	mmcsdregs->mmcblen = datalen; */

/* 	/\* Configure the FIFO for read or write *\/ */
/* 	mmcsdregs->mmcfifoctl = mmcsdregs->mmcfifoctl | 0x1; */
/* 	mmcsdregs->mmcfifoctl = 0; */
/* 	mmcsdregs->mmcfifoctl = (1 << 1); */

/* 	if (RW_THRESHOLD == 32) */
/* 		mmcsdregs->mmcfifoctl |= (1 << 2); */

/* 	/\*set Command timeout *\/ */
/* 	mmcsdregs->mmctor = reg_mmctor_val; */

/* 	mmcsdregs->mmcim =  //(MMCSD_EVENT_EOFCMD | */
/* 						(MMCSD_EVENT_ERROR_CMDCRC | */
/* 						MMCSD_EVENT_ERROR_DATACRC | */
/* 						MMCSD_EVENT_ERROR_CMDTIMEOUT | */
/* 						MMCSD_EVENT_ERROR_DATATIMEOUT | */
/* 						MMCSD_EVENT_BLOCK_XFERRED); */

/* 	/\* write the command and arguments to the hardware. This will start the request *\/ */

/* 	/\* If dma is used, try to activate a DMA transfer *\/ */
/* 	sdio_davinci_start_dma_transfer(DataBufferPointer, datalen, write); */

/* 	PWARNING("mmccmd = 0x%8.8x, mmcarghl = 0x%x\n",*(((u32 *)sdio_priv)+MMCCMD), SDIO_CMD53_WRITE(1,FUNCTION_SELECT_1,0,1,(sdio_address),len)); */

/* 	mmcsdregs->mmcarghl = SDIO_CMD53_WRITE(1,FUNCTION_SELECT_1,0,1,(sdio_address),len); */

/* 	/\* Set command index *\/ */
/* 	mmcsdregs->mmccmd =  *(((u32 *)sdio_priv)+MMCCMD); */

	PDEBUG("exiting %s\n",__FUNCTION__);
/* 	CL_TRACE_END_L4("ssd.ko", "INHERIT", "SDIO_DRV_ASYNC", ""); */
	return 0;
}

#ifdef SDIO_IN_BAND_INTERRUPT
int sdiodrv_set_4bit(unsigned char fourbit)
{
	int ret = 0;

	mmcsdregs = (mmcsd_regs *) IO_ADDRESS(MMCSD_REGS_BASE_ADDR);

	//mmcsdregs->mmcctl = mmcsdregs->mmcctl | 0x1;	/*CMD line portion is diabled and in reset state */
	//mmcsdregs->mmcctl = mmcsdregs->mmcctl | (1 << 1);	/*DAT line portion is diabled and in reset state */

	/* Select 4 bits data bus */
	if(fourbit == TRUE)
	{
		PDEBUG("bus width = 4\n");
		mmcsdregs->mmcctl = mmcsdregs->mmcctl | 0x4;
	}
	else
	{
		PDEBUG("bus width = 1\n");
		mmcsdregs->mmcctl = mmcsdregs->mmcctl & ~(0x4);
	}
	//mmcsdregs->mmcctl = mmcsdregs->mmcctl & ~(0x1);
	//mmcsdregs->mmcctl = mmcsdregs->mmcctl & ~(1 << 1);

	return ret;
}
#endif /* SDIO_IN_BAND_INTERRUPT */
