#!/bin/sh
# Thu Mar 12 13:58:18 CST 2009
# 

# return the linkfile's autonym.
#
# input 
#	1. not NULL
#	2. is link.

TMPNAME=""

function autonym() {
	TMPNAME=""	
	echo "----> autonym: the linkname is: $1"
	if [ -z $1 ]; then
		echo "Error: dummy name is Null"
		return 1
	fi
	if [ ! -L $1 ]; then
		if [ -e $1 ]; then
			TMPNAME=$PWD"/"$1
			return 0
		else
			echo "Error: the dummy not found!"
			return 1
		fi
	else
		filename="$( ls -l $1 | awk '{print $NF}')"
		cd $(dirname $1)
		echo "====> autonym: change dir to: $PWD"
		autonym $filename
	fi
}

# scripts staring...
if [ -z $1 ]; then
	echo "input filename!"
	echo ""
	exit 1
fi

CURPWD=$PWD

while read line
do
	dummy="$(echo $line | awk '{print $1}')"
	if [ -z $dummy -o ! -L $dummy ] ; then
		echo "Error: source file error!"
		exit 1
	fi
	
	autonym $dummy > /dev/null
	cd $CURPWD
	if [ -z $TMPNAME ]; then
		echo "$line BAD" | tee > "$1.err"
	else
		rm -rf $dummy
		cp -af $TMPNAME $dummy
		echo "$TMPNAME ---> $dummy"
	fi

done < $1



