/*
 * PROM interface routines.
 */
//#include <linux/config.h>
#include <linux/init.h>
#include <linux/string.h>
#include <linux/ctype.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/bootmem.h>
#include <linux/ioport.h>
#include <linux/model.h>

#include <asm/bootinfo.h>
#include <asm/cpu.h>
#include <asm/amazon_se/amazon_se.h>
#include <asm/amazon_se/irq.h>
#include <asm/amazon_se/emulation.h>

extern char arcs_cmdline[CL_SIZE];
static char fake_cmdline[21] = "console=ttyS1,115200";
/* flag to indicate whether the user put mem= in the command line */
static int got_mem = 0;
#ifdef CONFIG_BLK_DEV_INITRD
extern unsigned long initrd_start, initrd_end;
#endif
#ifdef CONFIG_MTD_AMAZON_SE
extern unsigned long flash_start, flash_size;
#endif
u32* amazon_se_cp1_base = 0;

#if defined(CONFIG_ATM_BONDING_BM) || defined(CONFIG_USE_EMULATOR)
#define  USE_BUILTIN_PARAMETER
#else
#undef  USE_BUILTIN_PARAMETER
#endif

#undef USE_BUILTIN_PARAMETER

#ifdef USE_BUILTIN_PARAMETER
static char * amazon_se_arg[3] =
{ 
"<ignored>",
//"root=/dev/ram rw initcall_debug 1 ip=10.10.10.250:10.10.10.123::255.255.255.0::eth0:on ethaddr=00:E0:92:00:02:4A console=ttyS0,115200 mem=16M panic=1",
//"root=/dev/ram rw ip=172.20.9.90:172.20.9.88::255.255.255.0::eth0:on ethaddr=00:E0:92:00:02:4A console=ttyS0,115200 mem=16M panic=1",
"root=/dev/mtdblock2 ip=172.20.9.90:172.20.9.88::255.255.255.0::eth0:on ethaddr=00:E0:92:00:02:4A console=ttyS0,115200 mem=16M panic=1",
//"root=/dev/nfs rw nfsroot=10.10.10.123:/opt/root_filesystem ip=10.10.10.10:10.10.10.123::::eth0:on console=ttyS0,115200 ethaddr=00:e0:92:00:02:47 mem=16M panic=1",
NULL
};

static char * amazon_se_env[] =
{ 
"flash_start=0x13000000",
"flash_size=0x1000000",
"memsize=16 *1024 *1024",
NULL
};
#endif //USE_BUILTIN_PARAMETER

extern void prom_printf(const char * fmt, ...);

void __init prom_init(void)
{
	int argc; char **argv; char **envp;

	int i, len=0, left;
	unsigned long memsz;
#ifdef CONFIG_BLK_DEV_INITRD
	unsigned long rdstart, rdsize;
#endif
	char *dest = NULL, *scr;

//	mips_machgroup = MACH_GROUP_AMAZON_SE;
	
#ifdef USE_BUILTIN_PARAMETER
	argv = (char **)KSEG1ADDR((unsigned long)amazon_se_arg);
	envp = (char **)KSEG1ADDR((unsigned long)amazon_se_env);
	argc = 2; 
#else
	argc = (int)fw_arg0;
	argv = (char **)KSEG1ADDR((unsigned long)fw_arg1);
	envp = (char **)KSEG1ADDR((unsigned long)fw_arg2);
#endif

	/* Get the command line */
	if (argc>0) {
		left = CL_SIZE-1;
		dest = arcs_cmdline;
		/* BUG in u-boot, start at 1 */
		for (i = 1; i < argc; i++)
		{
			/* strlen does NOT include the terminating NUL */
			if (argv[i] == NULL) break;
			len = strlen(argv[i]);
			/*
			 * strncpy only copies up to and including the
			 * first NUL. end points to the next character
			 * after the NUL!
			 */
			strncpy(dest, argv[i], left);
			/* the user set mem= in the command line */
			if (strncmp(dest, "mem=", 4) == 0)
				got_mem = 1;
			left -= len + 1;
			/* NOTE: if the if hits then the last char is a NUL */
			if (left <= 0)
				break;
			/* no NULs in the cmdline please */
			dest[len] = ' ';
			dest += len + 1;
		}
		/* make sure the last char is a NUL */
		if (left > 0)
			dest[len] = '\0';
		if (i != argc)
			printk("promt_init: %s",
				"unable to copy the entire command line!\n");
	}
	else
	{
		/* provide a fake command line */
		strncpy(arcs_cmdline, fake_cmdline, 21);
		left = 0;
	}
	memsz = 0;
#ifdef CONFIG_BLK_DEV_INITRD
	rdstart = rdsize = 0;
#endif
	/* now handle envp */
	if (envp != (char **)KSEG1ADDR(0))
	{
		/* assume for now that exactly 3 values get passed */
		i = 0;
		while (envp[i] != NULL)
		{
			/* check for memsize */
			if (strncmp(envp[i], "memsize=", 8) == 0)
			{
				scr = envp[i] + 8;
				memsz = (int)simple_strtoul(scr, NULL, 0);
#undef DEBUG_PROM
#ifdef DEBUG_PROM
printk("memsize=%ul\n", memsz);
#endif
			}
#ifdef CONFIG_BLK_DEV_INITRD
			/* check for initrd_start */
			if (strncmp(envp[i], "initrd_start=", 13) == 0)
			{
				scr = envp[i] + 13;
				rdstart = (int)simple_strtoul(scr, NULL, 0);
				rdstart = KSEG1ADDR(rdstart);
#ifdef DEBUG_PROM
printk("initrd_start=%#x\n", rdstart);
#endif
			}
			/* check for initrd_size */
			if (strncmp(envp[i], "initrd_size=", 12) == 0)
			{
				scr = envp[i] + 12;
				rdsize = (int)simple_strtoul(scr, NULL, 0);
#ifdef DEBUG_PROM
printk("initrd_size=%ul\n", rdsize);
#endif
			}
#endif /* CONFIG_BLK_DEV_INITRD */

#ifdef CONFIG_MTD_AMAZON_SE
			/* check for flash address and size */
			if (strncmp(envp[i], "flash_start=", 12) == 0) {
				scr = envp[i] + 12;
				flash_start = simple_strtoul(scr, NULL, 0);
#ifdef DEBUG_PROM
printk("flash_start=%#x\n", flash_start);
#endif
			}
			if (strncmp(envp[i], "flash_size=", 11) == 0) {
				scr = envp[i] + 11;
				flash_size = simple_strtoul(scr, NULL, 0);
#ifdef DEBUG_PROM
printk("flash_size=%ul\n", flash_size);
#endif
			}
#endif	/* CONFIG_MTD_AMAZON_SE */
			i++;
		}
	}

	if (memsz)
	{
		if (got_mem == 0)
		{
			/* is there room for mem=XXXM ? */
			/* dest still points at the last char in cmdline */
			if (left > 8)
			{
				*dest++ = ' ';
				left--;
				strcat(dest, "mem=");
				dest += 4;
				left -= 4;
				i = snprintf(dest, left, "%d", (int)memsz);
				dest += i;
				/* memsize is always in megabytes - XXX */
				/* strcat adds the NUL at the end */
				strcat(dest, "M");
				got_mem = 1;

			}
		}
	}

#ifdef CONFIG_BLK_DEV_INITRD
	/* u-boot always passes a non-zero start, but a 0 size if there */
	/* is no ramdisk */
	if (rdstart != 0 && rdsize != 0)
	{
		initrd_start = rdstart;
		initrd_end = rdstart + rdsize;
	}
#endif
	/* Set the I/O base address */
	set_io_port_base(0);

	/* Set memory regions */
	ioport_resource.start = 0;		/* Should be KSEGx ???	*/
	ioport_resource.end = 0xffffffff;	/* Should be ???	*/

	/* 16MB starting at 0 */
	if (!got_mem)
		add_memory_region(0x00000000, 0x1000000, BOOT_MEM_RAM);
}

void prom_free_prom_memory(void)
{
}

const char *get_system_type(void)
{
	return MODEL_NAME; //BOARD_SYSTEM_TYPE;
}
