/* fpont 8/99 */

/* 
 * input : IP address of a interface on the same network
 * output : MAC address of this interface if found if arp_cache
 *
 * OS tested : linux 2.2.9
 */

#include <stdlib.h>
#include <stdio.h>
#include <net/if_arp.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
int getMAC(struct in_addr ip_addr,char *mac_addr,char *interface)
{
  struct sockaddr_in sin = { 0 };
  struct arpreq myarp = { { 0 } };
  int sockfd;
  unsigned char *ptr;
#if 1 
  struct timespec ts;

  ts.tv_sec=0;
  ts.tv_nsec=1;
  
  if(nanosleep(&ts,NULL)<0){
	  return -1;
  }
#endif	  
  sin.sin_family = AF_INET;
  sin.sin_addr=ip_addr;
  
  memcpy(&myarp.arp_pa, &sin, sizeof myarp.arp_pa);         
  strcpy(myarp.arp_dev, interface);
  
  if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
	 return -1;
  }
  
  if (ioctl(sockfd, SIOCGARP, &myarp) == -1) {
  	  close(sockfd); 
	  return -1;
  }
  
  close(sockfd);
  
  if(myarp.arp_flags==0)
	return -1;
  
 

  ptr = &myarp.arp_ha.sa_data[0];
  if(*ptr==*(ptr+1)==*(ptr+2)==*(ptr+3)==*(ptr+4)==*(ptr+5))
	  return -1;
  
  sprintf(mac_addr,"%02X:%02X:%02X:%02X:%02X:%02X",*ptr, *(ptr+1),*(ptr+2),
	 *(ptr+3),*(ptr+4),*(ptr+5));
  return 1;
}

int ClrMAC(struct in_addr ip_addr,char *interface)
{
  struct sockaddr_in sin = { 0 };
  struct arpreq myarp = { { 0 } };
  int sockfd;
#if 0 
  struct timespec ts;

  ts.tv_sec=0;
  ts.tv_nsec=1;
  
  if(nanosleep(&ts,NULL)<0){
	  return -1;
  }
#endif
  sin.sin_family = AF_INET;
  sin.sin_addr=ip_addr;
  
  memcpy(&myarp.arp_pa, &sin, sizeof myarp.arp_pa);         
  strcpy(myarp.arp_dev, interface);
  
  if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
	 return -1;
  }
  
  if (ioctl(sockfd, SIOCDARP, &myarp) == -1) {
//	  printf("%s\n",inet_ntoa(ip_addr));
//	  perror("ioctl");
  	  close(sockfd);  
	  return -1;
  }

  close(sockfd); 
  return 1;
}

