/*
 * Author: Paul.Russell@rustcorp.com.au and mneuling@radlogic.com.au
 *
 * Based on the ipchains code by Paul Russell and Michael Neuling
 *
 * (C) 2000-2002 by the netfilter coreteam <coreteam@netfilter.org>:
 * 		    Paul 'Rusty' Russell <rusty@rustcorp.com.au>
 * 		    Marc Boucher <marc+nf@mbsi.ca>
 * 		    James Morris <jmorris@intercode.com.au>
 * 		    Harald Welte <laforge@gnumonks.org>
 * 		    Jozsef Kadlecsik <kadlec@blackhole.kfki.hu>
 *
 *	iptables -- IP firewall administration for kernels with
 *	firewall table (aimed for the 2.3 kernels)
 *
 *	See the accompanying manual page iptables(8) for information
 *	about proper usage of this program.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <iptables.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>

#define DEBUG_FILE "/tmp/iptables_error_log"

int
main(int argc, char *argv[])
{
	int ret;
	char *table = "filter";
	iptc_handle_t handle = NULL;

	program_name = "iptables";
	program_version = IPTABLES_VERSION;

#ifdef NO_SHARED_LIBS
	init_extensions();
#endif

#if 0
	ret = do_command(argc, argv, &table, &handle);
	if (ret)
		ret = iptc_commit(&handle);
#else
	if(argv[1] && strcmp(argv[1],"-C")==0){
		FILE *fp=NULL;
		char buf[512]="";
		char *margv[128];
		int margc=0;
		pid_t pid;
		
		if(argv[2]==NULL){
			printf("%s -C rules\n",argv[0]);
			return -1;
		}
		unlink(DEBUG_FILE);
		
		fp=fopen(argv[2],"r");
		
		while(fgets(buf,512,fp)){
			char *sp1, *sp2;
			if(strlen(buf)<10)
				continue;
//			puts(buf);
			if(((sp1=strstr(buf, "\""))!=NULL)&&((sp2=strstr(sp1+1, "\""))!=NULL)) {
				*(sp1++)=' ';
				*(sp2--)=' ';

				while(sp1 && (sp1++<sp2)) {
					if((sp1=strstr(sp1, " "))!=NULL)
						*sp1='\1';
				}
			}
			margc=0;
			margv[margc++]=strtok(buf," ");
			while((margv[margc]=strtok(NULL," "))){
				int i=strlen(margv[margc]);
				if(strcmp(margv[margc], "\n")==0)
					continue;
				sp1=margv[margc];
				while((sp1=strstr(sp1, "\1"))!=NULL)
				{
					if(*(sp1+1) == 0)
						*(sp1++)=0;
					else
						*(sp1++)=' ';
				}
//				printf("Ron == %s\n",margv[margc]);
				
				if(margv[margc][i-1]=='\n')
					margv[margc][i-1]='\0';
//				printf("<%s>\n",margv[margc]);
//				msleep(1);
//				usleep(10000);
				margc++;
			};
			
			if(margv[0] && margv[0][0]=='#')
				continue;			
			
			margv[0]=argv[0];
			/* fork to process this command */
			if((pid=fork())<0){
				perror("fork");
				exit(1);
			}else if(pid==0){
				int times = 0;
				int i;
				FILE *fp_debug = fopen(DEBUG_FILE,"a+");

				if(fp_debug == NULL)
					fp_debug = stdout;
				for(i = 0; i < margc; i++)
						fprintf(fp_debug,"%s ", margv[i]);
				fprintf(fp_debug,"\n");
				while(++times <= 3)
				{
					ret = do_command(margc, margv, &table, &handle);
					if(ret)
						ret = iptc_commit(&handle);
					if(ret) /*sucess*/
						break;
					else
						fprintf(fp_debug,"ret=%d, table=%s, times=%d\n", ret, table, times);
					usleep(20000);
				}
				fprintf(fp_debug,"exec over\n");
				fclose(fp_debug);
				exit(!ret);
			}else{
				int status;
				waitpid(pid,&status,WUNTRACED);
			}		
		}
		fclose(fp);	
	}else{
		ret = do_command(argc, argv, &table, &handle);
		if (ret)
			ret = iptc_commit(&handle);
	}
#endif

	if (!ret)
		fprintf(stderr, "iptables: %s\n",
			iptc_strerror(errno));

	exit(!ret);
}
