#ifndef _LED_CONTROL_H_
#define _LED_CONTROL_H_

#define POWER_ON_LED      "power_green"
#define POWER_WARNING_LED  "power_red"
#define INTERNET_ON_LED   "internet_green"
#define INTERNET_ERROR_LED "internet_red"
#define DSL_LED          "dsl"
#define WLAN_LED       "wlan"
#define USB_LED        "usb"
#define WPS_LED        "wps"

#define SPEED_FAST_BLINK     5    /* 0.05 sec */
#define SPEED_SLOW_BLINK    15   /* 0.15 sec */

#define SPEC_NORMAL_BLINK "10"

void set_led_on(char *led_name);

void set_led_off(char *led_name);

void set_led_blink(char *led_name,int last_status,int times, int base_time, char *blink_spec);

void wps_led_in_progress(void);

void wps_led_in_overlap(void);

void wps_led_error(void);

void wps_led_success(void);

void wps_led_in_progress(void);/* for WPS PIN mode time out*/

void led_system_reset(void);

void led_system_restore(void);

void set_adsl_led_status(int adsl_status);

void fw_upgrade_led();

void fw_upgrade_failed();

void adsl_idle_led();

void adsl_train_led();

void adsl_up_led();

#endif
