#ifndef _LED_H_
#define _LED_H_

/************************************************************************/
/*                                                                      */
/*                           MARCO DEFINE                               */
/*                                                                      */
/************************************************************************/

#define LED_DATA_OFF         0
#define LED_DATA_ON          1

#define	LED_STR_ON  	"on"
#define LED_STR_OFF		"off"

#define	LED_PROC_NAME	"led"
#define   PUSH_BUTTON_NAME "push_button"
#define   LED_SPEC_LENGTH  128
/************************************************************************/
/*                                                                      */
/*                          STRUCT DEFINE                               */
/*                                                                      */
/************************************************************************/

struct led_blink_spec
{
    int blink_times;
    unsigned long base_time;        /* 0.01 sec */
    char blink_spec[128];
};

struct led_data_s 
{
    char *ledname;              /* name */
    unsigned long gpio_pin;     /* GPIO bit addr */
    int port_num;
    int state;                  /* current and init status */
    struct led_blink_spec led_blink;         /* choose blink spec */
    int count;                  /* alway=MAX no=0 n=blink */
    struct timer_list led_timer; 
};

#define BUTTON_PUSHED 1
#define BUTTON_RELEASE 0

struct button_data_s
{
	char *ledname;
	unsigned long gpio_pin;
	int port_num;
	int state;
};

#endif

