#include "ifx_config.h"
#include <sys/types.h>

#ifndef __IFX_COMMON_H
#define __IFX_COMMON_H
/* 000002:Nirav: from 2.1.22 package*/

#define BUF_SIZE_50K                    10240
#define BUF_SIZE_1K                     1024
#define MAX_DATA_LEN                    128 /* 64 */
#define MAX_FILELINE_LEN                256
#define MAX_FILENAME_LEN                256
#define MAX_TAG_LEN                     64
#define MAX_NAME_LEN                    96
#define NODE_AGE_TIME			4*60*60 /* 000001:Nirav4 hrs of Age Time in Secs */
#define	FALSE				0
#define TRUE				1
#define FILE_UPDATE_TMP                    "/tmp/update.tmp"
#define FILE_RC_CONF                    "/flash/rc.conf"

enum {
    ATM_QOS_UBR = 0,
    ATM_QOS_CBR,
    ATM_QOS_NRT_VBR,
    ATM_QOS_RT_VBR,
    ATM_QOS_UBR_PLUS,
};

/* 000001:Nirav start */
struct st_versionnode {
   pid_t  UI_pid;
   unsigned int config_version;
   long int timeval;
   struct st_versionnode *next;
};
/* 000001:Nirav end */

extern int ifx_run_command(char *command);

extern int ifx_create_pid_file(char *file_prefix);

extern int ifx_get_process_pid(char *file_prefix);

extern int ifx_rm_pid_file(char *file_prefix);

extern void ifx_rm_pid_file_atexit(void);

extern int ifx_validate_pid(pid_t pid, char *cmd_arg);

extern void ifx_web_convert_string(char *p);

extern char *ifx_GetCfgDatafromString(char *pString, char *pSymbol);

extern int ifx_GetCfgData(char *pFileName, char *pTag, char *pData, char *pRetValue);

extern int ifx_SetCfgData(const char* pFileName, const char* pTag, int nDataCount, const char* pData, ... );

extern int ifx_dhcp_renew(char * itf_name);

extern int ifx_dhcp_release(char * itf_name);

extern int ifx_flash_write(void);

extern char *ifx_get_atm_qos_name_by_id(int id);

extern int ifx_change_system_username_password(char *name, char *pasword);

extern char *ifx_strstr(const char *origin, const char *substr);

/* 000002:Nirav start */
extern int ifx_chkImage(char *name,char *errorMsg,char *img_type,int *iExapndDir);

extern int ifx_invokeUpgd(char *fName,char *img_type,int iExapndDir);

#if 0
int ifx_chkImageMem(char *buf);
#endif
/* 000002:Nirav end */
extern int ifx_makeCMV(unsigned char opcode, unsigned char group, unsigned short address, unsigned short index, int size, unsigned short * data, unsigned short *Message, int msg_len);
extern int adsl_get_rate(int type,unsigned long *rate,unsigned long *rate_remainder);
extern int ifx_flash_write_voip_config(void);

struct ifx_phyport_info {
	int link;
	int speed;
	int duplex;
};
extern int ifx_get_phyport_info(int num, struct ifx_phyport_info *buf);

void ADM6996_RWReg(int rwmode, int addr, int *value, int fd);
void ADM6996_RWSWReg(int rwmode, int addr, int *value, int fd);

#endif /* ] ! __IFX_COMMON_H */
