#!/bin/sh

CURRENT_TC_LAYER=0
cat /proc/modules|grep amazon_se_ppe
if [ "$?"  = "0" ]; then
	CURRENT_TC_LAYER=ATM
fi
cat /proc/modules|grep amazon_se_ptm
if [ "$?"  = "0" ]; then
	CURRENT_TC_LAYER=EFM
fi

# DSL Event handling script - Triggered from DSL CPE control Application
case "$DSL_NOTIFICATION_TYPE" in
	DSL_STATUS)
	if [ "$DSL_TC_LAYER_STATUS" = "ATM" ]; then
		if [ "$CURRENT_TC_LAYER" = "0" ]; then
			/sbin/insmod amazon_se_ppe.o
		fi
		if [ "$CURRENT_TC_LAYER" = "EFM" ]; then
			/sbin/rmmod amazon_se_ptm
			/sbin/insmod amazon_se_ppe.o
		fi
	elif [ "$DSL_TC_LAYER_STATUS" = "EFM" ]; then
		if [ "$CURRENT_TC_LAYER" = "0" ]; then
			/sbin/insmod amazon_se_ptm.o
		fi
		if [ "$CURRENT_TC_LAYER" = "ATM" ]; then
			/sbin/rmmod amazon_se_ppe
			/sbin/insmod amazon_se_ptm.o
		fi
	fi
	;;

	DSL_DATARATE_STATUS_DS)
	echo "down load speed " > /dev/console
	echo $DSL_DATARATE_DS_BC0 > /dev/console
	if [ $DSL_DATARATE_DS_BC0 != 0 ]; then
		echo $DSL_DATARATE_DS_BC0 > /tmp/adsl/downstream
	fi
	;;
	
		DSL_DATARATE_STATUS_US)
	echo "up load speed " > /dev/console
	echo $DSL_DATARATE_US_BC0 > /dev/console
	if [ $DSL_DATARATE_US_BC0 != 0 ]; then
		echo $DSL_DATARATE_US_BC0 > /tmp/adsl/upstream
	fi
	;;

	DSL_INTERFACE_STATUS)
	case "$DSL_INTERFACE_STATUS" in 
		"UP")
		echo "ADSL: Showtime" > /dev/console
		echo "Showtime" > /tmp/adsl/state
		echo "Entered SHOWTIME!!"
		/sbin/cp /proc/uptime /tmp/adsl/line_uptime
		echo $DSL_DATARATE_US_BC0 > /tmp/adsl/upstream
		echo $DSL_DATARATE_DS_BC0 > /tmp/adsl/downstream
		echo "dsl(on,0,0,0)" > /proc/led
                echo 7 > /tmp/adsl_status

		if [ -e /tmp/start ]; then
				/usr/sbin/rc wan restart &	
		else
				echo "" > /tmp/start
				echo "start" > /dev/console
				/usr/sbin/rc wan start &		
		fi	
		;;

		"DOWN")
		echo "ADSL: Idle" > /dev/console
		/usr/sbin/rc wan stop
		echo "Idle" > /tmp/adsl/state
		echo "DSL IDLE!!"
    rm -rf  /tmp/adsl_status

		sleep 2
		rm /tmp/wan_updatime1
		rm /tmp/adsl/line_uptime
		rm /tmp/wan_ipaddr1
		;;
		
		"DSL_DATARATE_STATUS")
		echo "Handshaking" > /tmp/adsl/state
		echo "Handshaking..."> /dev/console
		echo "dsl(on,-1,25,10)" > /proc/led
		echo $DSL_DATARATE_US_BC0 > /tmp/adsl/upstream
		echo $DSL_DATARATE_DS_BC0 > /tmp/adsl/downstream
		;;
		
		"DETECT_IDLE")
		echo "dsl(off,0,0,0)" > /proc/led
		;;
		
		"DETECT_CO")
		echo "dsl(off,0,0,0)" > /proc/led
		;;
		
		"FULL_INIT")
		echo "dsl(on,-1,12,10)" > /proc/led
		;;

	esac
	;;

	DSL_DATARATE_STATUS)
		echo $DSL_DATARATE_US_BC0 > /tmp/adsl/upstream
		echo $DSL_DATARATE_DS_BC0 > /tmp/adsl/downstream
		echo "Handshaking" > /tmp/adsl/state
		echo "Handshaking..."
	;;
esac

