#ifndef __IFX_PPA_API_DIRECTPATH_H__20081119_1144__
#define __IFX_PPA_API_DIRECTPATH_H__20081119_1144__



/*******************************************************************************
**
** FILE NAME    : ifx_ppa_api_directpath.h
** PROJECT      : PPA
** MODULES      : PPA API (Routing/Bridging Acceleration APIs)
**
** DATE         : 19 NOV 2008
** AUTHOR       : Xu Liang
** DESCRIPTION  : PPA Protocol Stack Hook API Directpath Functions Header
**                File
** COPYRIGHT    :   Copyright (c) 2006
**          Infineon Technologies AG
**          Am Campeon 1-12, 85579 Neubiberg, Germany
**
**   Any use of this software is subject to the conclusion of a respective
**   License agreement. Without such a License agreement no rights to the
**   software are granted
**
** HISTORY
** $Date        $Author         $Comment
** 19 NOV 2008  Xu Liang        Initiate Version
*******************************************************************************/



/*
 * ####################################
 *              Definition
 * ####################################
 */

/*
 *  Directpath API Flags
 */
#define PPA_F_DIRECTPATH_REGISTER               0x00100000
#define PPA_F_DIRECTPATH_CORE1                  0x00200000
#define PPA_F_DIRECTPATH_ETH_IF                 0x00400000

/*
 *  Directpath Internal Flags
 */
#define PPE_DIRECTPATH_DATA_ENTRY_VALID         (1 << 31)
#define PPE_DIRECTPATH_DATA_RX_ENABLE           (1 << 0)
#define PPE_DIRECTPATH_ETH                      (1 << 4)
#define PPE_DIRECTPATH_CORE0                    (1 << 8)
#define PPE_DIRECTPATH_CORE1                    (1 << 9)
#define PPE_DIRECTPATH_ITF_TYPE_MASK            (PPE_DIRECTPATH_ETH)
#define PPE_DIRECTPATH_CORE_MASK                (PPE_DIRECTPATH_CORE0 | PPE_DIRECTPATH_CORE1)
#define PPE_DIRECTPATH_MASK                     (PPE_DIRECTPATH_ITF_TYPE_MASK | PPE_DIRECTPATH_CORE_MASK)



/*
 * ####################################
 *              Data Type
 * ####################################
 */

typedef int32_t (*PPA_FP_STOP_TX_FN)(struct net_device *dev);

typedef int32_t (*PPA_FP_RESTART_TX_FN)(struct net_device *dev);

typedef int32_t (*PPA_FP_RX_FN)(struct net_device *rxif, struct net_device *txif, struct sk_buff *skb, int32_t len);

typedef struct {
    PPA_FP_STOP_TX_FN       stop_tx_fn;
    PPA_FP_RESTART_TX_FN    start_tx_fn;
    PPA_FP_RX_FN            rx_fn;
} PPA_DIRECTPATH_CB;

/*
 *  Internal Structure of directpath
 */

//struct ppe_directpath_callback {
//    int32_t (*ppa_fp_rx_fn)(struct net_device *rxif, struct net_device *txif, struct sk_buff *skb, int32_t len);
//    int32_t (*ppa_fp_stop_tx_fn)(struct net_device *dev);
//    int32_t (*ppa_fp_restart_tx_fn)(struct net_device *dev);
//};

struct ppe_directpath_data {
    PPA_DIRECTPATH_CB               callback;
    struct net_device              *netif;
    uint32_t                        ifid;
    uint8_t                         mac[(PPA_ETH_ALEN + sizeof(uint32_t) - 1) / sizeof(uint32_t) * sizeof(uint32_t)];
    struct sk_buff                 *skb_list;
    uint32_t                        skb_list_len;
    uint32_t                        skb_list_size;
    uint32_t                        rx_fn_rxif_pkt;
    uint32_t                        rx_fn_txif_pkt;
    uint32_t                        tx_pkt;
    uint32_t                        tx_pkt_dropped;
    uint32_t                        tx_pkt_queued;
    uint32_t                        flags;  //  bit 0 - directpath send valid, 31 - entry valid
};



/*
 * ####################################
 *             Declaration
 * ####################################
 */

extern struct ppe_directpath_data g_ppe_directpath_data[];

#ifdef CONFIG_IFX_PPA_API_DIRECTPATH
  int32_t ifx_ppa_directpath_register_dev(uint32_t *, struct net_device *, PPA_DIRECTPATH_CB *, uint32_t);
  int32_t ifx_ppa_directpath_send(uint32_t, struct sk_buff *, int32_t, uint32_t);
  int32_t ifx_ppa_directpath_rx_stop(uint32_t, uint32_t);
  int32_t ifx_ppa_directpath_rx_restart(uint32_t, uint32_t);
  struct net_device *ifx_ppa_get_netif_for_ppa_ifid(uint32_t);
  int32_t ifx_ppa_get_ifid_for_netif(struct net_device *);

  int32_t ppa_directpath_data_start_iteration(uint32_t *, struct ppe_directpath_data **);
  int32_t ppa_directpath_data_iterate_next(uint32_t *, struct ppe_directpath_data **);
  void ppa_directpath_data_stop_iteration(void);
  void ppa_directpath_get_ifid_range(uint32_t *, uint32_t *);
#endif



#endif  //  __IFX_PPA_API_DIRECTPATH_H__20081119_1144__
