#ifndef __IFX_PPA_API_H__20081031_1913__
#define __IFX_PPA_API_H__20081031_1913__



/*******************************************************************************
**
** FILE NAME    : ifx_ppa_api.h
** PROJECT      : PPA
** MODULES      : PPA API (Routing/Bridging Acceleration APIs)
**
** DATE         : 31 OCT 2008
** AUTHOR       : Xu Liang
** DESCRIPTION  : PPA Protocol Stack Hook API Header File
** COPYRIGHT    :   Copyright (c) 2006
**          Infineon Technologies AG
**          Am Campeon 1-12, 85579 Neubiberg, Germany
**
**   Any use of this software is subject to the conclusion of a respective
**   License agreement. Without such a License agreement no rights to the
**   software are granted
**
** HISTORY
** $Date        $Author         $Comment
** 31 OCT 2008  Xu Liang        Initiate Version
*******************************************************************************/



#include <net/ifx_ppa_stack_al.h>
#ifdef __KERNEL__
  #include <net/ifx_ppa_api_directpath.h>
#endif



/*
 * ####################################
 *              Definition
 * ####################################
 */

#define PPA_MAX_IFS_NUM                         10
#define PPA_MAX_MC_IFS_NUM                      8
#define PPA_MAX_VLAN_FILTER                     32

/*
 *  ioctl Command
 */
#define PPA_IOC_MAGIC                           ((uint32_t)'p')
#define PPA_CMD_INIT                            _IOW(PPA_IOC_MAGIC, 0, PPA_CMD_INIT_INFO)
#define PPA_CMD_EXIT                            _IO(PPA_IOC_MAGIC, 1)
#define PPA_CMD_ENABLE                          _IOW(PPA_IOC_MAGIC, 2, PPA_CMD_ENABLE_INFO)
#define PPA_CMD_GET_STATUS                      _IOWR(PPA_IOC_MAGIC, 3, PPA_CMD_ENABLE_INFO)
#define PPA_CMD_MODIFY_MC_ENTRY                 _IOW(PPA_IOC_MAGIC, 4, PPA_CMD_MC_ENTRY)
#define PPA_CMD_GET_MC_ENTRY                    _IOWR(PPA_IOC_MAGIC, 5, PPA_CMD_MC_ENTRY)
#define PPA_CMD_ADD_MAC_ENTRY                   _IOW(PPA_IOC_MAGIC, 6, PPA_CMD_MAC_ENTRY)
#define PPA_CMD_DEL_MAC_ENTRY                   _IOW(PPA_IOC_MAGIC, 7, PPA_CMD_MAC_ENTRY)
#define PPA_CMD_SET_VLAN_IF_CFG                 _IOW(PPA_IOC_MAGIC, 8, PPA_CMD_BR_IF_VLAN_CONFIG)
#define PPA_CMD_GET_VLAN_IF_CFG                 _IOWR(PPA_IOC_MAGIC, 9, PPA_CMD_BR_IF_VLAN_CONFIG)
#define PPA_CMD_ADD_VLAN_FILTER_CFG             _IOW(PPA_IOC_MAGIC, 10, PPA_CMD_VLAN_FILTER_CONFIG)
#define PPA_CMD_DEL_VLAN_FILTER_CFG             _IOW(PPA_IOC_MAGIC, 11, PPA_CMD_VLAN_FILTER_CONFIG)
#define PPA_CMD_GET_ALL_VLAN_FILTER_CFG         _IOR(PPA_IOC_MAGIC, 12, PPA_CMD_VLAN_ALL_FILTER_CONFIG)
#define PPA_CMD_DEL_ALL_VLAN_FILTER_CFG         _IO(PPA_IOC_MAGIC, 13)
//#define PPA_CMD_SET_BR_VLAN_PRIO                _IOW(PPA_IOC_MAGIC, 10, PPA_IOCTL_BR_VLAN_PRIO)
#define PPA_CMD_SET_IF_MAC                      _IOW(PPA_IOC_MAGIC, 14, PPA_CMD_IF_MAC_INFO)
#define PPA_CMD_GET_IF_MAC                      _IOWR(PPA_IOC_MAGIC, 15, PPA_CMD_IF_MAC_INFO)
#define PPA_CMD_ADD_LAN_IF                      _IOW(PPA_IOC_MAGIC, 16, PPA_CMD_IFINFO)
#define PPA_CMD_ADD_WAN_IF                      _IOW(PPA_IOC_MAGIC, 17, PPA_CMD_IFINFO)
#define PPA_CMD_DEL_LAN_IF                      _IOW(PPA_IOC_MAGIC, 18, PPA_CMD_IFINFO)
#define PPA_CMD_DEL_WAN_IF                      _IOW(PPA_IOC_MAGIC, 19, PPA_CMD_IFINFO)
#define PPA_CMD_GET_LAN_IF                      _IOR(PPA_IOC_MAGIC, 20, PPA_CMD_IFINFOS)
#define PPA_CMD_GET_WAN_IF                      _IOR(PPA_IOC_MAGIC, 21, PPA_CMD_IFINFOS)
#define PPA_IOC_MAXNR                           22

/*
 *  return value
 */
#define IFX_SUCCESS                             0
#define IFX_FAILURE                             -1
#define IFX_EPERM                               -2  //  not permitted
#define IFX_EIO                                 -5  //  I/O/Hardware/Firmware error
#define IFX_EAGAIN                              -11 //  try again later
#define IFX_ENOMEM                              -12 //  out of memory
#define IFX_EACCESS                             IFX_EPERM
#define IFX_EFAULT                              -14 //  bad address
#define IFX_EBUSY                               -16 //  busy
#define IFX_EINVAL                              -22 //  invalid argument
#define IFX_ENOTAVAIL                           -97
#define IFX_ENOTPOSSIBLE                        -98
#define IFX_ENOTIMPL                            -99 //  not implemented

/*
 *  PPA enable/disable flag
 */
#define IFX_ENABLED                             1
#define IFX_DISABLED                            0

/*
 *  flags
 */
#define PPA_F_BEFORE_NAT_TRANSFORM              0x00000001
#define PPA_F_SESSION_ORG_DIR                   0x00000010
#define PPA_F_SESSION_REPLY_DIR                 0x00000020
#define PPA_F_SESSION_BIDIRECTIONAL             (PPA_F_SESSION_ORG_DIR | PPA_F_SESSION_REPLY_DIR)
#define PPA_F_BRIDGED_SESSION                   0x00000100
#define PPA_F_SESSION_NEW_DSCP                  0x00001000
#define PPA_F_SESSION_VLAN                      0x00002000
#define PPA_F_MTU                               0x00004000
#define PPA_F_SESSION_OUT_VLAN                  0x00008000
#define PPA_F_BRIDGE_LOCAL                      0x00010000
//#define PPA_F_DIRECTPATH_REGISTER               0x00100000    //  put in file "ifx_ppa_api_directpath.h"
//#define PPA_F_DIRECTPATH_CORE1                  0x00200000    //  put in file "ifx_ppa_api_directpath.h"
//#define PPA_F_DIRECTPATH_ETH_IF                 0x00400000    //  put in file "ifx_ppa_api_directpath.h"
#define PPA_F_LAN_IF                            0x01000000
#define PPA_F_STATIC_ENTRY                      0x20000000
#define PPA_F_DROP_PACKET                       0x40000000
#define PPA_F_BRIDGE_ACCEL_MODE                 0x80000000

/*
 *  interface flags
 */
//#define PPA_F_IF_ALLOW_BROADCAST_MULTICAST      0x00000001

/*
 *  ifx_ppa_session_add return value
 */
#define IFX_PPA_SESSION_NOT_ADDED               -1
#define IFX_PPA_SESSION_ADDED                   0
#define IFX_PPA_SESSION_EXISTS                  1

/*
 *  ifx_ppa_inactivity_status return value
 */
//#define IFX_PPA_SESSION_NOT_ADDED               -1
#define IFX_PPA_HIT                             0
#define IFX_PPA_TIMEOUT                         1

/*
 *  bridging VLAN criteria type
 */
#define PPA_F_VLAN_FILTER_IFNAME                0
#define PPA_F_VLAN_FILTER_IP_SRC                1
#define PPA_F_VLAN_FILTER_ETH_PROTO             2
#define PPA_F_VLAN_FILTER_VLAN_TAG              3



/*
 * ####################################
 *              Data Type
 * ####################################
 */

/*
 *  API structures
 */

typedef struct {
    PPA_IFNAME *ifname;
    uint32_t    if_flags;
} PPA_IFINFO;

typedef struct ppa_verify_checks {
    uint32_t    f_ip_verify             :1; //  Enable/Disable IP verification checks
    uint32_t    f_tcp_udp_verify        :1; //  Enable/Disable TCP/UDP verification checks
    uint32_t    f_tcp_udp_err_drop      :1; //  Enable/Disable drop packet if TCP/UDP checksum is wrong
    uint32_t    f_drop_on_no_hit        :1; //  Drop unicast packets on no hit, forward to MIPS CPU otherwise (default)
    uint32_t    f_mc_drop_on_no_hit     :1; //  Drop multicast on no hit, forward to MIPS CPU otherwise (default)
} PPA_VERIFY_CHECKS;

typedef struct {
    PPA_VERIFY_CHECKS   lan_rx_checks;      // LAN Ingress checks
    PPA_VERIFY_CHECKS   wan_rx_checks;      // WAN Ingress checks
    uint32_t    num_lanifs;                 //  Number of LAN side interfaces
    PPA_IFINFO *p_lanifs;
    uint32_t    num_wanifs;                 //  Number of WAN side interfaces
    PPA_IFINFO *p_wanifs;
    uint32_t    max_lan_source_entries;     //  Number of session entries with LAN source
    uint32_t    max_wan_source_entries;     //  Number of session entries with WAN source
    uint32_t    max_mc_entries;             //  Number of multicast sessions
    uint32_t    max_bridging_entries;       //  Number of bridging entries
    uint32_t    add_requires_min_hits;      //  Minimum number of calls to ppa_add before session would be added in h/w
} PPA_INIT_INFO;

typedef struct {
    uint32_t    new_dscp            :6;
    uint32_t    dscp_remark         :1;
    uint32_t    vlan_insert         :1;
    uint32_t    vlan_remove         :1;
    uint32_t    out_vlan_insert     :1;     //  valid in A4/D5/A5
    uint32_t    out_vlan_remove     :1;     //  valid in A4/D5/A5
    uint32_t    reserved1           :5;
    uint32_t    vlan_prio           :3;
    uint32_t    vlan_cfi            :1;
    uint32_t    vlan_id             :12;
    uint16_t    mtu;
    uint32_t    session_flags;
    uint32_t    out_vlan_tag;               //  valid in A4/D5/A5
} PPA_SESSION_EXTRA;

typedef struct {
    PPA_IFNAME *ifname;
    uint8_t     ttl;
} IF_TTL_ENTRY;

typedef struct {
    IPADDR          ip_mc_group;
    int8_t          num_ifs;
    IF_TTL_ENTRY    array_mem_ifs[PPA_MAX_MC_IFS_NUM];
    uint8_t         if_mask;
    PPA_IFNAME     *src_ifname;
    uint32_t        vlan_insert     :1;     //  valid in A4/A5
    uint32_t        vlan_remove     :1;     //  valid in A4/A5
    uint32_t        out_vlan_insert :1;     //  valid in A4/A5
    uint32_t        out_vlan_remove :1;     //  valid in A4/A5
    uint32_t        reserved1       :4;     //  valid in A4/A5
    uint32_t        vlan_prio       :3;     //  valid in A4/A5
    uint32_t        vlan_cfi        :1;     //  valid in A4/A5
    uint32_t        vlan_id         :12;    //  valid in A4/A5
    uint32_t        out_vlan_tag;           //  valid in A4/A5
    uint32_t        new_dscp_en     :1;     //  valid in A4/A5
    uint32_t        res             :15;
    uint32_t        new_dscp        :16;    //  valid in A4/A5
} PPA_MC_GROUP;

typedef void PPA_U_SESSION;

typedef struct {
    uint32_t    tx_pkts;
    uint32_t    rx_pkts;
    uint32_t    tx_discard_pkts;
    uint32_t    tx_error_pkts;
    uint32_t    rx_discard_pkts;
    uint32_t    rx_error_pkts;
    uint32_t    tx_bytes;
    uint32_t    rx_bytes;
} PPA_IF_STATS;

typedef struct {
    uint32_t    fast_routed_tcp_pkts;
    uint32_t    fast_routed_udp_pkts;
    uint32_t    fast_routed_udp_mcast_pkts;
    uint32_t    fast_drop_pkts;
    uint32_t    fast_drop_bytes;
    uint32_t    fast_ingress_cpu_pkts;
    uint32_t    fast_ingress_cpu_bytes;
    uint32_t    rx_pkt_errors;
    uint32_t    fast_bridged_ucast_pkts;
    uint32_t    fast_bridged_mcast_pkts;
    uint32_t    fast_bridged_bcast_pkts;
    uint32_t    fast_bridged_bytes;
} PPA_ACCEL_STATS;

typedef struct {
    uint32_t        unmodified      :1;
    uint32_t        insertion       :1;
    uint32_t        remove          :1;
    uint32_t        replace         :1;
    uint32_t        out_unmodified  :1;
    uint32_t        out_insertion   :1;
    uint32_t        out_remove      :1;
    uint32_t        out_replace     :1;
} PPA_VLAN_TAG_CTRL;

typedef struct {
    uint32_t        src_ip_based_vlan   :1;
    uint32_t        eth_type_based_vlan :1;
    uint32_t        vlanid_based_vlan   :1;
    uint32_t        port_based_vlan     :1;
    uint32_t        vlan_aware          :1;
    uint32_t        out_vlan_aware      :1;
} PPA_VLAN_CFG;

typedef struct {
    union {
        PPA_IFNAME     *ifname;
        IPADDR          ip_src;
        //  to prevent big endian issue
        //uint16_t        eth_protocol;
        //uint16_t        ingress_vlan_tag;
        uint32_t        eth_protocol;
        uint32_t        ingress_vlan_tag;
    }               match_field;
    uint32_t        match_flags;
} PPA_VLAN_MATCH_FIELD;

typedef struct {
    uint16_t        vlan_vci;
    uint16_t        num_ifs;
    PPA_IFINFO     *vlan_if_membership;
} PPA_VLAN_INFO;

typedef struct {
    PPA_VLAN_MATCH_FIELD    match_field;
    PPA_VLAN_INFO           vlan_info;
} PPA_VLAN_FILTER_CONFIG;

/*
 *  ioctl command structures
 */

typedef struct {
    PPA_IFNAME  ifname[PPA_IF_NAME_SIZE];
    uint32_t    if_flags;
} PPA_CMD_IFINFO;

typedef struct {
    PPA_VERIFY_CHECKS   lan_rx_checks;          // LAN Ingress checks
    PPA_VERIFY_CHECKS   wan_rx_checks;          // WAN Ingress checks
    uint32_t        num_lanifs;                 //  Number of LAN side interfaces
    PPA_CMD_IFINFO  p_lanifs[PPA_MAX_IFS_NUM];
    uint32_t        num_wanifs;                 //  Number of WAN side interfaces
    PPA_CMD_IFINFO  p_wanifs[PPA_MAX_IFS_NUM];
    uint32_t        max_lan_source_entries;     //  Number of session entries with LAN source
    uint32_t        max_wan_source_entries;     //  Number of session entries with WAN source
    uint32_t        max_mc_entries;             //  Number of multicast sessions
    uint32_t        max_bridging_entries;       //  Number of bridging entries
    uint32_t        add_requires_min_hits;      //  Minimum number of calls to ppa_add before session would be added in h/w
    uint32_t        flags;
} PPA_CMD_INIT_INFO;

typedef struct {
    uint32_t        lan_rx_ppa_enable;
    uint32_t        wan_rx_ppa_enable;
    uint32_t        flags;
} PPA_CMD_ENABLE_INFO;

typedef struct {
    IPADDR              mcast_addr;
    PPA_SESSION_EXTRA   mc_extra;
    uint32_t            flags;
} PPA_CMD_MC_ENTRY;

typedef struct {
    uint8_t         mac_addr[PPA_ETH_ALEN];
    PPA_IFNAME      ifname[PPA_IF_NAME_SIZE];
    uint32_t        flags;
} PPA_CMD_MAC_ENTRY;

typedef struct
{
    PPA_IFNAME          if_name[PPA_IF_NAME_SIZE];
    PPA_VLAN_TAG_CTRL   vlan_tag_ctrl;
    PPA_VLAN_CFG        vlan_cfg;
    uint32_t            flags;
} PPA_CMD_BR_IF_VLAN_CONFIG;

typedef struct {
    union {
        PPA_IFNAME      ifname[PPA_IF_NAME_SIZE];
        IPADDR          ip_src;
        uint32_t        eth_protocol;
        uint32_t        ingress_vlan_tag;
    }               match_field;
    uint32_t        match_flags;
} PPA_CMD_VLAN_MATCH_FIELD;

typedef struct {
    uint16_t        vlan_vci;
    uint16_t        num_ifs;
    PPA_CMD_IFINFO  vlan_if_membership[PPA_MAX_IFS_NUM];
} PPA_CMD_VLAN_INFO;

typedef struct {
    PPA_CMD_VLAN_MATCH_FIELD    match_field;
    PPA_CMD_VLAN_INFO           vlan_info;
} _PPA_CMD_VLAN_FILTER_CONFIG;

typedef struct {
    _PPA_CMD_VLAN_FILTER_CONFIG vlan_filter_cfg;
    uint32_t                    flags;
} PPA_CMD_VLAN_FILTER_CONFIG;

typedef struct {
    uint32_t                    num_filters;
    PPA_CMD_VLAN_FILTER_CONFIG  filters[PPA_MAX_VLAN_FILTER];
} PPA_CMD_VLAN_ALL_FILTER_CONFIG;

//typedef struct {
//    uint32_t    ig_criteria_type;
//    uint32_t    ig_criteria;
//    uint32_t    new_vci;
//    uint32_t    vlan_port_map;
//} PPA_CMD_VLAN_FILTER_CONFIG;
//
//typedef struct
//{
//    uint32_t    vlan_p;
//    uint32_t    queue;
//} PPA_IOCTL_BR_VLAN_PRIO;

typedef struct {
    PPA_IFNAME      ifname[PPA_IF_NAME_SIZE];
    uint8_t         mac[PPA_ETH_ALEN];
    uint32_t        flags;
} PPA_CMD_IF_MAC_INFO;

typedef struct {
    uint32_t        num_ifinfos;
    PPA_CMD_IFINFO  ifinfo[PPA_MAX_IFS_NUM];
} PPA_CMD_IFINFOS;



/*
 * ####################################
 *             Declaration
 * ####################################
 */

#ifdef __KERNEL__
  void ifx_ppa_get_api_id(uint32_t *,
                          uint32_t *,
                          uint32_t *,
                          uint32_t *,
                          uint32_t *,
                          uint32_t *,
                          uint32_t *);

  int32_t ifx_ppa_is_init(void);

  int32_t ifx_ppa_init(PPA_INIT_INFO *, uint32_t);
  void ifx_ppa_exit(void);

  int32_t ifx_ppa_enable(uint32_t, uint32_t, uint32_t);
  int32_t ifx_ppa_get_status(uint32_t *, uint32_t *, uint32_t);

  int32_t ifx_ppa_session_add(PPA_BUF *, PPA_SESSION *, uint32_t);
  int32_t ifx_ppa_session_delete(PPA_SESSION *, uint32_t);
  int32_t ifx_ppa_session_modify(PPA_SESSION *, PPA_SESSION_EXTRA *, uint32_t);
  int32_t ifx_ppa_session_get(PPA_SESSION ***, PPA_SESSION_EXTRA **, int32_t *, uint32_t);

  int32_t ifx_ppa_mc_group_update(PPA_MC_GROUP *, uint32_t);
  int32_t ifx_ppa_mc_group_get(IPADDR, PPA_MC_GROUP *, uint32_t);
  int32_t ifx_ppa_mc_entry_modify(IPADDR, PPA_MC_GROUP *, PPA_SESSION_EXTRA *, uint32_t);
  int32_t ifx_ppa_mc_entry_get(IPADDR, PPA_SESSION_EXTRA *, uint32_t);

  int32_t ifx_ppa_inactivity_status(PPA_U_SESSION *);
  int32_t ifx_ppa_set_session_inactivity(PPA_U_SESSION *, int32_t);

  int32_t ifx_ppa_bridge_entry_add(uint8_t *, PPA_NETIF *, uint32_t);
  int32_t ifx_ppa_bridge_entry_delete(uint8_t *, uint32_t);
  int32_t ifx_ppa_bridge_entry_hit_time(uint8_t *, uint32_t *);
  int32_t ifx_ppa_bridge_entry_inactivity_status(uint8_t *);
  int32_t ifx_ppa_set_bridge_entry_timeout(uint8_t *, uint32_t);

  int32_t ifx_ppa_set_bridge_if_vlan_config(PPA_NETIF *, PPA_VLAN_TAG_CTRL *, PPA_VLAN_CFG *, uint32_t);
  int32_t ifx_ppa_get_bridge_if_vlan_config(PPA_NETIF *, PPA_VLAN_TAG_CTRL *, PPA_VLAN_CFG *, uint32_t);
  int32_t ifx_ppa_vlan_filter_add(PPA_VLAN_MATCH_FIELD *, PPA_VLAN_INFO *, uint32_t);
  int32_t ifx_ppa_vlan_filter_del(PPA_VLAN_MATCH_FIELD *, PPA_VLAN_INFO *, uint32_t);
  int32_t ifx_ppa_vlan_filter_get_all(int32_t *, PPA_VLAN_FILTER_CONFIG *, uint32_t);
  int32_t ifx_ppa_vlan_filter_del_all(uint32_t);

  int32_t ifx_ppa_get_if_stats(PPA_IFNAME *, PPA_IF_STATS *, uint32_t);
  int32_t ifx_ppa_get_accel_stats(PPA_IFNAME *, PPA_ACCEL_STATS *, uint32_t);

  int32_t ifx_ppa_set_if_mac_address(PPA_IFNAME *, uint8_t *, uint32_t);
  int32_t ifx_ppa_get_if_mac_address(PPA_IFNAME *, uint8_t *, uint32_t);

  int32_t ifx_ppa_add_if(PPA_IFINFO *, uint32_t);
  int32_t ifx_ppa_del_if(PPA_IFINFO *, uint32_t);
  int32_t ifx_ppa_get_if(int32_t *, PPA_IFINFO **, uint32_t);
#endif



#ifdef __KERNEL__
  #include <net/ifx_ppa_hook.h>
#endif



#endif  //  __IFX_PPA_API_H__20081031_1913__
