/******************************************************************************
**
** FILE NAME    : amazon_se_pmu.h
** PROJECT      : Amazon_se
** MODULES      : PMU
**
** DATE         : 1 Jan 2006
** AUTHOR       : Huang Xiaogang
** DESCRIPTION  : Amazon_se Power Management Unit driver header file
** COPYRIGHT    :       Copyright (c) 2006
**                      Infineon Technologies AG
**                      Am Campeon 1-12, 85579 Neubiberg, Germany
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 2 of the License, or
**    (at your option) any later version.
**
** HISTORY
** $Date        $Author         $Comment
** 01 Jan 2006  Huang Xiaogang  modification & verification on Amazon_se chip
*******************************************************************************/

#ifndef AMAZON_SE_PMU_H
#define AMAZON_SE_PMU_H

typedef struct pmu_dev{
      char name[16];
      int major;
      int minor;
      int occupied;
      int count;
      char buff[10];
}pmu_dev;

#define AMAZON_SE_PMU_IOC_MAGIC                    0xe0
#define AMAZON_SE_PMU_IOC_SET_USBPHY               _IOW( AMAZON_SE_PMU_IOC_MAGIC, 0, int)
#define AMAZON_SE_PMU_IOC_SET_FPI2                 _IOW( AMAZON_SE_PMU_IOC_MAGIC, 1, int)
#define AMAZON_SE_PMU_IOC_SET_SDIO                 _IOW( AMAZON_SE_PMU_IOC_MAGIC, 2, int)

#define AMAZON_SE_PMU_IOC_SET_DMA                  _IOW( AMAZON_SE_PMU_IOC_MAGIC, 5, int)
#define AMAZON_SE_PMU_IOC_SET_USB                  _IOW( AMAZON_SE_PMU_IOC_MAGIC, 6, int)
#define AMAZON_SE_PMU_IOC_SET_EPHY                 _IOW( AMAZON_SE_PMU_IOC_MAGIC, 7, int)
#define AMAZON_SE_PMU_IOC_SET_SPI                  _IOW( AMAZON_SE_PMU_IOC_MAGIC, 8, int)
#define AMAZON_SE_PMU_IOC_SET_DSL                  _IOW( AMAZON_SE_PMU_IOC_MAGIC, 9, int)
#define AMAZON_SE_PMU_IOC_SET_EBU                  _IOW( AMAZON_SE_PMU_IOC_MAGIC, 10, int)
#define AMAZON_SE_PMU_IOC_SET_LEDC                 _IOW( AMAZON_SE_PMU_IOC_MAGIC, 11, int)
#define AMAZON_SE_PMU_IOC_SET_GPTC                 _IOW( AMAZON_SE_PMU_IOC_MAGIC, 12, int)
#define AMAZON_SE_PMU_IOC_SET_PPE                  _IOW( AMAZON_SE_PMU_IOC_MAGIC, 13, int)
#define AMAZON_SE_PMU_IOC_SET_FPI0                 _IOW( AMAZON_SE_PMU_IOC_MAGIC, 14, int)
#define AMAZON_SE_PMU_IOC_SET_AHB                  _IOW( AMAZON_SE_PMU_IOC_MAGIC, 15, int)

#define AMAZON_SE_PMU_IOC_SET_UART1                _IOW( AMAZON_SE_PMU_IOC_MAGIC, 17, int)
#define AMAZON_SE_PMU_IOC_SET_WDT0                 _IOW( AMAZON_SE_PMU_IOC_MAGIC, 18, int)

#define AMAZON_SE_PMU_IOC_SET_PPE_TC               _IOW( AMAZON_SE_PMU_IOC_MAGIC, 21, int)

#define AMAZON_SE_PMU_IOC_SET_PPE_ENET0            _IOW( AMAZON_SE_PMU_IOC_MAGIC, 23, int)

#define AMAZON_SE_PMU_IOC_SET_PWDCR                _IOW( AMAZON_SE_PMU_IOC_MAGIC, 26, int)
#define AMAZON_SE_PMU_IOC_GET_STATUS               _IOR( AMAZON_SE_PMU_IOC_MAGIC, 27, int)

#endif
