#ifndef IFX_GPIO_H
#define IFX_GPIO_H

#ifdef __KERNEL__

 #ifdef CONFIG_AMAZON_SE
  #include <asm/amazon_se/amazon_se_gpio.h>
 #endif

#else

 #ifndef __IFX_GPIO_IOCTL__
 #define __IFX_GPIO_IOCTL__

#define PORT_MODULE_NAME_MAX    32
/* module id for all kinds of gpio users */
enum {
    PORT_AVAILABLE       = -1,
    PORT_MODULE_LEGACY   = 0,
    PORT_MODULE_MIN      = PORT_MODULE_LEGACY,
    PORT_MODULE_MEI_JTAG = 1,
    PORT_MODULE_SSC      = 2,
    PORT_MODULE_ASC      = 3,
    PORT_MODULE_SDIO     = 4,
    PORT_MODULE_LED      = 5,
    PORT_MODULE_USB      = 6,
    PORT_MODULE_SWITCH   = 7,        /*Reddy @10032008,  Add for Switch module */
    PORT_MODULE_PCI      = 8,
    PORT_MODULE_NAND     = 9,
    PORT_MODULE_PPA      = 10,
    PORT_MODULE_TAPI     = 11,
    PORT_MODULE_MAX      = PORT_MODULE_TAPI,
};

#define PORT_MODULE_ID	0xff

//  brief Parameter structure used to configure gpio port/pin value.
struct amazon_se_port_ioctl_parm {
	int port;          /*!< GPIO port number 0 ~ 3 */
	int pin;           /*!< GPIO pin number 0 ~ 15 */
	int value;         /*!< value to be set */
	int module;        /*!< module id of this operation */
};

#define AMAZON_SE_PORT_IOC_MAGIC	0xbf
#define AMAZON_SE_PORT_IOCOD	     _IOW( AMAZON_SE_PORT_IOC_MAGIC,0,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCPUDSEL	 _IOW( AMAZON_SE_PORT_IOC_MAGIC,1,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCPUDEN	 _IOW( AMAZON_SE_PORT_IOC_MAGIC,2,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCSTOFF	 _IOW( AMAZON_SE_PORT_IOC_MAGIC,3,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCDIR	 _IOW( AMAZON_SE_PORT_IOC_MAGIC,4,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCOUTPUT	 _IOW( AMAZON_SE_PORT_IOC_MAGIC,5,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCINPUT	 _IOWR(AMAZON_SE_PORT_IOC_MAGIC,6,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCALTSEL0 _IOW( AMAZON_SE_PORT_IOC_MAGIC,7,struct amazon_se_port_ioctl_parm)
#define AMAZON_SE_PORT_IOCALTSEL1 _IOW( AMAZON_SE_PORT_IOC_MAGIC,8,struct amazon_se_port_ioctl_parm)

#define bsp_port_ioctl_parm     amazon_se_port_ioctl_parm

#define BSP_PORT_IOC_MAGIC	    AMAZON_SE_PORT_IOC_MAGIC
#define BSP_PORT_IOCOD	        AMAZON_SE_PORT_IOCOD
#define BSP_PORT_IOCPUDSEL	    AMAZON_SE_PORT_IOCPUDSEL
#define BSP_PORT_IOCPUDEN	    AMAZON_SE_PORT_IOCPUDEN
#define BSP_PORT_IOCSTOFF	    AMAZON_SE_PORT_IOCSTOFF
#define BSP_PORT_IOCDIR         AMAZON_SE_PORT_IOCDIR
#define BSP_PORT_IOCOUTPUT	    AMAZON_SE_PORT_IOCOUTPUT
#define BSP_PORT_IOCINPUT	    AMAZON_SE_PORT_IOCINPUT
#define BSP_PORT_IOCALTSEL0     AMAZON_SE_PORT_IOCALTSEL0
#define BSP_PORT_IOCALTSEL1     AMAZON_SE_PORT_IOCALTSEL1

 #endif  // __IFX_GPIO_IOCTL__
#endif  //  __KERNEL__

#endif	// IFX_GPIO_H

