/******************************************************************************
**
** FILE NAME    : amazon_se_sdio_controller.h
** PROJECT      : Amazon SE
** MODULES      : SDIO
**
** DATE         : 06 DEC 2006
** AUTHOR       : Reddy Mallikarjuna
** DESCRIPTION  : Amazon SE  SDIO Driver
** COPYRIGHT    :       Copyright (c) 2006
**                      Infineon Technologies AG
**                      Am Campeon 1-12, 85579 Neubiberg, Germany
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 2 of the License, or
**    (at your option) any later version.
**
** HISTORY
** $Date      		$Author     		$Comment
** 06 DEC 2006		Reddy Mallikarjuna	Initial Version
** 25 June 2007		Reddy Mallikarjuna	Added ioctl command ids(AMAZON_SE_SDIO_MEM_DATA_TX/RX)
*******************************************************************************/
#define DEVICE_NAME "AMAZON_SE_SDIO"

typedef struct {
	struct dma_device_info *dma_device;
	uint32_t mclk_speed;
} amazon_se_sd_controller_priv_t;

#define AMAZON_SE_SDIO_SEND_CMD 		1
#define AMAZON_SE_SDIO_SEND_DATA 		2
#define AMAZON_SE_SDIO_READ_DATA 		3
#define AMAZON_SE_SDIO_SET_OPS_WBUS	4
#define AMAZON_SE_SDIO_SET_OPS_FREQUENCY	5
#define AMAZON_SE_SDIO_GET_OPS_WBUS	6
#define AMAZON_SE_SDIO_GET_OPS_FREQUENCY	7
#define AMAZON_SE_SDIO_MEM_DATA_TX 8
#define AMAZON_SE_SDIO_MEM_DATA_RX 9

typedef struct {
	int block_length;	//0~11:1 Byte ~ 2048 Bytes
	int data_length;	// total data size
	struct sd_cmd cmd;
	char data[2048];
} amazon_se_sdio_ioctl_block_request;
