#ifndef __AMAZON_SE_PTM_H__2007_10_02__10_32__
#define __AMAZON_SE_PTM_H__2007_10_02__10_32__


/******************************************************************************
**
** FILE NAME    : amazon_se_ptm.h
** PROJECT      : Danube
** MODULES     	: DSL PTM
**
** DATE         : 4 AUG 2005
** AUTHOR       : Xu Liang
** DESCRIPTION  : PTM Driver Header File
** COPYRIGHT    : 	Copyright (c) 2006
**			Infineon Technologies AG
**			Am Campeon 1-12, 85579 Neubiberg, Germany
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 2 of the License, or
**    (at your option) any later version.
**
** HISTORY
** $Date        $Author         $Comment
**  4 AUG 2005  Xu Liang        Initiate Version
** 23 OCT 2006  Xu Liang        Add GPL header.
*******************************************************************************/


/*
 * ####################################
 *              Definition
 * ####################################
 */

/*
 *  ioctl Command
 */
#if 1
  #define IFX_PTM_MIB_CW_GET              SIOCDEVPRIVATE + 1
  #define IFX_PTM_MIB_FRAME_GET           SIOCDEVPRIVATE + 2
  #define IFX_PTM_CFG_GET                 SIOCDEVPRIVATE + 3
  #define IFX_PTM_CFG_SET                 SIOCDEVPRIVATE + 4
#else
  #define SET_ETH_SPEED_AUTO              SIOCDEVPRIVATE
  #define SET_ETH_SPEED_10                SIOCDEVPRIVATE + 1
  #define SET_ETH_SPEED_100               SIOCDEVPRIVATE + 2
  #define SET_ETH_DUPLEX_AUTO             SIOCDEVPRIVATE + 3
  #define SET_ETH_DUPLEX_HALF             SIOCDEVPRIVATE + 4
  #define SET_ETH_DUPLEX_FULL             SIOCDEVPRIVATE + 5
  #define SET_ETH_REG                     SIOCDEVPRIVATE + 6
  #define VLAN_TOOLS                      SIOCDEVPRIVATE + 7
  #define MAC_TABLE_TOOLS                 SIOCDEVPRIVATE + 8
  #define SET_VLAN_COS                    SIOCDEVPRIVATE + 9
  #define SET_DSCP_COS                    SIOCDEVPRIVATE + 10
  #define ENABLE_VLAN_CLASSIFICATION      SIOCDEVPRIVATE + 11
  #define DISABLE_VLAN_CLASSIFICATION     SIOCDEVPRIVATE + 12
  #define VLAN_CLASS_FIRST                SIOCDEVPRIVATE + 13
  #define VLAN_CLASS_SECOND               SIOCDEVPRIVATE + 14
  #define ENABLE_DSCP_CLASSIFICATION      SIOCDEVPRIVATE + 15
  #define DISABLE_DSCP_CLASSIFICATION     SIOCDEVPRIVATE + 16
  #define PASS_UNICAST_PACKETS            SIOCDEVPRIVATE + 17
  #define FILTER_UNICAST_PACKETS          SIOCDEVPRIVATE + 18
  #define KEEP_BROADCAST_PACKETS          SIOCDEVPRIVATE + 19
  #define DROP_BROADCAST_PACKETS          SIOCDEVPRIVATE + 20
  #define KEEP_MULTICAST_PACKETS          SIOCDEVPRIVATE + 21
  #define DROP_MULTICAST_PACKETS          SIOCDEVPRIVATE + 22
#endif


/*
 * ####################################
 *              Data Type
 * ####################################
 */

/*
 *  Data Type Used to Call ioctl
 */
struct vlan_cos_req {
    int     pri;
    int     cos_value;
};

struct dscp_cos_req {
    int     dscp;
    int     cos_value;
};

typedef struct ptm_cw_ifEntry_t {
    uint32_t    ifRxNoIdleCodewords;
    uint32_t    ifRxIdleCodewords;
    uint32_t    ifRxCodingViolation;
    uint32_t    ifTxNoIdleCodewords;
    uint32_t    ifTxIdleCodewords;
} PTM_CW_IF_ENTRY_T;

typedef struct ptm_frame_mib_t {
    uint32_t    RxCorrect;
    uint32_t    TC_CrcError;
    uint32_t    RxDropped;
    uint32_t    TxSend;
} PTM_FRAME_MIB_T;

typedef struct {
    uint32_t    RxEthCrcPresent;
    uint32_t    RxEthCrcCheck;
    uint32_t    RxTcCrcCheck;
    uint32_t    RxTcCrcLen;
    uint32_t    TxEthCrcGen;
    uint32_t    TxTcCrcGen;
    uint32_t    TxTcCrcLen;
} IFX_PTM_CFG_T;


/*
 * ####################################
 *             Declaration
 * ####################################
 */

#if defined(__KERNEL__)
#endif  //  defined(__KERNEL__)


#endif  //  __AMAZON_SE_PTM_H__2007_10_02__10_32__
