#ifndef AMAZON_SE_MTD_MAP_H
#define AMAZON_SE_MTD_MAP_H
//#include <asm/amazon_s/amazon_s_sflash.h>

#if (CONFIG_MTD_AMAZON_SE_FLASH_SIZE == 2)
	#define AMAZON_SE_SYSTEM_PARTITION_SIZE    0x001B0000
#elif (CONFIG_MTD_AMAZON_SE_FLASH_SIZE == 4)
	#define AMAZON_SE_SYSTEM_PARTITION_SIZE    0x003C0000
#elif (CONFIG_MTD_AMAZON_SE_FLASH_SIZE == 8)
	#define AMAZON_SE_SYSTEM_PARTITION_SIZE    0x007A0000
#else
	#error  "Configure Amazon-S MTD flash size first!!"
#endif

/* partition definition for first flash bank
 * also ref. to "drivers/char/flash_config.c"
 */
#if (CONFIG_MTD_AMAZON_SE_FLASH_SIZE == 2)
static struct mtd_partition amazon_se_partitions[] = {
	{
		name:         "U-Boot",		/* U-Boot firmware */
		offset:       0x00000000,
		size:         0x00020000,	//128K
/*		mask_flags:   MTD_WRITEABLE,	force read-only */
	},
	{
		name:         "firmware",	/* firmware */
		offset:       0x00020000,
		size:         0x00030000,	//192K
/*		mask_flags:   MTD_WRITEABLE,	force read-only */
	},
	{
		name:         "rootfs,kernel,Data,Environment",		/* default partition */
		offset:       0x00050000,
		size:         AMAZON_S_SYSTEM_PARTITION_SIZE,
/*		mask_flags:   MTD_WRITEABLE,	force read-only */
	},
};
#elif (CONFIG_MTD_AMAZON_SE_FLASH_SIZE == 4)
static struct mtd_partition amazon_se_partitions[] = {
	{
		name:         "U-Boot",		
		offset:       0x00000000,
		size:         0x00010000,	
/*		mask_flags:   MTD_WRITEABLE,	force read-only */
	},
	{
		name:         "Firmware",	
		offset:       0x00010000,
		size:         0x00030000,	
/*		mask_flags:   MTD_WRITEABLE,	force read-only */
	},
	{
		name:         "RootFS,Kernel,Data,Environment",		/* default partition */
		offset:       0x00040000,
		size:         AMAZON_SE_SYSTEM_PARTITION_SIZE,
/*		mask_flags:   MTD_WRITEABLE,	force read-only */
	},
};
#elif (CONFIG_MTD_AMAZON_SE_FLASH_SIZE == 8)
static struct mtd_partition amazon_se_partitions[] = {
	{
		name:         "U-Boot",		/* U-Boot firmware */
		offset:       0x00000000,
		size:         0x00020000,	//128K
/*		mask_flags:   MTD_WRITEABLE,	force read-only */
	},
	{
		name:         "firmware",	/* firmware */
		offset:       0x00020000,
		size:         0x00040000,	//256K
/*		mask_flags:   MTD_WRITEABLE,	force read-only */
	},
	{
		name:         "rootfs,kernel,Data,Environment",		/* default partition */
		offset:       0x00060000,
		size:         AMAZON_SE_SYSTEM_PARTITION_SIZE,
/*		mask_flags:   MTD_WRITEABLE,	force read-only */
	},
};
#else
	#error  "Configure Amazon-S MTD flash size first!!"
#endif

/*
 * Define partitions for nand flash device
 */
static const struct mtd_partition amazon_se_nand_partition[] = {
        {
         .name = "u-boot",
         .offset = 0,
         .size = 0x40000},
        {
         .name = "firmware",
         .offset =0x40000,
         .size = 0x80000},
       {
         .name = "rootfs",
         .offset =0xC0000,
         .size = 0x500000},

};

#if 0
/*
 * spi flash partition information
 * Here are partition information for all known amazon_s series devices.
 * See include/linux/mtd/partitions.h for definition of the mtd_partition
 * structure.
 */
#define AMAZON_SE_SYTEM_PARTITION_NUMBER       3
#define AMAZON_SE_SYSTEM_PARTITION_2MB_SIZE    0x001B0000
#define AMAZON_SE_SYSTEM_PARTITION_4MB_SIZE    0x003A0000
#define AMAZON_SE_SYSTEM_PARTITION_8MB_SIZE    0x007A0000

static struct mtd_partition ifx_spi_partitions[SPI_MAX_FLASH][AMAZON_SE_SYTEM_PARTITION_NUMBER] = {
    {{0, 0, 0}},

/* 256K Byte */
    {{
        name:         "spi-boot",		/* U-Boot firmware */
        offset:       0x00000000,
        size:         0x00040000,	       /* 256 */
    /*	mask_flags:   MTD_WRITEABLE,    force read-only */
    }, {0}, {0},
    },

/* 512K Byte */ 
    {{0, 0, 0}},

/* 1M Byte */ 
    {{0, 0, 0}},

/* 2M Byte */
    {{
        name:         "spi-boot",		/* U-Boot firmware */
        offset:       0x00000000,
        size:         0x00020000,	       /* 128K */
    /*	mask_flags:   MTD_WRITEABLE,    force read-only */
    },
    {
        name:         "spi-firmware",	/* firmware */
        offset:       0x00020000,
        size:         0x00030000,	       /* 192K */
    /*	mask_flags:   MTD_WRITEABLE,    force read-only */
    },
    {
        name:         "spi-rootfs,kernel,Data,Environment",		/* default partition */
        offset:       0x00050000,
        size:         AMAZON_SE_SYSTEM_PARTITION_2MB_SIZE,
    /*	mask_flags:   MTD_WRITEABLE,    force read-only */
    }},

/* 4M Byte */
    {{
        name:         "spi-boot",		/* U-Boot firmware */
        offset:       0x00000000,
        size:         0x00020000,	       /* 128K */
    /*	mask_flags:   MTD_WRITEABLE,    force read-only */
    },
    {
        name:         "spi-firmware",	/* firmware */
        offset:       0x00020000,
        size:         0x00040000,	       /* 256K */
    /*	mask_flags:   MTD_WRITEABLE,    force read-only */
    },
    {
        name:         "spi-rootfs,kernel,Data,Environment",		/* default partition */
        offset:       0x00060000,
        size:         AMAZON_SE_SYSTEM_PARTITION_4MB_SIZE,
    /*	mask_flags:   MTD_WRITEABLE,    force read-only */
    }},

/* 8M Byte */
    {{
        name:         "spi-boot",		/* U-Boot firmware */
        offset:       0x00000000,
        size:         0x00020000,	       /* 128K */
    /*	mask_flags:   MTD_WRITEABLE,    force read-only */
    },
    {
        name:         "spi-firmware",	/* firmware */
        offset:       0x00020000,
        size:         0x00030000,	       /* 192K */
    /*	mask_flags:   MTD_WRITEABLE,    force read-only */
    },
    {
        name:         "spi-rootfs,kernel,Data,Environment",		/* default partition */
        offset:       0x00050000,
        size:         AMAZON_SE_SYSTEM_PARTITION_8MB_SIZE,
    /*	mask_flags:   MTD_WRITEABLE,    force read-only */
    }},
};

#endif

#endif  // AMAZON_SE_MTD_MAP_H
