/* =============================================================================
** FILE NAME     : hmcp.h
** PROJECT       : HMCP on AMAZON_S
** MODULES       : Kernel specific HMCP
** DATE          : 26-09-2008
** AUTHOR        : Kishore Kankipati
** DESCRIPTION   : Kernel specific HMCP functions' 
**                 
** REFERENCES    :
** COPYRIGHT     : Copyright (c) 2008
**                 Infineon Technologies AG,
**                 Am Campeon 1-12, 85579 Neubiberg, Germany
**
** Any use of this software is subject to the conclusion of a respective
** License agreement. Without such a License agreement no rights to the
** software are granted
**
** HISTORY       :
** $Date   $Author    $Comment
**
** ============================================================================
*/


#ifndef HMCP_H
#define HMCP_H

#include <linux/smp.h>

#define NUM_VPE 2
#define MAX_NET_DEV_VPE 32
extern volatile unsigned long vpe_device_schedule[NUM_VPE];
extern struct net_device *vpe_devices[NUM_VPE][MAX_NET_DEV_VPE];
void hmcp_init(void);
int inter_vpe_msg(struct net_device* dev, u32 dest_vpe, u32 src_vpe);

#ifdef CONFIG_MIPS_MT_HMCP_IPI
typedef struct {
	unsigned int vpe0_irq;
	unsigned int vpe1_irq;
	void (*hmcp_ipi_vpe)(unsigned int, unsigned int);
}hmcp_ipi;

int plat_init_vpe_ipi_framework(hmcp_ipi*);

#endif
#endif
