/*
 * marker.h
 *
 * Code markup for dynamic and static tracing. i386 architecture optimisations.
 *
 * (C) Copyright 2006 Mathieu Desnoyers <mathieu.desnoyers@polymtl.ca>
 *
 * This file is released under the GPLv2.
 * See the file COPYING for more details.
 */


#ifdef CONFIG_MARKERS

#define _MF_DEFAULT (_MF_OPTIMIZED | _MF_LOCKDEP | _MF_PRINTK)

#define MARK_OPTIMIZED(flags, name, format, args...) \
	do { \
		static marker_probe_func *__mark_call_##name = \
					__mark_empty_function; \
		static const struct __mark_marker_c __mark_c_##name \
			__attribute__((section(".markers.c"))) = \
			{ #name, &__mark_call_##name, format, \
			(flags) | _MF_OPTIMIZED } ; \
		char condition; \
		asm volatile(	".section .markers, \"a\", @progbits;\n\t" \
					".long %1, 0f;\n\t" \
					".previous;\n\t" \
					".align 2\n\t" \
					"0:\n\t" \
					"movb $0,%0;\n\t" \
				: "=r" (condition) \
				: "m" (__mark_c_##name)); \
		__mark_check_format(format, ## args); \
		if (unlikely(condition)) { \
			preempt_disable(); \
			(*__mark_call_##name)(format, ## args); \
			preempt_enable(); \
		} \
	} while (0)

#define _MARK(flags, format, args...) \
do { \
	if (((flags) & _MF_LOCKDEP) && ((flags) & _MF_OPTIMIZED)) \
		MARK_OPTIMIZED(flags, format, ## args); \
	else \
		MARK_GENERIC(flags, format, ## args); \
} while (0)

#define MARK(format, args...) _MARK(_MF_DEFAULT, format, ## args)

/* Offset of the immediate value from the start of the movb instruction, in
 * bytes. */
#define MARK_OPTIMIZED_ENABLE_IMMEDIATE_OFFSET 1
#define MARK_OPTIMIZED_ENABLE_TYPE char
/* Dereference enable as lvalue from a pointer to its instruction */
#define MARK_OPTIMIZED_ENABLE(a) \
	*(MARK_OPTIMIZED_ENABLE_TYPE*) \
		((char*)a+MARK_OPTIMIZED_ENABLE_IMMEDIATE_OFFSET)

extern int marker_optimized_set_enable(void *address, char enable);

#endif
