/*****************************************************************************
 **   FILE NAME       : dwc_otg_ifx.h
 **   PROJECT         : USB Host and Device driver
 **   MODULES         : USB Host and Device driver
 **   SRC VERSION     : 2.0
 **   DATE            : 1/March/2008
 **   AUTHOR          : Chen, Howard based on Synopsys Original
 **   DESCRIPTION     : Platform specific initialization
 **   FUNCTIONS       :
 **   COMPILER        : gcc
 **   REFERENCE       :
 **   COPYRIGHT       :
 **  Version Control Section  **
 **   $Author$
 **   $Date$
 **   $Revisions$
 **   $Log$       Revision history
*****************************************************************************/

/*! \file dwc_otg_ifx.h
    \brief Platform specific initialization.
*/
#if !defined(__DWC_OTG_IFX_H__)
#define __DWC_OTG_IFX_H__

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
	#include <asm/addrspace.h>
	#include <asm/bitops.h>
	#include <asm/io.h>
#endif

// 20070316, winder added.
#ifndef REGSIZE
#define REGSIZE                         0x00001000
#endif

extern void dwc_otg_power_on (void);
extern void dwc_otg_power_off (void);
extern void dwc_otg_ahb_reset  (void);
extern void dwc_otg_hard_reset (void);
extern void dwc_otg_vbus_on (void);
extern void dwc_otg_vbus_off (void);
//extern int  dwc_otg_vbus_status (void);


// 20070316, winder added.
#if defined(CONFIG_TWINPASS) || defined(CONFIG_DANUBE)

	// FIXME: The current Linux-2.6 do not have these header files, but anyway, we need these.
	// #include <asm/danube/danube.h>
	// #include <asm/ifx/irq.h>

	#define IFX_USB_NUM 0
	#define IFX_USB_IOMEM_BASE 0x1e101000
	#define IFX_USB_IRQ        54
	#define IFX_USB_FIFOMEM_BASE 0x1e120000
	#define IFX_USB_FIFOMEM_DBG  0x1e140000
	#define IFX_USB_OC_IRQ 151
	#define IFX_USB_IOMEM_SIZE REGSIZE
	#define IFX_USB_FIFOMEM_SIZE 0x00010000
	#define IFX_USB_FIFODBG_SIZE 0x00020000


	#ifndef DANUBE_RCU_BASE_ADDR
		#define DANUBE_RCU_BASE_ADDR            (0xBF203000)
	#endif

	#ifndef DANUBE_CGU
		#define DANUBE_CGU                      (0xBF103000)
	#endif
	#ifndef DANUBE_CGU_IFCCR
		#define DANUBE_CGU_IFCCR                ((volatile u32*)(DANUBE_CGU+ 0x0018))
	#endif
	#ifndef DANUBE_PMU
		#define DANUBE_PMU                      (KSEG1+0x1F102000)
	#endif
	#ifndef DANUBE_PMU_PWDCR
		#define DANUBE_PMU_PWDCR                ((volatile u32*)(DANUBE_PMU+0x001C))
	#endif

	#ifndef DANUBE_GPIO_P0_OUT
		#define DANUBE_GPIO_P0_OUT                      (0xBF103000+0x10)
		#define DANUBE_GPIO_P0_DIR                      (0xBF103000+0x18)
		#define DANUBE_GPIO_P0_ALTSEL0                  (0xBF103000+0x1C)
		#define DANUBE_GPIO_P0_ALTSEL1                  (0xBF103000+0x20)
		#define DANUBE_GPIO_P0_OD                       (0xBF103000+0x24)
		#define DANUBE_GPIO_P0_PUDSEL                   (0xBF103000+0x2C)
		#define DANUBE_GPIO_P0_PUDEN                    (0xBF103000+0x30)
		#define DANUBE_GPIO_P1_OUT                      (0xBF103000+0x40)
		#define DANUBE_GPIO_P1_DIR                      (0xBF103000+0x48)
		#define DANUBE_GPIO_P1_ALTSEL0                  (0xBF103000+0x4C)
		#define DANUBE_GPIO_P1_ALTSEL1                  (0xBF103000+0x50)
		#define DANUBE_GPIO_P1_OD                       (0xBF103000+0x54)
		#define DANUBE_GPIO_P1_PUDSEL                   (0xBF103000+0x5C)
		#define DANUBE_GPIO_P1_PUDEN                    (0xBF103000+0x60)
	#endif


	#define DANUBE_RCU_USBCFG  ((volatile u32*)(DANUBE_RCU_BASE_ADDR + 0x18))
	#define DANUBE_RCU_RESET   ((volatile u32*)(DANUBE_RCU_BASE_ADDR + 0x10))
	#define DANUBE_USBCFG_HDSEL_BIT    11	// 0:host, 1:device
	#define DANUBE_USBCFG_HOST_END_BIT 10	// 0:little_end, 1:big_end
	#define DANUBE_USBCFG_SLV_END_BIT  9	// 0:little_end, 1:big_end

	// FIXME: please make the name unified!! winder.
	#ifdef CONFIG_TWINPASS
		//extern void mask_and_ack_twinpass_irq (unsigned int irq_nr);
		extern void bsp_mask_and_ack_irq (unsigned int irq_nr);
		#define mask_and_ack_ifx_irq bsp_mask_and_ack_irq
	#else // for DANUBE.
		extern void mask_and_ack_danube_irq (unsigned int irq_nr);
		#define mask_and_ack_ifx_irq mask_and_ack_danube_irq
	#endif //

#elif defined(CONFIG_AMAZON_SE)
	#include <linux/types.h>
	#include <asm/amazon_se/amazon_se.h>
	//#include <asm/amazon_se/irq.h>


	#define IFX_USB_NUM 0
	#define IFX_USB_IOMEM_BASE 0x1e101000
	#define IFX_USB_IRQ        31
	#define IFX_USB_FIFOMEM_BASE 0x1e120000
	#define IFX_USB_FIFOMEM_DBG  0x1e140000
	#define IFX_USB_OC_IRQ 20
	#define IFX_USB_IOMEM_SIZE REGSIZE
	#define IFX_USB_FIFOMEM_SIZE 0x00010000
	#define IFX_USB_FIFODBG_SIZE 0x00020000

	#define AMAZON_SE_RCU_USBCFG  ((volatile u32*)(AMAZON_SE_RCU_BASE_ADDR + 0x18))
	#define AMAZON_SE_RCU_RESET   ((volatile u32*)(AMAZON_SE_RCU_BASE_ADDR + 0x10))
	#define AMAZON_SE_USBCFG_HDSEL_BIT    11	// 0:host, 1:device
	#define AMAZON_SE_USBCFG_HOST_END_BIT 10	// 0:little_end, 1:big_end
	#define AMAZON_SE_USBCFG_SLV_END_BIT  9 	// 0:little_end, 1:big_end

	#ifndef AMAZON_SE_GPIO_P0_OUT
		#define AMAZON_SE_GPIO_P0_OUT                      (0xBF103000+0x10)
		#define AMAZON_SE_GPIO_P0_DIR                      (0xBF103000+0x18)
		#define AMAZON_SE_GPIO_P0_ALTSEL0                  (0xBF103000+0x1C)
		#define AMAZON_SE_GPIO_P0_ALTSEL1                  (0xBF103000+0x20)
		#define AMAZON_SE_GPIO_P0_OD                       (0xBF103000+0x24)
		#define AMAZON_SE_GPIO_P0_PUDSEL                   (0xBF103000+0x2C)
		#define AMAZON_SE_GPIO_P0_PUDEN                    (0xBF103000+0x30)
		#define AMAZON_SE_GPIO_P1_OUT                      (0xBF103000+0x40)
		#define AMAZON_SE_GPIO_P1_DIR                      (0xBF103000+0x48)
		#define AMAZON_SE_GPIO_P1_ALTSEL0                  (0xBF103000+0x4C)
		#define AMAZON_SE_GPIO_P1_ALTSEL1                  (0xBF103000+0x50)
		#define AMAZON_SE_GPIO_P1_OD                       (0xBF103000+0x54)
		#define AMAZON_SE_GPIO_P1_PUDSEL                   (0xBF103000+0x5C)
		#define AMAZON_SE_GPIO_P1_PUDEN                    (0xBF103000+0x60)
	#endif


	#ifndef AMAZON_SE_CGU
		#define AMAZON_SE_CGU                      (0xBF103000)
	#endif
	#ifndef AMAZON_SE_CGU_IFCCR
		#define AMAZON_SE_CGU_IFCCR                ((volatile u32*)(AMAZON_SE_CGU+ 0x0018))
	#endif
	#ifndef AMAZON_SE_PMU
		#define AMAZON_SE_PMU                      (KSEG1+0x1F102000)
	#endif
	#ifndef AMAZON_SE_PMU_PWDCR
		#define AMAZON_SE_PMU_PWDCR                ((volatile u32*)(AMAZON_SE_PMU+0x001C))
	#endif


	#define mask_and_ack_ifx_irq mask_and_ack_amazon_se_irq
	extern void mask_and_ack_amazon_se_irq (unsigned int irq_nr);
#elif defined(CONFIG_AMAZON_S)
	#include <asm/types.h>
	#include <asm/amazon_s/amazon_s.h>
	#include <asm/ifx/irq.h>
	#include <asm/ifx/ifx_gpio.h>

	#define IFX_USB_IOMEM_SIZE REGSIZE
	#define IFX_USB_FIFOMEM_SIZE 0x00010000
	#define IFX_USB_FIFODBG_SIZE 0x00020000

	#define IFX_USB1_FIFOMEM_BASE 0x1e120000
	#define IFX_USB1_FIFOMEM_DBG  0x1e140000

//	#define IFX_USB2_FIFOMEM_BASE 0x1e1B0000
	#define IFX_USB2_FIFOMEM_BASE 0x1e1E0000
	#define IFX_USB2_FIFOMEM_DBG  0x1e1C0000
//	#define IFX_USB2_FIFOMEM_BASE 0x1e1D0000


	#define IFX_USB1_IOMEM_BASE 0x1e101000
	#define IFX_USB1_IRQ 54
	#define IFX_USB2_IOMEM_BASE 0x1e106000
	//#define IFX_USB2_IRQ 48
	#define IFX_USB2_IRQ 83

	#ifndef __IS_SECOND__
		#define IFX_USB_NUM 0
		#define IFX_USB_IOMEM_BASE IFX_USB1_IOMEM_BASE
		#define IFX_USB_IRQ        IFX_USB1_IRQ
		#define IFX_USB_FIFOMEM_BASE IFX_USB1_FIFOMEM_BASE
		#define IFX_USB_FIFOMEM_DBG  IFX_USB1_FIFOMEM_DBG
	#else
		#define IFX_USB_NUM 1
		#define IFX_USB_IOMEM_BASE IFX_USB2_IOMEM_BASE
		#define IFX_USB_IRQ        IFX_USB2_IRQ
		#define IFX_USB_FIFOMEM_BASE IFX_USB2_FIFOMEM_BASE
		#define IFX_USB_FIFOMEM_DBG  IFX_USB2_FIFOMEM_DBG
	#endif
	#define IFX_USB_OC_IRQ 60

	#ifndef AMAZON_S_RCU_BASE_ADDR
		#define AMAZON_S_RCU_BASE_ADDR            (0xBF203000)
	#endif

	#ifndef AMAZON_S_CGU
		#define AMAZON_S_CGU                          (0xBF103000)
	#endif
	#ifndef AMAZON_S_CGU_IFCCR
		#define AMAZON_S_CGU_IFCCR                        ((volatile u32*)(AMAZON_S_CGU+ 0x0018))
	#endif

	#ifndef AMAZON_S_PMU
		#define AMAZON_S_PMU                              (KSEG1+0x1F102000)
	#endif
	#ifndef AMAZON_S_PMU_PWDCR
		#define AMAZON_S_PMU_PWDCR                        ((volatile u32*)(AMAZON_S_PMU+0x001C))
	#endif

	#ifndef AMAZON_S_GPIO_P0_OUT
		#define AMAZON_S_GPIO_P0_OUT                      (0xBF103000+0x10)
		#define AMAZON_S_GPIO_P0_DIR                      (0xBF103000+0x18)
		#define AMAZON_S_GPIO_P0_ALTSEL0                  (0xBF103000+0x1C)
		#define AMAZON_S_GPIO_P0_ALTSEL1                  (0xBF103000+0x20)
		#define AMAZON_S_GPIO_P0_OD                       (0xBF103000+0x24)
		#define AMAZON_S_GPIO_P0_PUDSEL                   (0xBF103000+0x2C)
		#define AMAZON_S_GPIO_P0_PUDEN                    (0xBF103000+0x30)
		#define AMAZON_S_GPIO_P1_OUT                      (0xBF103000+0x40)
		#define AMAZON_S_GPIO_P1_DIR                      (0xBF103000+0x48)
		#define AMAZON_S_GPIO_P1_ALTSEL0                  (0xBF103000+0x4C)
		#define AMAZON_S_GPIO_P1_ALTSEL1                  (0xBF103000+0x50)
		#define AMAZON_S_GPIO_P1_OD                       (0xBF103000+0x54)
		#define AMAZON_S_GPIO_P1_PUDSEL                   (0xBF103000+0x5C)
		#define AMAZON_S_GPIO_P1_PUDEN                    (0xBF103000+0x60)
	#endif

	#define AMAZON_S_RCU_USB1CFG  ((volatile u32*)(AMAZON_S_RCU_BASE_ADDR + 0x18))
	#define AMAZON_S_RCU_USB2CFG  ((volatile u32*)(AMAZON_S_RCU_BASE_ADDR + 0x34))
	#define AMAZON_S_RCU_USBRESET ((volatile u32*)(AMAZON_S_RCU_BASE_ADDR + 0x10))
	#define AMAZON_S_USBCFG_ARB          7	//
	#define AMAZON_S_USBCFG_HDSEL_BIT    11	// 0:host, 1:device
	#define AMAZON_S_USBCFG_HOST_END_BIT 10	// 0:little_end, 1:big_end
	#define AMAZON_S_USBCFG_SLV_END_BIT  17	// 0:little_end, 1:big_end

	// FIXME: please make the name unified!! winder.
//	extern void mask_and_ack_amazon_s_irq (unsigned int irq_nr);
//	#define mask_and_ack_ifx_irq mask_and_ack_amazon_s_irq
	extern void bsp_mask_and_ack_irq (unsigned int irq_nr);
	#define mask_and_ack_ifx_irq bsp_mask_and_ack_irq
#else // CONFIG_AMAZON_SE
	#error "Please choose one platform!!"
#endif // CONFIG_AMAZON_SE

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
	#define dev_set_drvdata(_dev, _data) dwc_set_drvdata(_data)
	#define dev_get_drvdata(_dev) dwc_get_drvdata()
#endif


#endif //__DWC_OTG_IFX_H__
