/*****************************************************************************
 **   FILE NAME       : dwc_otg_attr.h
 **   PROJECT         : USB Host and Device driver
 **   MODULES         : USB Host and Device driver
 **   SRC VERSION     : 2.0
 **   DATE            : 1/March/2008
 **   AUTHOR          : Chen, Howard based on Synopsys Original
 **   DESCRIPTION     : The diagnostic interface will provide access to the controller
 **                     for bringing up the hardware and testing.  The Linux driver
 **                     attributes feature will be used to provide the Linux Diagnostic
 **                     Interface. These attributes are accessed through sysfs.
 **   FUNCTIONS       :
 **   COMPILER        : gcc
 **   REFERENCE       :
 **   COPYRIGHT       :
 **  Version Control Section  **
 **   $Author$
 **   $Date$
 **   $Revisions$
 **   $Log$       Revision history
*****************************************************************************/

#if !defined(__DWC_OTG_ATTR_H__)
#define __DWC_OTG_ATTR_H__

/*! \file dwc_otg_attr.h
    \brief This file contains the interface to the Linux device attributes.
*/



/*---------- First Level Grouping ---------------------*/
/** \ingroup USB_DRIVER
	\defgroup USB_DRIVER_ATTR Driver Attributes Interface
	\brief This section describes interface to the Linux device attributes.
 The Linux module attributes feature is used to provide the Linux
 Diagnostic Interface.  These attributes are accessed through sysfs.
 The diagnostic interface will provide access to the controller for
 bringing up the hardware and testing.
 Supported attributes are:

 mode        (r/ ) Returns the current mode: 0 for device mode, 1 for host mode
 buspower    (r/w) Gets or sets the Power State of the bus (0 - Off or 1 - On)
 bussuspend  (r/w) Suspends the USB bus.
 busconnected(r/ ) Gets the connection status of the bus
 gotgctl     (r/w) Gets or sets the Core Control Status Register.
 gusbcfg     (r/w) Gets or sets the Core USB Configuration Register
 grxfsiz     (r/w) Gets or sets the Receive FIFO Size Register
 gnptxfsiz   (r/w) Gets or sets the non-periodic Transmit Size Register
 gpvndctl    (r/w) Gets or sets the PHY Vendor Control Register
 guid        (r/w) Gets or sets the value of the User ID Register
 gsnpsid     (r/ ) Gets the value of the Synopsys ID Regester
 devspeed    (r/w) Gets or sets the device speed setting in the DCFG register
 enumspeed   (r/ ) Gets the device enumeration Speed.
 hptxfsiz    (r/ ) Gets the value of the Host Periodic Transmit FIFO
 hprt0       (r/w) Gets or sets the value in the Host Port Control and Status Register
 regoffset   (r/w) Sets the register offset for the next Register Access
 regvalue    (r/w) Gets or sets the value of the register at the offset in the regoffset attribute.
 regdump     (r/ ) Dumps the contents of core registers.
 hcddump     (r/ ) Dumps the current HCD state.
 hcd_frrem   (r/ ) Shows the average value of the Frame Remaining
                   field in the Host Frame Number/Frame Remaining register when an SOF interrupt
                   occurs. This can be used to determine the average interrupt latency. Also
                   shows the average Frame Remaining value for start_transfer and the "a" and
                   "b" sample points. The "a" and "b" sample points may be used during debugging
                   bto determine how long it takes to execute a section of the HCD code.
 rd_reg_test (r/ ) Displays the time required to read the GNPTXFSIZ register many times
                   (the output shows the number of times the register is read).
 wr_reg_test (r/ ) Displays the time required to write the GNPTXFSIZ register many times
                   (the output shows the number of times the register is written).
 \code
 Example usage:
   To get the current mode:
     cat /sys/devices/lm0/mode

   To power down the USB:
     echo 0 > /sys/devices/lm0/buspower
 \endcode

*/

extern struct device_attribute dev_attr_regoffset;
extern struct device_attribute dev_attr_regvalue;

extern struct device_attribute dev_attr_mode;
extern struct device_attribute dev_attr_buspower;
extern struct device_attribute dev_attr_bussuspend;
extern struct device_attribute dev_attr_busconnected;
extern struct device_attribute dev_attr_gotgctl;
extern struct device_attribute dev_attr_gusbcfg;
extern struct device_attribute dev_attr_grxfsiz;
extern struct device_attribute dev_attr_gnptxfsiz;
extern struct device_attribute dev_attr_gpvndctl;
extern struct device_attribute dev_attr_guid;
extern struct device_attribute dev_attr_gsnpsid;
extern struct device_attribute dev_attr_devspeed;
extern struct device_attribute dev_attr_enumspeed;
extern struct device_attribute dev_attr_hptxfsiz;
extern struct device_attribute dev_attr_hprt0;

void dwc_otg_attr_create (struct device *_dev);
void dwc_otg_attr_remove (struct device *_dev);

#endif
