
#ifndef __SSD_DEBUG_H__
#define __SSD_DEBUG_H__
#include <linux/kernel.h>	/* printk() */

extern int g_ssd_debug_level;
extern void* debugcallback;

typedef enum{
SSD_DEBUGLEVEL_EMERG=1,
SSD_DEBUGLEVEL_ALERT=2,
SSD_DEBUGLEVEL_CRIT=3,
SSD_DEBUGLEVEL_ERR=4,
SSD_DEBUGLEVEL_WARNING=5,
SSD_DEBUGLEVEL_NOTICE=6,
SSD_DEBUGLEVEL_INFO=7,
SSD_DEBUGLEVEL_DEBUG=8
}ssd_debuglevel;

#ifdef SSD_DEBUG

#define PDEBUG(format, args... ) if(g_ssd_debug_level >= SSD_DEBUGLEVEL_DEBUG) printk(format , ##args)
#define PINFO(format, ... ) if(g_ssd_debug_level >= SSD_DEBUGLEVEL_INFO) printk( format , ##__VA_ARGS__)
#define PNOTICE(format, ... ) if(g_ssd_debug_level >= SSD_DEBUGLEVEL_NOTICE) printk( format , ##__VA_ARGS__)
#define PWARNING(format, ... ) if(g_ssd_debug_level >= SSD_DEBUGLEVEL_WARNING) printk(format , ##__VA_ARGS__)

#else

#define PDEBUG(format, args... )
#define PINFO(format, ... )
#define PNOTICE(format, ... )
#define PWARNING(format, ... )

#endif
/* we want errors reported anyway */
#define PERR(format, args... ) if(g_ssd_debug_level >= SSD_DEBUGLEVEL_ERR) printk(format , ##args)
#define PCRIT(format, ... ) if(g_ssd_debug_level >= SSD_DEBUGLEVEL_CRIT) printk(format , ##__VA_ARGS__)
#define PALERT(format, ... ) if(g_ssd_debug_level >= SSD_DEBUGLEVEL_ALERT) printk(format , ##__VA_ARGS__)
#define PEMERG(format, ... ) if(g_ssd_debug_level >= SSD_DEBUGLEVEL_EMERG) printk(format , ##__VA_ARGS__)


#ifdef SSD_DEBUG

int ssd_init_socket(char* ipaddr, int port);

void ssd_close_socket(void);

/* dir=1: write */
/* dir=0: read */
int ssd_send_as_hexdump(unsigned  char* buf, int length, int dir);

int ssd_send_async_read_msg(int Length, int ret);

#else
#define ssd_init_socket(ipaddr, port) 0

#define ssd_close_socket()

#define ssd_send_as_hexdump(buf,length,dir) 0

#define ssd_send_async_read_msg(Length,ret) 0

#endif

#if TIWLAN_CLT_LEVEL >= 1 && TIWLAN_CLT_LEVEL <= 5
	#include <linux/bm_trace.h>
#else
	#define CL_TRACE_START_L1()
	#define CL_TRACE_START_L2()
	#define CL_TRACE_START_L3()
	#define CL_TRACE_START_L4()
	#define CL_TRACE_START_L5()
	#define CL_TRACE_END_L1(MODULE, CONTEXT, GROUP, SUFFIX)
	#define CL_TRACE_END_L2(MODULE, CONTEXT, GROUP, SUFFIX)
	#define CL_TRACE_END_L3(MODULE, CONTEXT, GROUP, SUFFIX)
	#define CL_TRACE_END_L4(MODULE, CONTEXT, GROUP, SUFFIX)
	#define CL_TRACE_END_L5(MODULE, CONTEXT, GROUP, SUFFIX)
#endif

#endif/* _SSD_DEBUG_H__ */
