
#ifdef SSD_DEBUG

#include <linux/in.h>
#include <linux/inet.h>
#include <net/sock.h>
#include "ssd_debug.h"
static const unsigned short serverport = 5555;
static struct socket *clientsocket=NULL;
static unsigned char s_buf[1050];
static struct sockaddr_in to;

extern int use_sock;
extern int interrupt_context;

unsigned long dump_buf(unsigned  char* buf, int length, int dir)
{
	int i;
	unsigned char* ptr = s_buf;
	unsigned char c1, c2;
	if(!dir)
		sprintf(s_buf,"rd:%d:",length);
	else
		sprintf(s_buf,"wr:%d:",length);
	while(*ptr) ptr++;
	for(i=0;i<length;i++,buf++){
		c1 = (*buf) & 0xf;
		c2 = ((*buf)>>4) & 0xf;
		if (c1<10) c1 += '0';
		else c1 = c1 + 'a' - 10;
		if(c2<10)c2 += '0';
		else c2 = c2+'a'-10;
		*ptr = c2;
		ptr++;
		*ptr = c1;
		ptr++;
		*ptr = 0;
	}
	*ptr = 0;
	return ((unsigned long)ptr)-((unsigned long)s_buf);
}

int ssd_init_socket(char* ipaddr, int port)
{
	if(!use_sock){
		return 0;
	}
	if( sock_create( AF_INET,SOCK_DGRAM,IPPROTO_UDP,&clientsocket)<0 ) {
		return -EIO;
	}
	to.sin_family = AF_INET;
	to.sin_addr.s_addr = in_aton( ipaddr ); /* destination address */
	to.sin_port = htons( (unsigned short)port );
	return 0;
}


/* dir=1: write */
/* dir=0: read */
int ssd_send_as_hexdump(unsigned  char* buf, int length, int dir)
{
	int len;
	struct msghdr msg;
	struct iovec iov;
	mm_segment_t oldfs;
	if(!use_sock){
		return 0;
	}
/* 	if(interrupt_context){ */
/* 		PWARNING("%s(): can't send in interrupt context\n", __FUNCTION__); */
/* 		return 0; */
/* 	} */
	len = dump_buf(buf,length,dir);
	iov.iov_base = s_buf;
	iov.iov_len  = len;
	msg.msg_control = NULL;
	msg.msg_controllen = 0;
	msg.msg_iov	 = &iov;
	msg.msg_iovlen = 1;
	msg.msg_name = &to;
	msg.msg_namelen = sizeof(to);
	oldfs = get_fs(); 
	set_fs( KERNEL_DS );
	len = sock_sendmsg( clientsocket, &msg, len );
	set_fs( oldfs );
	return len;
}

int ssd_send_async_read_msg(int Length, int ret)
{
	int len;
	struct msghdr msg;
	struct iovec iov;
	mm_segment_t oldfs;
	if(!use_sock)
		return 0;
/* 	if(! interrupt_context){ */
/* 		PWARNING("%s(): can't send in interrupt context\n", __FUNCTION__); */
/* 		return 0; */
/* 	} */
	sprintf(s_buf,"async_read %d bytes retruned: status=%d",Length, ret);
	len = strlen(s_buf);
	msg.msg_control = NULL;
	msg.msg_controllen = 0;
	msg.msg_iov	 = &iov;
	msg.msg_iovlen = 1;
	msg.msg_name = &to;
	msg.msg_namelen = sizeof(to);
	iov.iov_base = s_buf;
	iov.iov_len  = len;
	oldfs = get_fs(); 
	set_fs( KERNEL_DS );
	len = sock_sendmsg( clientsocket, &msg, len );
	set_fs( oldfs );
	return len;
}

void ssd_close_socket(void)
{
	if(!use_sock)
		return;
	if( clientsocket )
		sock_release( clientsocket );
}

#endif
EXPORT_SYMBOL(dump_buf);
