
#ifndef __DAVINCI_SDIODRV_H
#define __DAVINCI_SDIODRV_H



#define MMC_BUSMODE_OPENDRAIN	1
#define MMC_BUSMODE_PUSHPULL	2

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FLASE
#define FALSE 0
#endif

/* threshold to determine if dma is to be used. */
#define SDIO_REQUEST_DMA_QUALIFIER_LEN 64

#define SDIO_DATA_TRANSMIT_REG	MMCSD_REGS_BASE_ADDR + 0x2C
#define SDIO_DATA_RECEIVE_REG	MMCSD_REGS_BASE_ADDR + 0x28

#define TCINTEN 				(0x1<<20)

#define SDIO_ERR_EOT -30

/**************************************************************************\
* SDIO events definition
\**************************************************************************/
typedef enum {

	MMCSD_EVENT_EOFCMD = (1 << 2),
	/**< for commands with response, an end of
	 * Command + Response; for commands without response,
	 * an end of Command												*/
	MMCSD_EVENT_READ = (1 << 10),
	/**< data available with controller for reading						*/

	MMCSD_EVENT_WRITE = (1 << 9),
	/**< data required by controller for writing						*/

	MMCSD_EVENT_ERROR_CMDCRC = (1 << 7),
	/**< Error detected in the CRC during commannd
	 * - response phase													*/

	MMCSD_EVENT_ERROR_DATACRC = ((1 << 6) | (1 << 5)),
	/**< Error detected in the CRC during data transfer					*/

	MMCSD_EVENT_ERROR_CMDTIMEOUT = (1 << 4),
	/**< Timeout detected during commannd - response phase				*/

	MMCSD_EVENT_ERROR_DATATIMEOUT = (1 << 3),
	/**< Timeout detected during data transfer							*/

	MMCSD_EVENT_CARD_EXITBUSY = (1 << 1),
	/**< Card has exited busy state										*/

	MMCSD_EVENT_BLOCK_XFERRED = (1 << 0)
	/**< block transfer done											*/
} mmcsdevent;



/**************************************************************************
* Register Overlay Structure
***************************************************************************/
typedef struct {
	volatile unsigned short mmcctl;
	volatile unsigned char rsvd0[2];
	volatile unsigned short mmcclk;
	volatile unsigned char rsvd1[2];
	volatile unsigned short mmcst0;
	volatile unsigned char rsvd2[2];
	volatile unsigned short mmcst1;
	volatile unsigned char rsvd3[2];
	volatile unsigned short mmcim;
	volatile unsigned char rsvd4[2];
	volatile unsigned short mmctor;
	volatile unsigned char rsvd5[2];
	volatile unsigned short mmctod;
	volatile unsigned char rsvd6[2];
	volatile unsigned short mmcblen;
	volatile unsigned char rsvd7[2];
	volatile unsigned short mmcnblk;
	volatile unsigned char rsvd8[2];
	volatile unsigned short mmcnblc;
	volatile unsigned char rsvd9[2];
	volatile unsigned int mmcdrr;
	volatile unsigned int mmcdxr;
	volatile unsigned int mmccmd;
	volatile unsigned int mmcarghl;
	volatile unsigned int mmcrsp01;
	volatile unsigned int mmcrsp23;
	volatile unsigned int mmcrsp45;
	volatile unsigned int mmcrsp67;
	volatile unsigned short mmcdrsp;
	volatile unsigned char rsvd10[2];
	volatile unsigned short mmcetok;
	volatile unsigned char rsvd11[2];
	volatile unsigned short mmccidx;
	volatile unsigned char rsvd12[2];
	volatile unsigned short mmcckc;
	volatile unsigned char rsvd13[2];
	volatile unsigned short mmctorc;
	volatile unsigned char rsvd14[2];
	volatile unsigned short mmctodc;
	volatile unsigned char rsvd15[2];
	volatile unsigned short mmcblnc;
	volatile unsigned char rsvd16[2];
	volatile unsigned short sdioctl;
	volatile unsigned char rsvd17[2];
	volatile unsigned short sdiost0;
	volatile unsigned char rsvd18[2];
	volatile unsigned short sdioien;
	volatile unsigned char rsvd19[2];
	volatile unsigned short sdioist;
	volatile unsigned char rsvd20[2];
	volatile unsigned short mmcfifoctl;
} mmcsd_regs;


/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile mmcsd_regs *CSL_MmcsdRegsOvly;



/**************************************************************************\
* SDIO host parameters definition
\**************************************************************************/
struct mmc_davinci_host 
{
	int initialized;
	int suspended;
	struct clk *clk;
	u32 base;
	int irq;
	unsigned char bus_mode;
};


#define MMCSD_EVENT_TIMEOUT_ERROR  (MMCSD_EVENT_ERROR_DATATIMEOUT | \
			    		MMCSD_EVENT_ERROR_CMDTIMEOUT )
#define MMCSD_EVENT_CRC_ERROR  ( MMCSD_EVENT_ERROR_DATACRC  | MMCSD_EVENT_ERROR_CMDCRC)

#define MMCSD_EVENT_ERROR  ( MMCSD_EVENT_ERROR_DATATIMEOUT | \
				MMCSD_EVENT_ERROR_CMDTIMEOUT | \
				MMCSD_EVENT_ERROR_DATACRC  | \
				MMCSD_EVENT_ERROR_CMDCRC)


/**************************************************************************\
* IO request structure and types.
\**************************************************************************/

typedef enum
{
  none=0,
  read,
  write
}IO_direction;


struct IO_request{
	IO_direction direction; 
	int channel;
	void *DataBufferPointer;
	int l1_cache_aligned_datalen;
	void (*callback)(void* context, int status);/* only for async requests. */
	void* context;
};

#define RW_THRESHOLD 			16	/* read write thresholds (in bytes) can be 16 or 32 bytes  */

/* external kernel function used by the sdio driver but does not exist in a public header. */
extern void davinci_clean_channel (int chno);

extern int ssd_cmd_response_timeout;/* ommand response timeout in milliseconds */

#endif/* _DAVINCI_SDIODRV_H */
