/* 
 *
 * Gary Jennejohn <gj@denx.de>
 * Copyright (C) 2003 Gary Jennejohn
 *
 * ########################################################################
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ########################################################################
 *
 * Reset the AMAZON_SE board.
 *
 */

#include <linux/kernel.h>
#include <linux/pm.h>
#include <asm/reboot.h>
#include <asm/system.h>
#include <asm/amazon_se/amazon_se.h>

static void amazon_se_machine_restart(char *command);
static void amazon_se_machine_halt(void);
static void amazon_se_machine_power_off(void);

static void amazon_se_machine_restart(char *command)
{
	local_irq_disable();

	AMAZON_SE_REG32(AMAZON_SE_RCU_REQ) |= AMAZON_SE_RST_ALL;
	for (;;) ;
}

static void amazon_se_machine_halt(void)
{
	/* Disable interrupts and loop forever */
	printk(KERN_NOTICE "System halted.\n");
	local_irq_disable();
	for (;;) ;
}

static void amazon_se_machine_power_off(void)
{
	/* We can't power off without the user's assistance */
	printk(KERN_NOTICE "Please turn off the power now.\n");
	local_irq_disable();
	for (;;) ;
}

void amazon_se_reboot_setup(void)
{
	_machine_restart = amazon_se_machine_restart;
	_machine_halt = amazon_se_machine_halt;
//	_machine_power_off = amazon_se_machine_power_off;
	pm_power_off = amazon_se_machine_power_off;
}
