#!/bin/sh

APPS_NAME="linux-atm-2.5.0"

if [ -e sysconfig.sh ]; then
	. sysconfig.sh
	. config.sh
	. model_config.sh
else
        echo "Application "$APPS_NAME" not configured"
        exit 0
fi                                                                                                                                       

display_info "----------------------------------------------------------------------"
display_info "----------------------- build $APPS_NAME ------------------------"
display_info "----------------------------------------------------------------------"

parse_args $@

if [ $BUILD_CLEAN -eq 1 ]; then
	rm -rf .config_ok
	make -s distclean
	rm -f missing mkinstalldirs ylwrap depcomp install_sh
	rm -f config.cache
	rm -f aclocal.m4
	rm -f config.h.in
	rm -f configure
	rm -f ltmain.sh
	rm -rf autom4te.cache/
	find . -name Makefile.in | xargs rm -rf
	[ ! $BUILD_CONFIGURE -eq 1 ] && exit 0
fi

if [ "$1" = "config_only" -a ! -f .config_ok -o $BUILD_CONFIGURE -eq 1 ]; then
	if [ -f $HOSTUTILS_PATH/../share/libtool/ltmain.sh ]; then
		cp $HOSTUTILS_PATH/../share/libtool/ltmain.sh .
	else
		cp ltmain.sh.org ltmain.sh
	fi

	# NOTE!! aclocal need equal or newer than 1.6 version
	aclocal

	autoheader
	autoconf
	# NOTE!! automake need equal or newer than 1.6 version
	automake --foreign --add-missing

	AR=${IFX_AR} AS=${IFX_AS} LD=${IFX_LD} NM=${IFX_NM} CC=${IFX_CC} BUILDCC=${IFX_HOSTCC} CXX=${IFX_CXX} RANLIB=${IFX_RANLIB} OBJCOPY=${IFX_OBJCOPY} OBJDUMP=${IFX_OBJDUMP} IFX_LDFLAGS='${IFX_LDFLAGS} -nostdlib' IFX_CFLAGS=${IFX_CFLAGS} TARGET=${TARGET} BUILD=${BUILD} HOST=${HOST} ./configure --target=${TARGET} --host=${HOST} --build=${BUILD} --prefix=/usr --with-kernel-headers=${PWD}/kernel --enable-ifx-opt --program-transform-name=""

	ifx_error_check $? 
	echo -n > .config_ok
fi

if [ "$1" = "config_only" ] ;then
	exit 0
fi

make -s -C src/lib install DESTDIR=${BUILD_ROOTFS_DIR} libdir=/lib IFX_CFLAGS="${IFX_CFLAGS}" IFX_LDFLAGS="${IFX_LDFLAGS}"
ifx_error_check $? 

if [ A"$IFX_CONFIG_RFC2684" == "A1" ]; then
	make -s -C src/br2684 install DESTDIR=${BUILD_ROOTFS_DIR} libdir=/lib IFX_CFLAGS="${IFX_CFLAGS}" IFX_LDFLAGS="${IFX_LDFLAGS}"
fi

if [ A"$IFX_CONFIG_CLIP" == "A" ]; then
	make -s -C src/arpd  DESTDIR=${BUILD_ROOTFS_DIR} IFX_CFLAGS="${IFX_CFLAGS}" IFX_LDFLAGS="${IFX_LDFLAGS}"
	ifx_error_check $? 

	make -s -C src/maint atmaddr IFX_CFLAGS="${IFX_CFLAGS}" IFX_LDFLAGS="${IFX_LDFLAGS}"
	ifx_error_check $? 

	${IFX_STRIP} src/arpd/.libs/atmarpd
	ifx_error_check $? 

	cp -f src/arpd/.libs/atmarpd ${BUILD_ROOTFS_DIR}/usr/sbin/
	ifx_error_check $? 

	${IFX_STRIP} src/arpd/.libs/atmarp
	ifx_error_check $? 

	cp -f src/arpd/.libs/atmarp ${BUILD_ROOTFS_DIR}/usr/sbin/
	ifx_error_check $? 

	${IFX_STRIP} src/maint/.libs/atmaddr
	ifx_error_check $? 

	cp -f src/maint/.libs/atmaddr ${BUILD_ROOTFS_DIR}/usr/sbin/
	ifx_error_check $? 
fi

