#!/bin/sh

display_info ()
{
	echo -en "\033[1;34m"
	echo -e "$1"
	echo -en "\033[0m"
}
display_success()
{
	echo -en "\033[1;32m"
	echo -e "$1"
	echo -en "\033[0m"
}
display_error()
{
	echo -en "\033[1;31m"
	echo -e "ERROR : $1"
	echo -en "\033[0m"
	exit 1
}
check_error()
{
	if [ $1 -eq 1 ]; then
		display_error "$2 build failed\n"
	fi
}
build_tool()
{
	cd "$TOPDIR"/temp	
	display_info "\n \n "$1" \n \n"
	cd "$1"
	./configure --prefix="$HOSTUTILS_PATH"
	check_error $? "$1"
	make 
	check_error $? "$1"
	make install;
	check_error $? "$1"
	cd "$TOPDIR"/temp
}

extract()
{
	if [ "$1" = "" ]; then
		display_error "Incorrect argument"
	fi
	cleanup
    	mkdir temp
    	cp source/hostutils/"$1"/* ./temp
    	cd temp
    	for file in `ls *.tar*`;
    	do
      		tar xjf "$file"
		if [ $? -eq 1 ]; then
			display_error "Could not extract $file\n"
		fi
      		rm -f "$file"
    	done
	cd "$TOPDIR"
}

cleanup()
{
	cd "$TOPDIR"
    	rm -rf temp
}
	
test_install()
{
	cd "$TOPDIR"
	touch .test
	if [ $? -ne 0 ]; then
		display_error "You do not have write permission for "$TOPDIR"\nCannot proceed with setup."
	fi
	rm .test

}

parse_args()
{
   if [ $# -eq 0 -o "$1" = "redo" ]; then
		display_error "usage :\n./setup.sh [ all | autotools ] [ redo ]\nUse redo if you want to redo this setup.\n"
   fi
}

build_sqlzma()
{
	cd $TOPDIR
    	mkdir temp
    	cp source/hostutils/sqlzma/* ./temp
	cd ./temp
    	for file in `ls *.tar*`;
    	do
      		tar xjf "$file"
		if [ $? -eq 1 ]; then
			display_error "Could not extract $file\n"
		fi
      		rm -f "$file"
    	done
	for dir in `ls "$TOPDIR"/temp` 
	do
		cd "$TOPDIR"/temp/"$dir"
		./build.sh $HOSTUTILS_PATH 
	done
	cleanup
}

build_basic()
{
	test_install
	extract basic
	for dir in `ls "$TOPDIR"/temp` 
	do
		build_tool "$dir"
	done
	cleanup
}

display_first_banner()
{
	display_info "##########################################################"
	display_info "#                                                        #"
	display_info "# Configuring toolchain for fist use.                    #"
	display_info "# Few host utilities needed for build would be installed #"
	display_info "# These include fakeroot, cpio, genext2fs, makedevs etc  #"
	display_info "# This may take a while...                               #"
	display_info "#                                                        #"
	display_info "##########################################################"
}

display_autotools_banner()
{
	display_info
	display_info "##########################################################"
	display_info "#                                                        #"
	display_info "# GNU autotools with specific versions like m4-1.4.4 ,   #"
	display_info "# automake-1.9.2, autoconf 2.59 etc will be installed in #"
	display_info "# toolchain directory. Older versions of these utils     #" 
	display_info "# are known to cause problems for some applications'     #"
	display_info "# build. If you have a more recent linux distribution    #"
	display_info "# like Fefora Core this may not be neccessary. You may   #" 
	display_info "# skip this part and execute setup.sh under toolchain    #"
	display_info "# directory at later time.                               #"
	display_info "#                                                        #"
	display_info "##########################################################"
	display_info
}

build_autotools()
{
	test_install
	if [ ! -e ./.configured -o "$2" = "redo" ]; then
		if [ "$2" != "redo" ]; then
			display_autotools_banner
			display_info "Do you want to continue buiding GNU Autotools? [y/n]"
			read choice
		else
			choice="y"
		fi
		if [ "$choice" = "y" ]; then
			display_info "\nThis may take a while...\n"
			extract autotools
			build_tool m4-1.4.4
			build_tool autoconf-2.59
			build_tool automake-1.9.2
			build_tool make-3.81
			build_tool libtool-1.5.22
			build_tool texinfo-4.8
			if [ $? -eq 0 ]; then
				display_success "\nGNU Autotools built sucessfully\n"
			else
				display_error "\nGNU Autotools built Failed !!\n"
			fi
		fi
		cleanup
	else 
		display_info "\nToolchain already setup. \nUse redo option to redo the setup\n"
	fi
}
build_all()
{
	if [ ! -e ./.configured -o "$2" = "redo" ]; then
		if [ "$2" != "redo" ]; then
			display_first_banner
		fi
		cd "$TOPDIR"
		rm -rf hostutils/*
		build_basic
		build_autotools $@
		build_sqlzma
		cd "$TOPDIR"
		touch .configured
		display_success "\nToolchain setup complete.\n"
	else 
		display_info "\nToolchain already setup. \nUse redo option to redo the setup\n"
	fi
}

parse_args $@

TOPDIR="`pwd`"
HOSTUTILS_PATH="$TOPDIR/hostutils"

export PATH="$HOSTUTILS_PATH"/bin:"$PATH"

build_"$1" $@
